# Copyright (C) 2005 Insecure.Com LLC.
#
# Authors: Adriano Monteiro Marques <py.adriano@gmail.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

import urllib
import re
import os.path

from pprint import pprint
import cPickle

try:
    nmap = urllib.urlopen("http://www.insecure.org/cgi-bin/nmap-submit.cgi")
    classification = nmap.read()
except:
    classification = '''<option value="">Nothing in this list matches
</option><option value="2Wire|embedded||WAP">2Wire embedded WAP
</option><option value="3Com|ComOS||terminal server">3Com ComOS terminal server
</option><option value="3Com|embedded||broadband router">3Com embedded broadband router
</option><option value="3Com|embedded||PBX">3Com embedded PBX
</option><option value="3Com|embedded||router">3Com embedded router
</option><option value="3Com|embedded||switch">3Com embedded switch
</option><option value="3Com|embedded||telecom-misc">3Com embedded telecom-misc
</option><option value="3Com|embedded||terminal server">3Com embedded terminal server
</option><option value="3Com|embedded||WAP">3Com embedded WAP
</option><option value="ACC|embedded||router">ACC embedded router
</option><option value="Acorn|RISC OS||general purpose">Acorn RISC OS general purpose
</option><option value="Actiontec|embedded||broadband router">Actiontec embedded broadband router
</option><option value="Adtran|embedded||telecom-misc">Adtran embedded telecom-misc
</option><option value="Aethra|embedded||webcam">Aethra embedded webcam
</option><option value="Aironet|embedded||bridge">Aironet embedded bridge
</option><option value="Aironet|embedded||WAP">Aironet embedded WAP
</option><option value="Alcatel|embedded||broadband router">Alcatel embedded broadband router
</option><option value="Alcatel|embedded||switch">Alcatel embedded switch
</option><option value="Alcatel|embedded||telecom-misc">Alcatel embedded telecom-misc
</option><option value="Alcatel|embedded||VoIP phone">Alcatel embedded VoIP phone
</option><option value="Allied Telesyn|embedded||hub">Allied Telesyn embedded hub
</option><option value="Allied Telesyn|embedded||switch">Allied Telesyn embedded switch
</option><option value="Alpha Micro|AMOS||general purpose">Alpha Micro AMOS general purpose
</option><option value="Alteon|embedded||load balancer">Alteon embedded load balancer
</option><option value="Alteon|embedded||switch">Alteon embedded switch
</option><option value="Amiga|AmigaOS||general purpose">Amiga AmigaOS general purpose
</option><option value="APC|embedded||power-device">APC embedded power-device
</option><option value="Apollo|Domain/OS||general purpose">Apollo Domain/OS general purpose
</option><option value="Apple|A/UX||general purpose">Apple A/UX general purpose
</option><option value="Apple|embedded||printer">Apple embedded printer
</option><option value="Apple|embedded||WAP">Apple embedded WAP
</option><option value="Apple|Mac OS|7.X|general purpose">Apple Mac OS 7.X general purpose
</option><option value="Apple|Mac OS|8.X|general purpose">Apple Mac OS 8.X general purpose
</option><option value="Apple|Mac OS|9.X|general purpose">Apple Mac OS 9.X general purpose
</option><option value="Apple|Mac OS X|10.0.X|general purpose">Apple Mac OS X 10.0.X general purpose
</option><option value="Apple|Mac OS X|10.1.X|general purpose">Apple Mac OS X 10.1.X general purpose
</option><option value="Apple|Mac OS X|10.2.X|general purpose">Apple Mac OS X 10.2.X general purpose
</option><option value="Apple|Mac OS X|10.3.X|general purpose">Apple Mac OS X 10.3.X general purpose
</option><option value="Apple|Mac OS X|10.4.X|general purpose">Apple Mac OS X 10.4.X general purpose
</option><option value="Apple|Newton OS||PDA">Apple Newton OS PDA
</option><option value="Arescom|embedded||broadband router">Arescom embedded broadband router
</option><option value="Arlan|embedded||bridge">Arlan embedded bridge
</option><option value="ARRIS|embedded||broadband router">ARRIS embedded broadband router
</option><option value="Asante|embedded||hub">Asante embedded hub
</option><option value="Asante|embedded||switch">Asante embedded switch
</option><option value="Ascend|embedded||broadband router">Ascend embedded broadband router
</option><option value="Ascend|embedded||router">Ascend embedded router
</option><option value="Ascend|Embedded/OS||router">Ascend Embedded/OS router
</option><option value="Ascend|TAOS||terminal server">Ascend TAOS terminal server
</option><option value="ASCOM|embedded||broadband router">ASCOM embedded broadband router
</option><option value="Atari|Atari||game console">Atari game console
</option><option value="Atari|Atari||general purpose">Atari general purpose
</option><option value="AtheOS|AtheOS||general purpose">AtheOS general purpose
</option><option value="AudioCodes|embedded||VoIP gateway">AudioCodes embedded VoIP gateway
</option><option value="Auspex|AuspexOS||fileserver">Auspex AuspexOS fileserver
</option><option value="Avaya|embedded||PBX">Avaya embedded PBX
</option><option value="Avaya|embedded||telecom-misc">Avaya embedded telecom-misc
</option><option value="Avocent|embedded||specialized">Avocent embedded specialized
</option><option value="Avocent|embedded||terminal server">Avocent embedded terminal server
</option><option value="Axent|Windows|NT/2K/XP|firewall">Axent Windows NT/2K/XP firewall
</option><option value="AXIS|embedded||fileserver">AXIS embedded fileserver
</option><option value="AXIS|embedded||print server">AXIS embedded print server
</option><option value="AXIS|embedded||webcam">AXIS embedded webcam
</option><option value="AXIS|Linux||print server">AXIS Linux print server
</option><option value="AXIS|Linux||webcam">AXIS Linux webcam
</option><option value="Barix|embedded||media device">Barix embedded media device
</option><option value="Bay Networks|embedded||router">Bay Networks embedded router
</option><option value="Bay Networks|embedded||switch">Bay Networks embedded switch
</option><option value="Bay Networks|embedded||terminal server">Bay Networks embedded terminal server
</option><option value="BayTech|embedded||power-device">BayTech embedded power-device
</option><option value="BBIagent|Linux|2.4.X|software router">BBIagent Linux 2.4.X software router
</option><option value="Be|BeOS|4.X|general purpose">Be BeOS 4.X general purpose
</option><option value="Be|BeOS|5.X|general purpose">Be BeOS 5.X general purpose
</option><option value="Beck-IPC|embedded||specialized">Beck-IPC embedded specialized
</option><option value="Belkin|embedded||broadband router">Belkin embedded broadband router
</option><option value="Bell Labs|Plan9||general purpose">Bell Labs Plan9 general purpose
</option><option value="BenQ|embedded||WAP">BenQ embedded WAP
</option><option value="Billion|embedded||broadband router">Billion embedded broadband router
</option><option value="BinTec|embedded||broadband router">BinTec embedded broadband router
</option><option value="Blue Coat|embedded||web proxy">Blue Coat embedded web proxy
</option><option value="Blue Coat|SGOS||web proxy">Blue Coat SGOS web proxy
</option><option value="Borderware|embedded||firewall">Borderware embedded firewall
</option><option value="Bosch|embedded||webcam">Bosch embedded webcam
</option><option value="BreezeCOM|embedded||bridge">BreezeCOM embedded bridge
</option><option value="Brix Networks|embedded||specialized">Brix Networks embedded specialized
</option><option value="Brocade|embedded||switch">Brocade embedded switch
</option><option value="Brother|embedded||printer">Brother embedded printer
</option><option value="BSDI|BSD/OS|2.X|general purpose">BSDI BSD/OS 2.X general purpose
</option><option value="BSDI|BSD/OS|3.X|general purpose">BSDI BSD/OS 3.X general purpose
</option><option value="BSDI|BSD/OS|4.X|general purpose">BSDI BSD/OS 4.X general purpose
</option><option value="Cabletron|embedded||router">Cabletron embedded router
</option><option value="Cabletron|embedded||switch">Cabletron embedded switch
</option><option value="CacheFlow|CacheOS||web proxy">CacheFlow CacheOS web proxy
</option><option value="Canon|embedded||printer">Canon embedded printer
</option><option value="Cantillion|embedded||switch">Cantillion embedded switch
</option><option value="Capellix|embedded||storage-misc">Capellix embedded storage-misc
</option><option value="CastleNet|embedded||broadband router">CastleNet embedded broadband router
</option><option value="Cayman|embedded||broadband router">Cayman embedded broadband router
</option><option value="Chase|embedded||terminal server">Chase embedded terminal server
</option><option value="Checkpoint|IPSO||firewall">Checkpoint IPSO firewall
</option><option value="Checkpoint|Solaris|8|firewall">Checkpoint Solaris 8 firewall
</option><option value="Checkpoint|Windows|NT/2K/XP|firewall">Checkpoint Windows NT/2K/XP firewall
</option><option value="Cisco|CacheOS||web proxy">Cisco CacheOS web proxy
</option><option value="Cisco|CBOS||broadband router">Cisco CBOS broadband router
</option><option value="Cisco|Content Networking System||web proxy">Cisco Content Networking System web proxy
</option><option value="Cisco|embedded||bridge">Cisco embedded bridge
</option><option value="Cisco|embedded||broadband router">Cisco embedded broadband router
</option><option value="Cisco|embedded||encryption accelerator">Cisco embedded encryption accelerator
</option><option value="Cisco|embedded||hub">Cisco embedded hub
</option><option value="Cisco|embedded||load balancer">Cisco embedded load balancer
</option><option value="Cisco|embedded||router">Cisco embedded router
</option><option value="Cisco|embedded||switch">Cisco embedded switch
</option><option value="Cisco|embedded||terminal server">Cisco embedded terminal server
</option><option value="Cisco|embedded||VoIP adapter">Cisco embedded VoIP adapter
</option><option value="Cisco|embedded||VoIP phone">Cisco embedded VoIP phone
</option><option value="Cisco|embedded||WAP">Cisco embedded WAP
</option><option value="Cisco|embedded||web proxy">Cisco embedded web proxy
</option><option value="Cisco|IOS|10.X|router">Cisco IOS 10.X router
</option><option value="Cisco|IOS|11.X|router">Cisco IOS 11.X router
</option><option value="Cisco|IOS|11.X|switch">Cisco IOS 11.X switch
</option><option value="Cisco|IOS|11.X|terminal server">Cisco IOS 11.X terminal server
</option><option value="Cisco|IOS|12.X|broadband router">Cisco IOS 12.X broadband router
</option><option value="Cisco|IOS|12.X|router">Cisco IOS 12.X router
</option><option value="Cisco|IOS|12.X|switch">Cisco IOS 12.X switch
</option><option value="Cisco|IOS|12.X|WAP">Cisco IOS 12.X WAP
</option><option value="Cisco|IOS||router">Cisco IOS router
</option><option value="Cisco|NmpSW||switch">Cisco NmpSW switch
</option><option value="Cisco|PIX|4.X|firewall">Cisco PIX 4.X firewall
</option><option value="Cisco|PIX|5.X|firewall">Cisco PIX 5.X firewall
</option><option value="Cisco|PIX|6.X|firewall">Cisco PIX 6.X firewall
</option><option value="Cisco|PIX||firewall">Cisco PIX firewall
</option><option value="Cisco|vxworks||WAP">Cisco vxworks WAP
</option><option value="Clipcomm|embedded||VoIP phone">Clipcomm embedded VoIP phone
</option><option value="Cnet|embedded||broadband router">Cnet embedded broadband router
</option><option value="CNT|embedded||storage-misc">CNT embedded storage-misc
</option><option value="Cobalt|Linux|2.0.X|general purpose">Cobalt Linux 2.0.X general purpose
</option><option value="Commodore|embedded||game console">Commodore embedded game console
</option><option value="Compaq|embedded||remote management">Compaq embedded remote management
</option><option value="Compaq|embedded||WAP">Compaq embedded WAP
</option><option value="Compaq|Tru64 UNIX|4.X|general purpose">Compaq Tru64 UNIX 4.X general purpose
</option><option value="Compaq|Tru64 UNIX|5.X|general purpose">Compaq Tru64 UNIX 5.X general purpose
</option><option value="Compaq|Windows|PocketPC/CE|terminal">Compaq Windows PocketPC/CE terminal
</option><option value="Compatible Systems|embedded||broadband router">Compatible Systems embedded broadband router
</option><option value="Compatible Systems|embedded||router">Compatible Systems embedded router
</option><option value="Compex|embedded||switch">Compex embedded switch
</option><option value="CompUSA|embedded||broadband router">CompUSA embedded broadband router
</option><option value="Computone|embedded||terminal server">Computone embedded terminal server
</option><option value="Conexant|embedded||broadband router">Conexant embedded broadband router
</option><option value="Contiki|Contiki||specialized">Contiki specialized
</option><option value="Convex|ConvexOS||general purpose">Convex ConvexOS general purpose
</option><option value="Convex|SPP-UX||general purpose">Convex SPP-UX general purpose
</option><option value="Copper Mountain|embedded||terminal server">Copper Mountain embedded terminal server
</option><option value="Corega|embedded||broadband router">Corega embedded broadband router
</option><option value="Cray|UNICOS|10.X|general purpose">Cray UNICOS 10.X general purpose
</option><option value="Cray|UNICOS|8.X|general purpose">Cray UNICOS 8.X general purpose
</option><option value="Cray|UNICOS||general purpose">Cray UNICOS general purpose
</option><option value="Cray|Unisys||general purpose">Cray Unisys general purpose
</option><option value="Cyberguard|embedded||firewall">Cyberguard embedded firewall
</option><option value="Cyclades|Cyras||router">Cyclades Cyras router
</option><option value="Cyclades|Cyras||terminal server">Cyclades Cyras terminal server
</option><option value="Cyclades|Cyros||router">Cyclades Cyros router
</option><option value="Cyclades|Cyros||terminal server">Cyclades Cyros terminal server
</option><option value="D-Link|embedded||broadband router">D-Link embedded broadband router
</option><option value="D-Link|embedded||hub">D-Link embedded hub
</option><option value="D-Link|embedded||print server">D-Link embedded print server
</option><option value="D-Link|embedded||telecom-misc">D-Link embedded telecom-misc
</option><option value="D-Link|embedded||WAP">D-Link embedded WAP
</option><option value="D-Link|embedded||webcam">D-Link embedded webcam
</option><option value="Data General|AOS/VS||general purpose">Data General AOS/VS general purpose
</option><option value="Data General|DG/UX||general purpose">Data General DG/UX general purpose
</option><option value="Datavoice|embedded||CSUDSU">Datavoice embedded CSUDSU
</option><option value="DEC|BSD-misc||general purpose">DEC BSD-misc general purpose
</option><option value="DEC|DIGITAL UNIX|1.X|general purpose">DEC DIGITAL UNIX 1.X general purpose
</option><option value="DEC|DIGITAL UNIX|2.X|general purpose">DEC DIGITAL UNIX 2.X general purpose
</option><option value="DEC|DIGITAL UNIX|3.X|general purpose">DEC DIGITAL UNIX 3.X general purpose
</option><option value="DEC|DIGITAL UNIX|4.X|general purpose">DEC DIGITAL UNIX 4.X general purpose
</option><option value="DEC|DIGITAL UNIX|5.X|general purpose">DEC DIGITAL UNIX 5.X general purpose
</option><option value="DEC|embedded||router">DEC embedded router
</option><option value="DEC|embedded||terminal server">DEC embedded terminal server
</option><option value="DEC|IOS|10.X|router">DEC IOS 10.X router
</option><option value="DEC|OpenVMS|6.X|general purpose">DEC OpenVMS 6.X general purpose
</option><option value="DEC|OpenVMS|7.X|general purpose">DEC OpenVMS 7.X general purpose
</option><option value="DEC|TOPS-20||general purpose">DEC TOPS-20 general purpose
</option><option value="DEC|Ultrix||general purpose">DEC Ultrix general purpose
</option><option value="DEC|VMS||general purpose">DEC VMS general purpose
</option><option value="Dell|embedded||printer">Dell embedded printer
</option><option value="Dell|embedded||remote management">Dell embedded remote management
</option><option value="Dell|embedded||storage-misc">Dell embedded storage-misc
</option><option value="Dell|embedded||switch">Dell embedded switch
</option><option value="Digital Link|embedded||CSUDSU">Digital Link embedded CSUDSU
</option><option value="Digital Networks|embedded||switch">Digital Networks embedded switch
</option><option value="Digitel|embedded||router">Digitel embedded router
</option><option value="Draytek|embedded||broadband router">Draytek embedded broadband router
</option><option value="Easytel|embedded||broadband router">Easytel embedded broadband router
</option><option value="Edimax|embedded||broadband router">Edimax embedded broadband router
</option><option value="Edimax|embedded||print server">Edimax embedded print server
</option><option value="Efficient Networks|embedded||broadband router">Efficient Networks embedded broadband router
</option><option value="Eicon|embedded||broadband router">Eicon embedded broadband router
</option><option value="Elsa|embedded||broadband router">Elsa embedded broadband router
</option><option value="EMC|DART||fileserver">EMC DART fileserver
</option><option value="Enterasys|embedded||firewall">Enterasys embedded firewall
</option><option value="Enterasys|embedded||switch">Enterasys embedded switch
</option><option value="Epson|embedded||printer">Epson embedded printer
</option><option value="Ericsson|embedded||broadband router">Ericsson embedded broadband router
</option><option value="Ericsson|embedded||terminal server">Ericsson embedded terminal server
</option><option value="EUSSO|embedded||print server">EUSSO embedded print server
</option><option value="Exabyte|embedded||storage-misc">Exabyte embedded storage-misc
</option><option value="Extreme Networks|embedded||switch">Extreme Networks embedded switch
</option><option value="Extreme Networks|Extremeware||switch">Extreme Networks Extremeware switch
</option><option value="F5 Labs|BSDI||load balancer">F5 Labs BSDI load balancer
</option><option value="F5 Labs|embedded||load balancer">F5 Labs embedded load balancer
</option><option value="FastComm|embedded||specialized">FastComm embedded specialized
</option><option value="FiberLine|embedded||broadband router">FiberLine embedded broadband router
</option><option value="FiberLine|embedded||WAP">FiberLine embedded WAP
</option><option value="FlowPoint|embedded||broadband router">FlowPoint embedded broadband router
</option><option value="Fore|embedded||switch">Fore embedded switch
</option><option value="Fortinet|embedded||firewall">Fortinet embedded firewall
</option><option value="Foundry|embedded||load balancer">Foundry embedded load balancer
</option><option value="Foundry|IronWare||load balancer">Foundry IronWare load balancer
</option><option value="FreeBSD|FreeBSD|2.X|general purpose">FreeBSD 2.X general purpose
</option><option value="FreeBSD|FreeBSD|3.X|general purpose">FreeBSD 3.X general purpose
</option><option value="FreeBSD|FreeBSD|4.X|general purpose">FreeBSD 4.X general purpose
</option><option value="FreeBSD|FreeBSD|4.x|general purpose">FreeBSD 4.x general purpose
</option><option value="FreeBSD|FreeBSD|5.X|general purpose">FreeBSD 5.X general purpose
</option><option value="FreeBSD|FreeBSD|6.X|general purpose">FreeBSD 6.X general purpose
</option><option value="FreeSCO|Linux|2.0.X|router">FreeSCO Linux 2.0.X router
</option><option value="Galacticomm|WorldGroup||BBS">Galacticomm WorldGroup BBS
</option><option value="Gandalf|embedded||router">Gandalf embedded router
</option><option value="Gatorbox|GatorShare||bridge">Gatorbox GatorShare bridge
</option><option value="Gauntlet|Solaris|2.5.X|firewall">Gauntlet Solaris 2.5.X firewall
</option><option value="Genius|embedded||print server">Genius embedded print server
</option><option value="Global Technology Associates|embedded||firewall">Global Technology Associates embedded firewall
</option><option value="GNet|embedded||broadband router">GNet embedded broadband router
</option><option value="GNU|Hurd||general purpose">GNU Hurd general purpose
</option><option value="GrandStream|embedded||VoIP adapter">GrandStream embedded VoIP adapter
</option><option value="Grandstream|embedded||VoIP adapter">Grandstream embedded VoIP adapter
</option><option value="GrandStream|embedded||VoIP phone">GrandStream embedded VoIP phone
</option><option value="Handspring|PalmOS|5.X|PDA">Handspring PalmOS 5.X PDA
</option><option value="Hawking|embedded||print server">Hawking embedded print server
</option><option value="Hitachi|HI-UX||general purpose">Hitachi HI-UX general purpose
</option><option value="HP|BSD-misc||general purpose">HP BSD-misc general purpose
</option><option value="HP|embedded||load balancer">HP embedded load balancer
</option><option value="HP|embedded||print server">HP embedded print server
</option><option value="HP|embedded||printer">HP embedded printer
</option><option value="HP|embedded||remote management">HP embedded remote management
</option><option value="HP|embedded||scanner">HP embedded scanner
</option><option value="HP|embedded||switch">HP embedded switch
</option><option value="HP|embedded||X terminal">HP embedded X terminal
</option><option value="HP|HP-UX|10.X|general purpose">HP HP-UX 10.X general purpose
</option><option value="HP|HP-UX|11.X|general purpose">HP HP-UX 11.X general purpose
</option><option value="HP|HP-UX|7.X|general purpose">HP HP-UX 7.X general purpose
</option><option value="HP|HP-UX|9.X|general purpose">HP HP-UX 9.X general purpose
</option><option value="HP|MPE/iX||general purpose">HP MPE/iX general purpose
</option><option value="HP|Netstation||X terminal">HP Netstation X terminal
</option><option value="HP|VxWorks||switch">HP VxWorks switch
</option><option value="Huawei|VRP||router">Huawei VRP router
</option><option value="Huawei|VRP||switch">Huawei VRP switch
</option><option value="Hydra|embedded||load balancer">Hydra embedded load balancer
</option><option value="IBM|AIX|3.X|general purpose">IBM AIX 3.X general purpose
</option><option value="IBM|AIX|4.X|general purpose">IBM AIX 4.X general purpose
</option><option value="IBM|AIX|5.X|general purpose">IBM AIX 5.X general purpose
</option><option value="IBM|embedded||hub">IBM embedded hub
</option><option value="IBM|embedded||printer">IBM embedded printer
</option><option value="IBM|embedded||remote management">IBM embedded remote management
</option><option value="IBM|embedded||router">IBM embedded router
</option><option value="IBM|embedded||storage-misc">IBM embedded storage-misc
</option><option value="IBM|embedded||switch">IBM embedded switch
</option><option value="IBM|embedded||X terminal">IBM embedded X terminal
</option><option value="IBM|MVS||general purpose">IBM MVS general purpose
</option><option value="IBM|OS/2||general purpose">IBM OS/2 general purpose
</option><option value="IBM|OS/390|V2|general purpose">IBM OS/390 V2 general purpose
</option><option value="IBM|OS/390|V5|general purpose">IBM OS/390 V5 general purpose
</option><option value="IBM|OS/400|V3|general purpose">IBM OS/400 V3 general purpose
</option><option value="IBM|OS/400|V4|general purpose">IBM OS/400 V4 general purpose
</option><option value="IBM|OS/400|V5|general purpose">IBM OS/400 V5 general purpose
</option><option value="IBM|VM/CMS||general purpose">IBM VM/CMS general purpose
</option><option value="Infortrend|embedded||storage-misc">Infortrend embedded storage-misc
</option><option value="innovaphone|embedded||telecom-misc">innovaphone embedded telecom-misc
</option><option value="Intel|embedded||broadband router">Intel embedded broadband router
</option><option value="Intel|embedded||firewall">Intel embedded firewall
</option><option value="Intel|embedded||print server">Intel embedded print server
</option><option value="Intel|embedded||router">Intel embedded router
</option><option value="Intel|embedded||switch">Intel embedded switch
</option><option value="Intergraph|CLiX||general purpose">Intergraph CLiX general purpose
</option><option value="Intracom|embedded||broadband router">Intracom embedded broadband router
</option><option value="IPCop|Linux|2.2.X|firewall">IPCop Linux 2.2.X firewall
</option><option value="IPCop|Linux|2.4.X|firewall">IPCop Linux 2.4.X firewall
</option><option value="IPRoute|DOS||software router">IPRoute DOS software router
</option><option value="IQinVision|embedded||webcam">IQinVision embedded webcam
</option><option value="IronPort|AsyncOS||specialized">IronPort AsyncOS specialized
</option><option value="Isolation|embedded||encryption accelerator">Isolation embedded encryption accelerator
</option><option value="Ixia|embedded||specialized">Ixia embedded specialized
</option><option value="Juniper|JUNOS||router">Juniper JUNOS router
</option><option value="KA9Q|KA9Q||specialized">KA9Q specialized
</option><option value="Kentrox|embedded||CSUDSU">Kentrox embedded CSUDSU
</option><option value="KIRK|embedded||VoIP gateway">KIRK embedded VoIP gateway
</option><option value="Konica|embedded||printer">Konica embedded printer
</option><option value="Kronos|embedded||specialized">Kronos embedded specialized
</option><option value="Kyocera|embedded||printer">Kyocera embedded printer
</option><option value="Labtam|embedded||X terminal">Labtam embedded X terminal
</option><option value="Lantronix|embedded||switch">Lantronix embedded switch
</option><option value="Lantronix|embedded||terminal server">Lantronix embedded terminal server
</option><option value="Lantronix|Punix||print server">Lantronix Punix print server
</option><option value="Lantronix|Punix||terminal server">Lantronix Punix terminal server
</option><option value="Leunig|embedded||power-device">Leunig embedded power-device
</option><option value="Level One|embedded||broadband router">Level One embedded broadband router
</option><option value="Lexmark|embedded||printer">Lexmark embedded printer
</option><option value="LG GoldStream|embedded||router">LG GoldStream embedded router
</option><option value="Liebert|embedded||specialized">Liebert embedded specialized
</option><option value="Liebert-Hiross|embedded||specialized">Liebert-Hiross embedded specialized
</option><option value="Linksys|embedded||bridge">Linksys embedded bridge
</option><option value="Linksys|embedded||broadband router">Linksys embedded broadband router
</option><option value="Linksys|embedded||print server">Linksys embedded print server
</option><option value="Linksys|embedded||WAP">Linksys embedded WAP
</option><option value="Linux|Linux|1.X|general purpose">Linux 1.X general purpose
</option><option value="Linux|Linux|2.0.X|general purpose">Linux 2.0.X general purpose
</option><option value="Linux|Linux|2.1.X|general purpose">Linux 2.1.X general purpose
</option><option value="Linux|Linux|2.2.X|general purpose">Linux 2.2.X general purpose
</option><option value="Linux|Linux|2.3.X|general purpose">Linux 2.3.X general purpose
</option><option value="Linux|Linux|2.4.X|general purpose">Linux 2.4.X general purpose
</option><option value="Linux|Linux|2.5.X|general purpose">Linux 2.5.X general purpose
</option><option value="Linux|Linux|2.6.X|general purpose">Linux 2.6.X general purpose
</option><option value="Livingston|ComOS||terminal server">Livingston ComOS terminal server
</option><option value="Lucent|BSD-misc||general purpose">Lucent BSD-misc general purpose
</option><option value="Lucent|ComOS||terminal server">Lucent ComOS terminal server
</option><option value="lwIP|lwIP||general purpose">lwIP general purpose
</option><option value="m0n0wall|FreeBSD|4.X|firewall">m0n0wall FreeBSD 4.X firewall
</option><option value="m0n0wall|FreeBSD|5.X|firewall">m0n0wall FreeBSD 5.X firewall
</option><option value="Madge|embedded||switch">Madge embedded switch
</option><option value="Magna|embedded||router">Magna embedded router
</option><option value="Maxim-IC|TiniOS||general purpose">Maxim-IC TiniOS general purpose
</option><option value="Megabit|embedded||terminal server">Megabit embedded terminal server
</option><option value="Meridian|embedded||storage-misc">Meridian embedded storage-misc
</option><option value="Microbase|VirtuOS||general purpose">Microbase VirtuOS general purpose
</option><option value="Microplex|embedded||print server">Microplex embedded print server
</option><option value="Microsoft|DOS||general purpose">Microsoft DOS general purpose
</option><option value="Microsoft|embedded||game console">Microsoft embedded game console
</option><option value="Microsoft|Windows|2003/.NET|general purpose">Microsoft Windows 2003/.NET general purpose
</option><option value="Microsoft|Windows|3.X|general purpose">Microsoft Windows 3.X general purpose
</option><option value="Microsoft|Windows|95/98/ME|general purpose">Microsoft Windows 95/98/ME general purpose
</option><option value="Microsoft|Windows||general purpose">Microsoft Windows general purpose
</option><option value="Microsoft|Windows Longhorn||general purpose">Microsoft Windows Longhorn general purpose
</option><option value="Microsoft|Windows|NT/2K/XP|general purpose">Microsoft Windows NT/2K/XP general purpose
</option><option value="Microsoft|Windows|PocketPC/CE|PDA">Microsoft Windows PocketPC/CE PDA
</option><option value="Microsoft|Windows|PocketPC/CE|specialized">Microsoft Windows PocketPC/CE specialized
</option><option value="MikroTik|RouterOS||software router">MikroTik RouterOS software router
</option><option value="Minix|Minix||general purpose">Minix general purpose
</option><option value="Minolta|embedded||printer">Minolta embedded printer
</option><option value="Minolta|VxWorks||printer">Minolta VxWorks printer
</option><option value="MiraPoint|embedded||general purpose">MiraPoint embedded general purpose
</option><option value="Motorola|BSD-misc||general purpose">Motorola BSD-misc general purpose
</option><option value="Motorola|VxWorks||broadband router">Motorola VxWorks broadband router
</option><option value="MultiTech|embedded||firewall">MultiTech embedded firewall
</option><option value="MultiTech|embedded||telecom-misc">MultiTech embedded telecom-misc
</option><option value="MultiTech|embedded||terminal server">MultiTech embedded terminal server
</option><option value="MultiTech|embedded||VoIP gateway">MultiTech embedded VoIP gateway
</option><option value="NAT|embedded||router">NAT embedded router
</option><option value="NCD|embedded||X terminal">NCD embedded X terminal
</option><option value="NCR|BSD-misc||general purpose">NCR BSD-misc general purpose
</option><option value="NEC|UX/4800||general purpose">NEC UX/4800 general purpose
</option><option value="Necomm|embedded||broadband router">Necomm embedded broadband router
</option><option value="Neoware|NetOS||X terminal">Neoware NetOS X terminal
</option><option value="NetApp|Data ONTAP||fileserver">NetApp Data ONTAP fileserver
</option><option value="NetApp|embedded||web proxy">NetApp embedded web proxy
</option><option value="NetBSD|NetBSD||general purpose">NetBSD general purpose
</option><option value="Netburner|embedded||specialized">Netburner embedded specialized
</option><option value="Netgear|embedded||broadband router">Netgear embedded broadband router
</option><option value="Netgear|embedded||print server">Netgear embedded print server
</option><option value="Netgear|embedded||switch">Netgear embedded switch
</option><option value="Netgear|embedded||WAP">Netgear embedded WAP
</option><option value="NetJet|embedded||printer">NetJet embedded printer
</option><option value="NetMatrix|embedded||general purpose">NetMatrix embedded general purpose
</option><option value="Netopia|embedded||broadband router">Netopia embedded broadband router
</option><option value="Netopia|embedded||WAP">Netopia embedded WAP
</option><option value="NetScreen|ScreenOS||firewall">NetScreen ScreenOS firewall
</option><option value="Netscreen|ScreenOS||firewall">Netscreen ScreenOS firewall
</option><option value="NetSilicon|ThreadX||specialized">NetSilicon ThreadX specialized
</option><option value="Network Systems|embedded||router">Network Systems embedded router
</option><option value="Nexland|embedded||broadband router">Nexland embedded broadband router
</option><option value="NeXT|Mach||general purpose">NeXT Mach general purpose
</option><option value="NeXT|NeXTStep||general purpose">NeXT NeXTStep general purpose
</option><option value="NIB|embedded||printer">NIB embedded printer
</option><option value="Nokia|embedded||broadband router">Nokia embedded broadband router
</option><option value="Nokia|embedded||router">Nokia embedded router
</option><option value="Nokia|IPSO||firewall">Nokia IPSO firewall
</option><option value="Nokia|Symbian||phone">Nokia Symbian phone
</option><option value="Nortel|embedded||switch">Nortel embedded switch
</option><option value="Nortel|embedded||telecom-misc">Nortel embedded telecom-misc
</option><option value="Nortel|embedded||terminal server">Nortel embedded terminal server
</option><option value="Novell|NetWare|3.X|general purpose">Novell NetWare 3.X general purpose
</option><option value="Novell|NetWare|4.X|general purpose">Novell NetWare 4.X general purpose
</option><option value="Novell|NetWare|5.X|general purpose">Novell NetWare 5.X general purpose
</option><option value="Novell|NetWare|6.X|general purpose">Novell NetWare 6.X general purpose
</option><option value="NSG|embedded||router">NSG embedded router
</option><option value="NTT|embedded||telecom-misc">NTT embedded telecom-misc
</option><option value="Okidata|embedded||printer">Okidata embedded printer
</option><option value="Open Networks|embedded||broadband router">Open Networks embedded broadband router
</option><option value="OpenBSD|OpenBSD|2.7|general purpose">OpenBSD 2.7 general purpose
</option><option value="OpenBSD|OpenBSD|2.X|general purpose">OpenBSD 2.X general purpose
</option><option value="OpenBSD|OpenBSD|3.X|general purpose">OpenBSD 3.X general purpose
</option><option value="Pace|embedded||media device">Pace embedded media device
</option><option value="Packet Engines|embedded||router">Packet Engines embedded router
</option><option value="Packet8|embedded||VoIP adapter">Packet8 embedded VoIP adapter
</option><option value="Packeteer|pSOS||load balancer">Packeteer pSOS load balancer
</option><option value="Palm|PalmOS|3.X|PDA">Palm PalmOS 3.X PDA
</option><option value="Panasonic|embedded||broadband router">Panasonic embedded broadband router
</option><option value="Panasonic|embedded||printer">Panasonic embedded printer
</option><option value="Panasonic|embedded||webcam">Panasonic embedded webcam
</option><option value="Parks|embedded||broadband router">Parks embedded broadband router
</option><option value="PCS|embedded||specialized">PCS embedded specialized
</option><option value="Pelco|embedded||webcam">Pelco embedded webcam
</option><option value="Perle|embedded||remote management">Perle embedded remote management
</option><option value="Perle|embedded||terminal server">Perle embedded terminal server
</option><option value="Phillips|embedded||media device">Phillips embedded media device
</option><option value="Pigtail|VxWorks||VoIP phone">Pigtail VxWorks VoIP phone
</option><option value="Pirelli|embedded||broadband router">Pirelli embedded broadband router
</option><option value="Pitney Bowes|embedded||printer">Pitney Bowes embedded printer
</option><option value="Planet|embedded||switch">Planet embedded switch
</option><option value="Planet|embedded||WAP">Planet embedded WAP
</option><option value="Polycom|embedded||webcam">Polycom embedded webcam
</option><option value="PolyCom|embedded||webcam">PolyCom embedded webcam
</option><option value="PowerShow|embedded||webcam">PowerShow embedded webcam
</option><option value="Proteon|OpenRoute||router">Proteon OpenRoute router
</option><option value="Proxim|embedded||bridge">Proxim embedded bridge
</option><option value="Proxim|embedded||WAP">Proxim embedded WAP
</option><option value="QMS|embedded||printer">QMS embedded printer
</option><option value="QNX|QNX||general purpose">QNX general purpose
</option><option value="Quanterra|OS/9||specialized">Quanterra OS/9 specialized
</option><option value="Quantum|embedded||storage-misc">Quantum embedded storage-misc
</option><option value="Racal|embedded||encryption accelerator">Racal embedded encryption accelerator
</option><option value="Radionics|embedded||specialized">Radionics embedded specialized
</option><option value="Radware|embedded||load balancer">Radware embedded load balancer
</option><option value="Radware|embedded||security-misc">Radware embedded security-misc
</option><option value="Raptor|embedded||firewall">Raptor embedded firewall
</option><option value="Raptor|Solaris|2.X|firewall">Raptor Solaris 2.X firewall
</option><option value="RCA|embedded||broadband router">RCA embedded broadband router
</option><option value="Redback|AOS||router">Redback AOS router
</option><option value="Redback|embedded||broadband router">Redback embedded broadband router
</option><option value="Ricoh|embedded||printer">Ricoh embedded printer
</option><option value="Ringdale|embedded||print server">Ringdale embedded print server
</option><option value="Rio|embedded||media device">Rio embedded media device
</option><option value="RiverStone|embedded||router">RiverStone embedded router
</option><option value="RoadLanner|embedded||broadband router">RoadLanner embedded broadband router
</option><option value="Rockwell|embedded||telecom-misc">Rockwell embedded telecom-misc
</option><option value="SAR|embedded||broadband router">SAR embedded broadband router
</option><option value="Savin|embedded||printer">Savin embedded printer
</option><option value="Scientific-Atlanta|embedded||media device">Scientific-Atlanta embedded media device
</option><option value="SCO|OpenServer||general purpose">SCO OpenServer general purpose
</option><option value="SCO|SCO UNIX||general purpose">SCO SCO UNIX general purpose
</option><option value="SCO|UnixWare||general purpose">SCO UnixWare general purpose
</option><option value="Secure Computing|embedded||firewall">Secure Computing embedded firewall
</option><option value="Sega|embedded||game console">Sega embedded game console
</option><option value="Sequent|DYNIX||general purpose">Sequent DYNIX general purpose
</option><option value="Sequent|embedded||general purpose">Sequent embedded general purpose
</option><option value="SGI|IRIX|4.X|general purpose">SGI IRIX 4.X general purpose
</option><option value="SGI|IRIX|5.X|general purpose">SGI IRIX 5.X general purpose
</option><option value="SGI|IRIX|6.X|general purpose">SGI IRIX 6.X general purpose
</option><option value="Sharp|embedded||printer">Sharp embedded printer
</option><option value="Shiva|embedded||router">Shiva embedded router
</option><option value="Shiva|embedded||terminal server">Shiva embedded terminal server
</option><option value="Siemens|embedded||broadband router">Siemens embedded broadband router
</option><option value="Siemens|embedded||PBX">Siemens embedded PBX
</option><option value="Siemens|embedded||specialized">Siemens embedded specialized
</option><option value="Siemens|embedded||VoIP phone">Siemens embedded VoIP phone
</option><option value="Siemens|ReliantUNIX||general purpose">Siemens ReliantUNIX general purpose
</option><option value="Siemens|SINIX||general purpose">Siemens SINIX general purpose
</option><option value="Signal|embedded||VoIP gateway">Signal embedded VoIP gateway
</option><option value="Sipura|embedded||VoIP adapter">Sipura embedded VoIP adapter
</option><option value="SMC|embedded||broadband router">SMC embedded broadband router
</option><option value="SMC|embedded||WAP">SMC embedded WAP
</option><option value="Smoothwall|Linux|2.2.X|firewall">Smoothwall Linux 2.2.X firewall
</option><option value="Softek|embedded||specialized">Softek embedded specialized
</option><option value="SonicWall|embedded||firewall">SonicWall embedded firewall
</option><option value="SonicWall|SonicOS||firewall">SonicWall SonicOS firewall
</option><option value="Sony|embedded||robotic pet">Sony embedded robotic pet
</option><option value="Sony|Linux||game console">Sony Linux game console
</option><option value="Sony|Linux||specialized">Sony Linux specialized
</option><option value="Sony|NewsOS||general purpose">Sony NewsOS general purpose
</option><option value="Sony|Symbian||phone">Sony Symbian phone
</option><option value="Soyo|embedded||VoIP phone">Soyo embedded VoIP phone
</option><option value="SpeedStream|embedded||broadband router">SpeedStream embedded broadband router
</option><option value="Spirent|embedded||specialized">Spirent embedded specialized
</option><option value="StackTools|StackTos||general purpose">StackTools StackTos general purpose
</option><option value="Stratus|VOS||general purpose">Stratus VOS general purpose
</option><option value="Sun|embedded||remote management">Sun embedded remote management
</option><option value="Sun|embedded||storage-misc">Sun embedded storage-misc
</option><option value="Sun|Solaris|10|general purpose">Sun Solaris 10 general purpose
</option><option value="Sun|Solaris|2.X|general purpose">Sun Solaris 2.X general purpose
</option><option value="Sun|Solaris|7|general purpose">Sun Solaris 7 general purpose
</option><option value="Sun|Solaris|8|general purpose">Sun Solaris 8 general purpose
</option><option value="Sun|Solaris|9|general purpose">Sun Solaris 9 general purpose
</option><option value="Sun|SunOS||general purpose">Sun SunOS general purpose
</option><option value="Swissvoice|embedded||VoIP phone">Swissvoice embedded VoIP phone
</option><option value="Symantec|embedded||firewall">Symantec embedded firewall
</option><option value="Symantec|Solaris|8|firewall">Symantec Solaris 8 firewall
</option><option value="Symantec|Windows|NT/2K/XP|firewall">Symantec Windows NT/2K/XP firewall
</option><option value="Symbol|embedded||WAP">Symbol embedded WAP
</option><option value="Systech|embedded||specialized">Systech embedded specialized
</option><option value="Tahoe|Tahoe OS||router">Tahoe Tahoe OS router
</option><option value="Tainet|embedded||broadband router">Tainet embedded broadband router
</option><option value="Talaris|embedded||printer">Talaris embedded printer
</option><option value="Tally|embedded||printer">Tally embedded printer
</option><option value="Tandberg|embedded||X terminal">Tandberg embedded X terminal
</option><option value="Tandem|Tandem NSK||general purpose">Tandem Tandem NSK general purpose
</option><option value="Tektronix|embedded||printer">Tektronix embedded printer
</option><option value="Telebit|embedded||router">Telebit embedded router
</option><option value="Telindus|embedded||broadband router">Telindus embedded broadband router
</option><option value="Telocity|embedded||broadband router">Telocity embedded broadband router
</option><option value="Telos|embedded||media device">Telos embedded media device
</option><option value="Telsey|embedded||broadband router">Telsey embedded broadband router
</option><option value="Teltrend|embedded||router">Teltrend embedded router
</option><option value="Terayon|embedded||broadband router">Terayon embedded broadband router
</option><option value="Thales|embedded||encryption accelerator">Thales embedded encryption accelerator
</option><option value="Thomson|embedded||broadband router">Thomson embedded broadband router
</option><option value="Toshiba|embedded||broadband router">Toshiba embedded broadband router
</option><option value="Toshiba|embedded||printer">Toshiba embedded printer
</option><option value="Trancell|embedded||router">Trancell embedded router
</option><option value="Treck|Treck||general purpose">Treck general purpose
</option><option value="TrueTime|embedded||specialized">TrueTime embedded specialized
</option><option value="Turtle Beach|embedded||media device">Turtle Beach embedded media device
</option><option value="uIP|uIP||specialized">uIP specialized
</option><option value="US Robotics|embedded||switch">US Robotics embedded switch
</option><option value="US Robotics|embedded||terminal server">US Robotics embedded terminal server
</option><option value="US Robotics|embedded||WAP">US Robotics embedded WAP
</option><option value="UTStarcom|embedded||VoIP phone">UTStarcom embedded VoIP phone
</option><option value="Vanguard|embedded||router">Vanguard embedded router
</option><option value="VegaStream|embedded||VoIP gateway">VegaStream embedded VoIP gateway
</option><option value="VersaNet|embedded||terminal server">VersaNet embedded terminal server
</option><option value="Virtual Access|embedded||router">Virtual Access embedded router
</option><option value="WatchGuard|embedded||firewall">WatchGuard embedded firewall
</option><option value="Westel|embedded||broadband router">Westel embedded broadband router
</option><option value="Wiesemann &amp; Theis|embedded||specialized">Wiesemann &amp; Theis embedded specialized
</option><option value="Wooksung|embedded||telecom-misc">Wooksung embedded telecom-misc
</option><option value="WTI|embedded||power-device">WTI embedded power-device
</option><option value="WYSE|WYSE OS||terminal server">WYSE WYSE OS terminal server
</option><option value="XCD|embedded||print server">XCD embedded print server
</option><option value="Xerox|embedded||printer">Xerox embedded printer
</option><option value="xMach|xMach||general purpose">xMach general purpose
</option><option value="Xylan|embedded||switch">Xylan embedded switch
</option><option value="Xylogics|embedded||terminal server">Xylogics embedded terminal server
</option><option value="Xylogics|LynxOS||terminal server">Xylogics LynxOS terminal server
</option><option value="Xyplex|embedded||terminal server">Xyplex embedded terminal server
</option><option value="Xyplex|MAXserver||terminal server">Xyplex MAXserver terminal server
</option><option value="Zcomax|embedded||WAP">Zcomax embedded WAP
</option><option value="Zebra|embedded||printer">Zebra embedded printer
</option><option value="Zero One|embedded||print server">Zero One embedded print server
</option><option value="ZoomAir|embedded||WAP">ZoomAir embedded WAP
</option><option value="ZyXel|ZyNOS||broadband router">ZyXel ZyNOS broadband router
</option><option value="ZyXel|ZyNOS||firewall">ZyXel ZyNOS firewall
</option><option value="ZyXel|ZyNOS||switch">ZyXel ZyNOS switch
</option><option value="ZyXel|ZyNOS||WAP">ZyXel ZyNOS WAP
'''

re_class = re.compile(r".*value=\"(.*)\">(.*)")

classification = classification.split("\n")

wow = []
for i in classification:
    match = re_class.match(i)
    if match:
        wow.append(match.groups())

class_file = open(os.path.join("misc", "os_classification.dmp"), "w")
cPickle.dump(wow, class_file)
class_file.close()
