@echo off

echo Setting installation variables...
set PythonEXE=C:\Python25\python.exe
set DistDir=dist
set GTKDir=C:\GTK
set WinInstallDir=install_scripts\windows
set Output=win_install.log
set UtilsDir=install_scripts\utils

echo Writing output to %Output%

echo Removing old compilation...
rd %DistDir% /s /q > %Output%

echo Updating version and revision numbers in some files...
%PythonEXE% %UtilsDir%\version_update.py >> %Output%

echo Generating new splash with current version and revision...
%PythonEXE% %UtilsDir%\add_splash_version.py >> %Output%

echo Creating dist and dist\share directories...
mkdir %DistDir%\share
mkdir %DistDir%\share\gtk-2.0
mkdir %DistDir%\share\gtkthemeselector
mkdir %DistDir%\share\themes
mkdir %DistDir%\share\xml


echo Copying GTK's share to dist directory...
xcopy %GTKDir%\share\gtk-2.0\*.* %DistDir%\share\gtk-2.0\ /S >> %Output%
xcopy %GTKDir%\share\gtkthemeselector\*.* %DistDir%\share\gtkthemeselector\ /S >> %Output%
xcopy %GTKDir%\share\themes\*.* %DistDir%\share\themes\ /S >> %Output%
xcopy %GTKDir%\share\xml\*.* %DistDir%\share\xml\ /S >> %Output%


echo Compiling Umit using py2exe...
%PythonEXE% -OO %WinInstallDir%\setup.py py2exe >> %Output%

echo Copying some more GTK files to dist directory...
xcopy %GTKDir%\lib %DistDir%\lib /S /I >> %Output%
xcopy %GTKDir%\etc %DistDir%\etc /S /I >> %Output%


echo Removing the build directory...
rd build /s /q >> %Output%


echo Done!

