id = "rpcinfo"

description = "connects to portmapper and prints a list of all registered programs"
author = "Sven Klemm <sven@c3d2.de>"
license = "See nmaps COPYING for licence"
categories = {"safe","discovery"}

require "shortport"
require "bit"

-- rpc program numbers generated from nmap-rpc with a command like:
-- perl -ne 'if (/^([a-z0-9]+)\s+(\d+)\s/i) { print "  [$2] = $1,\n"; }' nmap-rpc | sed "s/= /= '/" | sed "s/,/',/"
-- then the comma was removed from final line
local rpc_numbers = {
  [100000] = 'rpcbind',
  [100001] = 'rstatd',
  [100002] = 'rusersd',
  [100003] = 'nfs',
  [100004] = 'ypserv',
  [100005] = 'mountd',
  [100007] = 'ypbind',
  [100008] = 'walld',
  [100009] = 'yppasswdd',
  [100010] = 'etherstatd',
  [100011] = 'rquotad',
  [100012] = 'sprayd',
  [100017] = 'rexd',
  [100018] = 'alis',
  [100019] = 'sched',
  [100020] = 'llockmgr',
  [100021] = 'nlockmgr',
  [100023] = 'statmon',
  [100024] = 'status',
  [100026] = 'bootparam',
  [100027] = 'mazewars',
  [100028] = 'ypupdated',
  [100029] = 'keyserv',
  [100030] = 'securelogin',
  [100035] = 'database',
  [100037] = 'tfsd',
  [100038] = 'nsed',
  [100039] = 'nsemntd',
  [100043] = 'showfhd',
  [100044] = 'mvsmount',
  [100055] = 'ioadmd',
  [100059] = 'showattrd',
  [100062] = 'NETlicense',
  [100065] = 'sunisamd',
  [100068] = 'cmsd',
  [100069] = 'ypxfrd',
  [100071] = 'bugtraqd',
  [100078] = 'kerbd',
  [100083] = 'ttdbserverd',
  [100087] = 'admind',
  [100099] = 'autofsd',
  [100101] = 'event',
  [100102] = 'logger',
  [100104] = 'sync',
  [100105] = 'diskinfo',
  [100106] = 'iostat',
  [100107] = 'hostperf',
  [100109] = 'activity',
  [100111] = 'lpstat',
  [100112] = 'hostmem',
  [100113] = 'sample',
  [100114] = 'x25',
  [100115] = 'ping',
  [100116] = 'rpcnfs',
  [100117] = 'hostif',
  [100118] = 'etherif',
  [100119] = 'ippath',
  [100120] = 'iproutes',
  [100121] = 'layers',
  [100122] = 'snmp',
  [100123] = 'traffic',
  [100124] = 'DNInode',
  [100131] = 'layers2',
  [100135] = 'etherif2',
  [100136] = 'hostmem2',
  [100137] = 'iostat2',
  [100138] = 'snmpv2',
  [100139] = 'sender',
  [100146] = 'amiserv',
  [100147] = 'amiaux',
  [100150] = 'ocfserv',
  [100153] = 'sunvts',
  [100155] = 'smserverd',
  [100229] = 'metad',
  [100230] = 'metamhd',
  [100231] = 'nfsauth',
  [100232] = 'sadmind',
  [100233] = 'ufsd',
  [100234] = 'gssd',
  [100235] = 'cachefsd',
  [100249] = 'snmpXdmid',
  [100300] = 'nisd',
  [100303] = 'nispasswd',
  [100304] = 'fnsypd',
  [100422] = 'mdcommd',
  [100424] = 'stfsloader',
  [150001] = 'pcnfsd',
  [200000] = 'PyramidLock',
  [200001] = 'PyramidSys5',
  [200005] = 'pdbDA',
  [200020] = 'SWG',
  [200023] = 'exportmap',
  [200034] = 'Gqsrv',
  [200035] = 'Ppt',
  [200036] = 'Pmt',
  [200037] = 'Msgt',
  [200038] = 'Walerts',
  [200039] = 'Mgt',
  [200040] = 'Pft',
  [200041] = 'Msgq',
  [200042] = 'Smpsrv',
  [200043] = 'Dexsrv',
  [200044] = 'Statussrv',
  [200046] = 'SessionServer',
  [200047] = 'SessionDaemon',
  [200048] = 'Pmsgq',
  [200049] = 'Filesrv',
  [200050] = 'Magfetch',
  [200051] = 'Optfetch',
  [200052] = 'Securitysrv',
  [200100] = 'bundle',
  [200201] = 'ecodisc',
  [200202] = 'ecolic',
  [200203] = 'eamon',
  [200205] = 'ecoad',
  [300001] = 'ADTFileLock',
  [300006] = 'fmclient',
  [300007] = 'fmeditor',
  [300009] = 'fmserver',
  [300019] = 'amd',
  [300021] = 'Steering',
  [300030] = 'UpdtAuditsS',
  [300091] = 'Dbpass',
  [300145] = 'clms',
  [300301] = 'acuserve',
  [300375] = 'rmd',
  [300376] = 'agcd',
  [300433] = 'bssd',
  [300434] = 'drdd',
  [300483] = 'cnxmond',
  [300484] = 'cnxagentd',
  [300516] = 'mcserv',
  [300527] = 'cluinfod',
  [300598] = 'dmispd',
  [300632] = 'prpasswd',
  [300664] = 'ks',
  [344444] = 'sfs',
  [351455] = 'mapsvc',
  [351457] = 'berkeleydb',
  [351473] = 'caasalert',
  [395644] = 'caservd',
  [395645] = 'calqserver',
  [395646] = 'camediadsvr',
  [395647] = 'caldbserver',
  [395648] = 'caauthd',
  [395649] = 'cadiscovd',
  [395650] = 'caloggerd',
  [390101] = 'rap',
  [390102] = 'rapserv',
  [390103] = 'nsrd',
  [390104] = 'nsrmmd',
  [390105] = 'nsrindexd',
  [390107] = 'nsrmmdbd',
  [390109] = 'nsrstat',
  [390110] = 'nsrjb',
  [390113] = 'nsrexec',
  [390115] = 'lgtolmd',
  [390400] = 'nsrnotd',
  [390600] = 'arserverd',
  [390601] = 'ntserverd',
  [390602] = 'ntclientd',
  [390603] = 'aresclsrv',
  [390604] = 'arservtcd',
  [390610] = 'flashservd',
  [390619] = 'arflashbd',
  [390620] = 'arfastsrv',
  [390621] = 'arfastsrv',
  [390622] = 'arfastsrv',
  [390623] = 'arfastsrv',
  [390624] = 'arfastsrv',
  [390625] = 'arfastsrv',
  [390626] = 'arfastsrv',
  [390627] = 'arfastsrv',
  [390628] = 'arfastsrv',
  [390629] = 'arfastsrv',
  [390630] = 'arfastsrv',
  [390631] = 'arfastsrv',
  [390632] = 'arfastsrv',
  [390633] = 'arfastsrv',
  [390634] = 'arfastsrv',
  [390635] = 'arlistsrv',
  [390636] = 'arlistsrv',
  [390637] = 'arlistsrv',
  [390638] = 'arlistsrv',
  [390639] = 'arlistsrv',
  [390640] = 'arlistsrv',
  [390641] = 'arlistsrv',
  [390642] = 'arlistsrv',
  [390643] = 'arlistsrv',
  [390644] = 'arlistsrv',
  [390645] = 'arlistsrv',
  [390646] = 'arlistsrv',
  [390647] = 'arlistsrv',
  [390648] = 'arlistsrv',
  [390649] = 'arlistsrv',
  [391434] = 'ingsqld',
  [391200] = 'afsd',
  [391201] = 'dhc',
  [391202] = 'cmsd',
  [391203] = 'xxx2trif',
  [391204] = 'trif2xxx',
  [391205] = 'dx',
  [391206] = 'licd',
  [395175] = 'asedirector',
  [395176] = 'aseagent',
  [395177] = 'asehsm',
  [395179] = 'aselogger',
  [395250] = 'pnictl',
  [450000] = 'EnsignAgent',
  [900101] = 'drac',
  [1000002] = 'AdoIfServer',
  [2000004] = 'notifServer',
  [20000000] = 'retherif',
  [20000001] = 'genagnt',
  [20000114] = 'acedb',
  [20000115] = 'aboutdb',
  [20000116] = 'aatdb',
  [20000777] = 'seagent',
  [21000023] = 'dbsrvr',
  [28000205] = 'egts',
  [28000220] = 'ers',
  [28000230] = 'sas',
  [200100001] = 'netinfobind',
  [200100002] = 'renderd',
  [536870915] = 'uidd',
  [536870916] = 'vtsk',
  [536870917] = 'bondd',
  [536870918] = 'staticd',
  [536870919] = 'curved',
  [536870920] = 'msglogd',
  [536870921] = 'aliasd',
  [536870922] = 'ticketd',
  [536870923] = 'glossd',
  [536870924] = 'futured',
  [536870928] = 'priced',
  [536870929] = 'ladderd',
  [536870937] = 'optiond',
  [536870944] = 'ndbportmgr',
  [536870945] = 'ndbserver1',
  [536870946] = 'ndbserver2',
  [536870947] = 'ndbserver3',
  [536870948] = 'ndbserver4',
  [536870949] = 'ndbserver5',
  [536870950] = 'ndbserver6',
  [536870951] = 'ndbserver7',
  [536870952] = 'ndbserver8',
  [536870953] = 'ndbserver9',
  [536870954] = 'ndbserver10',
  [536870955] = 'ndbserver11',
  [536870956] = 'ndbserver12',
  [536870957] = 'ndbserver13',
  [536870958] = 'ndbserver14',
  [536870959] = 'ndbserver15',
  [536870960] = 'ndbserver16',
  [536870961] = 'ndbserver17',
  [536870962] = 'ndbserver18',
  [536870963] = 'ndbserver19',
  [536870964] = 'ndbserver20',
  [536870965] = 'ndbserver21',
  [536870966] = 'ndbserver22',
  [536870967] = 'ndbserver23',
  [536870968] = 'ndbserver24',
  [536870969] = 'ndbserver25',
  [536870970] = 'ndbserver26',
  [536870971] = 'ndbserver27',
  [536870972] = 'ndbserver28',
  [536870973] = 'ndbserver29',
  [536870974] = 'ndbserver30',
  [536870975] = 'ndbserver31',
  [536870976] = 'ndbserver32',
  [536870977] = 'ndbserver33',
  [536870978] = 'ndbserver34',
  [536870979] = 'ndbserver35',
  [536870980] = 'ndbserver36',
  [536870981] = 'ndbserver37',
  [536870982] = 'ndbserver38',
  [536870983] = 'ndbserver39',
  [536870984] = 'ndbserver40',
  [536870985] = 'ndbserver41',
  [536870986] = 'ndbserver42',
  [536870987] = 'ndbserver43',
  [536870988] = 'ndbserver44',
  [536870989] = 'ndbserver45',
  [536870990] = 'ndbserver46',
  [536870991] = 'ndbserver47',
  [536870992] = 'ndbserver48',
  [536870993] = 'ndbserver49',
  [536870994] = 'ndbserver50',
  [536870995] = 'ndbserver51',
  [536870996] = 'ndbserver52',
  [536870997] = 'ndbserver53',
  [536870998] = 'ndbserver54',
  [536870999] = 'ndbserver55',
  [536871000] = 'ndbserver56',
  [536871001] = 'ndbserver57',
  [536871002] = 'ndbserver58',
  [536871003] = 'ndbserver59',
  [536871004] = 'ndbserver60',
  [536871005] = 'ndbserver61',
  [536871006] = 'ndbserver62',
  [536871007] = 'ndbserver63',
  [536871008] = 'ndbserver64',
  [536871009] = 'ndbserver65',
  [536871010] = 'ndbserver66',
  [536871011] = 'ndbserver67',
  [536871012] = 'ndbserver68',
  [536871013] = 'ndbserver69',
  [536871014] = 'ndbserver70',
  [536871015] = 'ndbserver71',
  [536871016] = 'ndbserver72',
  [536871017] = 'ndbserver73',
  [536871018] = 'ndbserver74',
  [536871019] = 'ndbserver75',
  [536871020] = 'ndbserver76',
  [536871021] = 'ndbserver77',
  [536871022] = 'ndbserver78',
  [536871023] = 'ndbserver79',
  [536871024] = 'ndbserver80',
  [536871025] = 'ndbserver81',
  [536871026] = 'ndbserver82',
  [536871027] = 'ndbserver83',
  [536871028] = 'ndbserver84',
  [536871029] = 'ndbserver85',
  [536871030] = 'ndbserver86',
  [536871031] = 'ndbserver87',
  [536871032] = 'ndbserver88',
  [536871033] = 'ndbserver89',
  [536871034] = 'ndbserver90',
  [536871035] = 'ndbserver91',
  [536871036] = 'ndbserver92',
  [536871037] = 'ndbserver93',
  [536871038] = 'ndbserver94',
  [536871039] = 'ndbserver95',
  [536871040] = 'ndbserver96',
  [536871041] = 'ndbserver97',
  [536871042] = 'ndbserver98',
  [536871043] = 'ndbserver99',
  [536871044] = 'ndbserver100',
  [536871680] = 'gnbk',
  [541414217] = 'fcagent',
  [591751041] = 'pnmd',
  [545580417] = 'ugidd',
  [555555555] = 'inetray',
  [555555556] = 'inetray',
  [555555557] = 'inetray',
  [555555558] = 'inetray',
  [555555559] = 'inetray',
  [555555560] = 'inetray',
  [600000001] = 'collectd',
  [600000002] = 'xycomd',
  [600000003] = 'motord',
  [600000004] = 'fitsd',
  [600100069] = 'fypxfrd',
  [611319808] = 'rdbx',
  [630474513] = 'bminrd',
  [788585389] = 'bwnfsd',
  [805306368] = 'dmispd',
  [805898569] = 'rdict',
  [822087681] = 'testpoint',
  [822087682] = 'awg',
  [822087683] = 'cgdsrtdd',
  [822087684] = 'gdsd',
  [822087685] = 'chnconfd',
  [822087686] = 'leapconfd',
  [822087687] = 'rlaunchd',
  [824395111] = 'cfsd',
  [912680550] = 'cns',
  [1073741824] = 'fmproduct',
  [1092830567] = 'cfsd',
  [1145324612] = 'rdb',
  [1289637086] = 'dtcm',
  [1289637087] = 'ttsession',
  [1342177279] = 'ttsession'
}

portrule = shortport.port_or_service(111, "rpcbind")

action = function(host, port)
  local try, catch
  local transaction_id = "nmap"
  local socket = nmap.new_socket()
  local result = ""

  catch = function() socket:close() end
  try = nmap.new_try( catch )

  local ntohl = function( s )
    return bit.lshift(s:byte(1),24) + bit.lshift(s:byte(2),16) +
           bit.lshift(s:byte(3),8) + s:byte(4)
  end

  local request = string.char(0x80,0,0,40) -- fragment header
  request = request .. transaction_id -- transaction id
  request = request .. "\0\0\0\0\0\0\0\2" -- message type: call (0) and rpc version 2
  request = request .. string.char(0,1,134,160) -- programm portmap (100000)
  request = request .. "\0\0\0\2\0\0\0\4" -- programm version (2) procedure dump(4)
  request = request .. "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"-- Credentials and verifier

  socket:set_timeout(1000)
  try( socket:connect(host.ip, port.number) )
  try( socket:send( request ) )
  local status, answer, answer_part
  status, answer = socket:receive_bytes( 1 )
  while status do
    status, answer_part = socket:receive_bytes( 1 )
    if status then answer = answer .. answer_part end
  end

  local fragment_length = answer:byte(4) + answer:byte(3) * 256 + answer:byte(2) * 65536
  if answer:sub(5,8) == transaction_id and answer:byte(12) == 1 and answer:byte(16) == 0 and answer:byte(28) == 0 then
    -- transaction_id matches, message type reply, reply state accepted and accept state executed successfully
    answer_part = answer
    answer = answer_part:sub( 28 + 1, fragment_length + 4 )
    answer_part = answer_part:sub( fragment_length + 4 + 1 )

    while answer_part:len() > 0 do -- defragment packet
      fragment_length = answer_part:byte(4) + answer_part:byte(3) * 256 + answer_part:byte(2) * 65536
      answer = answer .. answer_part:sub( 5, fragment_length + 4 )
      answer_part = answer_part:sub( fragment_length + 4 + 1 )
    end

    while answer:byte(4) == 1 and answer:len() >= 20 do
      local rpc_prog, rpc_vers, rpc_proto, rpc_port
      if result:len() > 0 then result = result .. '\n' end
      rpc_prog = ntohl( answer:sub(5,8))
      rpc_vers = ntohl( answer:sub(9,12))
      rpc_proto = ntohl( answer:sub(13,16))
      rpc_port = ntohl( answer:sub(17,20))
      answer = answer:sub(21)
      if rpc_proto == 6 then
        rpc_proto = "tcp"
      elseif rpc_proto == 17 then
        rpc_proto = "udp"
      end
      result = result .. string.format("%s(%d) %d/%s",rpc_numbers[rpc_prog] or rpc_prog,rpc_vers,rpc_port,rpc_proto)
    end

  end

  return result
end

