/*
 *
 * Panda309 Rapid Combo OS Detection & Portscanner
 *
 * Ambient Empire : http://www.thegrid.net/gravitino
 *                  chrisa@eeye.com
 *
 * Massive Greets : bind - cripto - qwer7y
 *
 */

#include "panda.h"

int usage(char *arg);

void scan2(void);
void scan3(void);

struct node *parse(char *);

int t_out;

int i1 = 1,
    i2 = 1,
    i3 = 1,
    nclass;

char *device = NULL,
     *string = NULL,
     *output = NULL;

struct node *n1st,
            *nwlk,
            *ntmp;

void main(int argc, char *argv[]) {
   FILE *fs_o = NULL;
   struct utsname hinfo;
   struct node *os, *osw;
   char errbuf[PCAP_ERRBUF_SIZE];
   int opt;
   int i, j, f = 0;
   time_t tm;

   extern char *optarg;
   extern int opterr;

   setvbuf (stdout, NULL, _IONBF, 0);

   /* very cute centering technique */
   for(i = 0; i < 78; i++) putchar('*');
   putchar('\n');
   i = (78 - sizeof(VERSION " " AUTHORS)) >> 1;
   for(j = 0; j <= i; j++) putchar(' ');
   puts(VERSION " " AUTHORS);
   for(i = 0; i < 78; i++) putchar('*');
   putchar('\n');
   
   opterr = 0; /* we like pretty output */
  
   while ((opt = getopt(argc, argv, "ls:d:o:")) != -1) {
      switch (opt) {
         case 'd':
            device = calloc(min(strlen(optarg), 15) + 1, 1);
            memcpy(device, optarg, min(strlen(optarg), 15));
            break;
         case 's':
            string = calloc(min(strlen(optarg), 15) + 1, 1);
            memcpy(string, optarg, min(strlen(optarg), 15));
            for(i = 0; i < strlen(string); i++)
               string[i] = tolower(string[i]);
            break;
         case 'l':
            os = parse(OSF);
            for(i = 0, osw = os; osw; osw = osw->n)
               printf("%s\n", osw->_.name);
            exit(0); break;
         case 'o':
            output = calloc(strlen(optarg) + 1, 1);
            memcpy(output, optarg, strlen(optarg));
            break;
         case '?': usage(argv[0]); break;
      }
   }

   if(argc - optind == 2) {
      nclass = sscanf(argv[optind++], "%i.%i.%i", &i1, &i2, &i3);
      dst_port = ntohs(atoi(argv[optind]));
   } else usage(argv[0]);

   if(!dst_port) {
      puts("error : invalid target port");
      usage(argv[0]);
   }

   if(nclass < 2) {
      puts("error : invalid network id");
      usage(argv[0]);
   }

   setuid (0);
   uname(&hinfo);
   
   printf("\nRunning on: '%s' running %s %s on a(n) %s\n\n",
      hinfo.nodename, hinfo.sysname, hinfo.release, hinfo.machine);

   if(getuid()) {
      printf(" * %s does not have root privilages\n", getlogin());
      exit(EXIT_FAILURE); /* get lost punk */
   }
   
   if(!device) {
      if((device = pcap_lookupdev(errbuf)) == NULL) {
         printf(" * pcap device lookup: %s\n", errbuf);
         exit(EXIT_FAILURE);
      }
   }

   sprintf(errbuf, "%i.%i.%i.%i", i1, i2, i3, 1);
   inet_aton(errbuf, &target_ip);

   init_devices();

   printf("Selected Interface: %s\n", device);
   printf("Interface Address: %s\n", inet_ntoa(local_ip));
   if(string) printf("OS Search String: %s\n", string);
   if(output) printf("Output Log File: %s\n", output);
   if(nclass == 2) {
      printf("Scanning Range: %i.%i.*.*:%i\n", i1, i2, ntohs(dst_port));
      printf("\nYou might want to grab a cup of coffee.\n\n");
   } else {
      printf("Scanning Range: %i.%i.%i.*:%i\n", i1, i2, i3, ntohs(dst_port));
      printf("\nThis'll take just a quick second.\n\n");
   }

   tm = time(NULL);

   if(nclass == 2) scan2();
   else scan3();

   if(!(os = parse(OSF))) {
      printf("error: configuration file '%s' contains no valid data\n", OSF);
      exit(EXIT_FAILURE);
   }
   

   if(output)
      if(!(fs_o = fopen(output, "w"))) {
         printf("error: cannot open file '%s'\n", output);
         exit(EXIT_FAILURE);
      }

   putchar('\n');
   for(nwlk = n1st; nwlk; nwlk = nwlk->n) {
      for(i = 0, osw = os; osw; osw = osw->n) {
         if(ntohs(nwlk->win) == osw->win) {
            if(!string) {
               f++;
               printf("%s\t%s\n", inet_ntoa(nwlk->_.ip), osw->_.name);
               if(output)
                  fprintf(fs_o, "%s\t%s\n", inet_ntoa(nwlk->_.ip), osw->_.name);
               i = 1; break;
            } else if(strstr(osw->_.name, string)) {
               f++;
               printf("%s\t%s\n", inet_ntoa(nwlk->_.ip), osw->_.name);
               if(output)
                  fprintf(fs_o, "%s\t%s\n", inet_ntoa(nwlk->_.ip), osw->_.name);
               i = 1; break;
            }
         }
      }

      if(!i && !string) {
         f++;
         printf("%s\t%04x:Unknown (%i)\n",
                inet_ntoa(nwlk->_.ip),
                ntohs(nwlk->win),
                ntohs(nwlk->win));
         if(output)
            fprintf(fs_o, "%s\t%04x:Unknown (%i)\n",
                    inet_ntoa(nwlk->_.ip),
                    ntohs(nwlk->win),
                    ntohs(nwlk->win));

      }
   }
      

   printf("\n- analysis complete : %i machine%sfound in %li seconds\n\n",
          f, (f == 1) ? " " : "s ", time(NULL) - tm);

   term_devices();
   if(output) fclose(fs_o);
}

int usage (char *program) {
  printf(" usage: %s [options...] <x.x[.x]> <port>\n", program);
  printf("   <x.x[.x]>       Class B or C style network ID\n"
	 "   <port>          target TCP service port\n"
         "   [-l]            list OSes in configuration file\n"
         "   [-o <file>]     store output to file\n"
         "   [-d <device>]   selected interface to listen on\n"
         "   [-s <string>]   display only hosts running OSes that\n"
         "                   match this case-insensitive string\n\n");
  exit(EXIT_FAILURE);
}

void scan2(void) {
   struct tcphdr tcp_h;
   struct ip ip;
   struct node **nn = &n1st;
   long L;
   char ipstring[16];
   time_t pop_t;

   pop_t = time(NULL);
   nwlk = ntmp = n1st = NULL;
   
   for(L = 0; L <= 0xffff; L++) {
      sprintf(ipstring, "%i.%i.%i.%i",
              i1, i2, (int)(L >> 8), (int)(L & 0xff));
      inet_aton(ipstring, &target_ip);

      if(!(L & 0xff)) {
         printf("- %i.%i.%li.* "
                 "- %.1f ip/sec "
                 "- %li seconds remain  \r",
                i1, i2, (L >> 8),
                (time(NULL) - pop_t) ? (float)L / (time(NULL) - pop_t) : 0,
                L ? (0xfeff - L) * (time(NULL) - pop_t) / L : 0);
      } else sendtcp();

      get_ippacket(&ip, (char *)&tcp_h, sizeof(tcp_h));
      if((dst_port == tcp_h.th_sport) && (SRC_P == tcp_h.th_dport))
         if(ntohs(tcp_h.th_win)) {
            *nn = nwlk = calloc(NLEN, 1);
            nn = &(*nn)->n;
            nwlk->_.ip = ip.ip_src;
            nwlk->win = tcp_h.th_win;
         }
   }

   printf("\n- waiting 10 seconds for any remaining responses\n");
   
   pop_t = time(NULL);
   
   while(time(NULL) - pop_t < 10) {
      get_ippacket(&ip, (char *)&tcp_h, sizeof(tcp_h));
      if((dst_port == tcp_h.th_sport) && (SRC_P == tcp_h.th_dport))
         if(ntohs(tcp_h.th_win)) {
            *nn = nwlk = calloc(NLEN, 1);
            nn = &(*nn)->n;
            nwlk->_.ip = ip.ip_src;
            nwlk->win = tcp_h.th_win;
         }
   }
}

void scan3(void) {
   struct tcphdr tcp_h;
   struct ip ip;
   struct node **nn = &n1st;
   int L, skip = 0;
   char ipstring[16];
   time_t pop_t;

   nwlk = ntmp = n1st = NULL;
   
   for(L = 0; L < 256; L++) {
      sprintf(ipstring, "%i.%i.%i.%i", i1, i2, i3, L);
      inet_aton(ipstring, &target_ip);

      sendtcp();

      get_ippacket(&ip, (char *)&tcp_h, sizeof(tcp_h));
      if((dst_port == tcp_h.th_sport) && (SRC_P == tcp_h.th_dport))
         if(ntohs(tcp_h.th_win)) {
            if(n1st)
               for(skip = 0, ntmp = n1st; ntmp; ntmp = ntmp->n)
                  if(ip.ip_src.s_addr == ntmp->_.ip.s_addr) {
                     skip = 1;
                     break;
                  }
            if(!skip) {
               *nn = nwlk = calloc(NLEN, 1);
               nn = &(*nn)->n;
               nwlk->_.ip = ip.ip_src;
               nwlk->win = tcp_h.th_win;
            }
         }
   }

   printf("- waiting 5 seconds for any remaining responses\n");

   pop_t = time(NULL);

   while(time(NULL) - pop_t < 5) {
      get_ippacket(&ip, (char *)&tcp_h, sizeof(tcp_h));
      if((dst_port == tcp_h.th_sport) && (SRC_P == tcp_h.th_dport))
         if(ntohs(tcp_h.th_win)) {
            if(n1st)
               for(skip = 0, ntmp = n1st; ntmp; ntmp = ntmp->n)
                  if(ip.ip_src.s_addr == ntmp->_.ip.s_addr) {
                     skip = 1;
                     break;
                  }
            if(!skip) {
               *nn = nwlk = calloc(NLEN, 1);
               nn = &(*nn)->n;
               nwlk->_.ip = ip.ip_src;
               nwlk->win = tcp_h.th_win;
            }
         }
   }
}

struct node *parse(char *filename) {
   FILE *fs;
   char line[80], *lin;
   struct node *par, *parw, **pp, ptmp;
   int i;
   
   if(!(fs = fopen(filename, "r"))) {
      printf("error: cannot open configuration file '%s'\n", filename);
      exit(EXIT_FAILURE);
   }

   par = parw = NULL;
   pp = &par;

   for(;;) {
      fgets(line, 80, fs);
      if(feof(fs)) break;
      
      lin = strtok(line, ": \n");
      if(!lin) continue;
      ptmp.win = strtol(lin, NULL, 16);

      lin = strtok(NULL, "\n");
      if(!lin) continue;
      ptmp._.name = calloc(min(strlen(lin), 70) + 1, 1);
      memcpy(ptmp._.name, lin, min(strlen(lin), 70));
      ptmp.n = NULL;

      for(i = 0; i < strlen(ptmp._.name); i++)
         ptmp._.name[i] = tolower(ptmp._.name[i]);

      *pp = parw = calloc(NLEN, 1);
      pp = &(*pp)->n;
      memcpy(parw, &ptmp, sizeof(ptmp));
   }
   fclose(fs);

   return par;
}

