// -*- c++ -*-
//
// $Id: PctestIpv6File.h,v 1.7 2001/02/07 19:35:02 bmah Exp $
//
// PctestIpv6File.h
// Bruce A. Mah <bmah@acm.org>
//
// This work was first produced by an employee of Sandia National
// Laboratories under a contract with the U.S. Department of Energy.
// Sandia National Laboratories dedicates whatever right, title or
// interest it may have in this software to the public. Although no
// license from Sandia is needed to copy and use this software,
// copying and using the software might infringe the rights of
// others. This software is provided as-is. SANDIA DISCLAIMS ANY
// WARRANTY OF ANY KIND, EXPRESS OR IMPLIED.
//
// Header class for IPv6 tests reading previously saved data from a file.
//

#ifndef PCTESTIPV6FILE_H
#define PCTESTIPV6FILE_H

#if HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */

#if STDC_HEADERS
#include <string.h>
#endif /* STDC_HEADERS */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#if HAVE_STRINGS_H
#include <strings.h>
#endif /* HAVE_STRINGS_H */

#include "pc.h"
#include "PctestIpv6.h"

class PctestIpv6File : public PctestIpv6 {

  public:

    PctestIpv6File() { 
	PctestIpv6File(0);
    };
    PctestIpv6File(int p) { 
	f = NULL;
	trs = NULL;
    };
    virtual ~PctestIpv6File() { 
	if (f) {
	    fclose(f);
	}
    };

    virtual int SetOriginName(char *t);
    virtual int SetTargetName(char *t);
    virtual int GetSocketOut();
    virtual int GetSocketIn();
    virtual int Test(TestRecord &tr);
    virtual unsigned int GetMinSize();
   
  protected:

    FILE *f;
    TestRecord *trs;		// SLL of records read from the file
    u_int minsize;		// minimum packet size

};

#endif /* PCTESTIPV6FILE_H */
