/* $Id: cmd_opts.cc,v 1.6 2002/09/28 12:06:27 mederchik Exp $ */
/*
** Copyright (C) 2001 Fyodor Yarochkin <fygrave@tigerteam.net>,
**                    Ofir Arkin       <ofir@sys-security.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** All material for nonprofit, educational use only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#include "xprobe.h"
#include "cmd_opts.h"
#include "interface.h"

extern Interface *ui;


int Cmd_Opts::is_verbose(void) {
    return verbose;
}

unsigned long Cmd_Opts::debug(void) {
    return debuglevel;
}
int Cmd_Opts::get_timeout(void) {
    return receive_timeout;
}
char *Cmd_Opts::get_target(void) {
    return target;
}

char *Cmd_Opts::get_configfile(void) {
    if (config_file)
        return config_file;
   else
       return default_config_file;
}

int Cmd_Opts::parse(int argc, char *argv[]) {
    int c;

    while((c = getopt(argc, argv, "vi:p:ho:t:d:c:r")) !=EOF) 
        switch(c) {
            case 'd':
                debuglevel = atol(optarg);
                break;
            case 'v':
                verbose++;
                break;
            case 'o':
                logfile = optarg;    
                break;
            case 'c':
                config_file = optarg; 
                break;
            case 't':
                receive_timeout = atoi(optarg);    
                if (receive_timeout <1) {
                    ui->error("Incorrect receive timeout %s\n", optarg);
                    usage(argv[0]);
                }
                break;
			case 'r':
				showroute = true;
				break;
			case 'p':
				if (parse_port(optarg) < 0)
					usage(argv[0]);
				break;
            case 'h':
            default:
                usage(argv[0]);
        }
    
    if (argc < optind + 1)
        usage(argv[0]);
    target = argv[optind];    

return 1;
}

void Cmd_Opts::usage(char *progname) {

    ui->error("usage: %s [-v] [-r] [-p proto:portnum:state] [-c configfile] [-h] [-o fname] [-t timeout] "
                   "[-d debuglv] target\n", progname);
    exit(1);
}

bool Cmd_Opts::show_route(void) {

	return showroute;
}

int Cmd_Opts::parse_port (char *portptr) {

	string portstr(portptr);
	string::size_type pos=0;
	string::size_type lastpos;
	const char *proto=NULL, *portnum=NULL, *state=NULL;
	int iportnum = 0; 
	char istate = 0;
	vector<string> tokens;
	int delimetercount=0;

	/* max len = strlen("tcp:65535:closed"); */
	if (portstr.length() > 16) {
		ui->error("-p syntax error (toolong ?)\n");
		return FAIL;	
	}

	pos = portstr.find_first_of(":");
	lastpos = portstr.find_first_not_of(":", 0);

    if (pos == string::npos) {  /* no ":" in input */
		ui->error ("-p syntax error (missing \":\" ?)\n");
        return FAIL;
    }

	/* tokenizer */
	while ((pos != string::npos || lastpos != string::npos) && delimetercount < 3) {
		tokens.push_back(portstr.substr(lastpos, pos - lastpos));
		lastpos = portstr.find_first_not_of(":", pos);
		pos = portstr.find_first_of(":", lastpos);
		delimetercount++;
	}
	
	if (delimetercount != 3){	/* either not enough or too many */
		ui->error ("-p syntax error (Not enought or too many \":\"\'s?)\n");
		return FAIL;	
	}

	state = (tokens.back()).c_str();
	tokens.pop_back();
	portnum = (tokens.back()).c_str();
	tokens.pop_back();
	proto = (tokens.back()).c_str();
	
	if (!(iportnum = atoi(portnum)) || iportnum > 65535 || iportnum < 1) {
		ui->error("-p syntax error (Incorrect port number specification)\n");
		return FAIL;
	}
	
	if (!strncasecmp(state, "open", 4))
		istate = XPROBE_TARGETP_OPEN;
	else if (!strncasecmp(state, "closed", 6))
		istate = XPROBE_TARGETP_CLOSED;
	else  {
		ui->error("-p syntax error (Unknown port state)\n");
		return FAIL;
	}

    if (!strncasecmp(proto, "tcp", 3)) 
		tcp_ports.insert(pair<int, char>(iportnum, istate));
    else if (!strncasecmp(proto, "udp", 3))
		udp_ports.insert(pair<int, char>(iportnum, istate));
    else {
        ui->error("-p syntax error (Unknown protocol)\n");
        return FAIL;
    }

	return OK;
	
}

map <int, char> *Cmd_Opts::get_tcp_ports(void) {

	return &tcp_ports;

}

map <int, char> *Cmd_Opts::get_udp_ports(void) {

	return &udp_ports;
}

Cmd_Opts::Cmd_Opts(void) {

    receive_timeout = DEF_TIMEOUT;
    verbose = 0;
    flags = 0;
    logfile = NULL;
    config_file = NULL;
    default_config_file = DEFAULT_CONFIG;
    debuglevel = DEFAULT_DEBUG_LEVEL;
    target = NULL;
	showroute = false;
}
