/* $Id: cmd_opts.h,v 1.5 2002/10/21 03:59:42 mederchik Exp $ */
/*
** Copyright (C) 2001 Fyodor Yarochkin <fygrave@tigerteam.net>,
**                    Ofir Arkin       <ofir@sys-security.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** All material for nonprofit, educational use only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef CMD_OPTS_H
#define CMD_OPTS_H

#include "xprobe.h"
#include <map>
#include <string>
#include <vector>

using namespace std;

class Cmd_Opts {
    private:
        int receive_timeout;
        char verbose;
        char flags;
        char *logfile;
        char *config_file;
        char *default_config_file;
        unsigned long debuglevel;
        char *target;
		bool showroute;
		map <int, char> tcp_ports;
		map <int, char> udp_ports;
		int parse_port(char *);
    public:
        Cmd_Opts(void);
        int is_verbose(void);
        unsigned long debug(void);
        int get_timeout(void);
        char *get_target(void);
        char *get_configfile(void);
        int parse(int argc, char *argv[]);
        void usage(char *);
		bool show_route(void);
		map <int, char> *get_tcp_ports(void);
		map <int, char> *get_udp_ports(void);
};


extern char *optarg;
extern int optind;

#endif /* CMD_OPTS_H */
