/* $Id: scan_engine.cc,v 1.3 2002/09/23 04:11:58 mederchik Exp $ */
/*
** Copyright (C) 2001 Fyodor Yarochkin <fygrave@tigerteam.net>,
**                    Ofir Arkin       <ofir@sys-security.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** All material for nonprofit, educational use only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#include "xprobe.h"
#include "scan_engine.h"
#include "interface.h"
#include "targets_list.h"
#include "xprobe_module_hdlr.h"
#include "os_matrix.h"
#include "config_set.h"

extern Targets_List *targets;
extern Xprobe_Module_Hdlr   *xmh;
extern Interface *ui;
extern OS_Name *oses;
extern Config_Set *cfg;

int Scan_Engine::init(void) {
    ui->msg("[+] Initializing scan engine\n");
    return 1;
}

int Scan_Engine::run(void) {
    Target *tg;

    ui->msg("[+] Running scan engine\n");

    while((tg = targets->getnext()) != NULL) {
		tg->show_route(cfg->show_route());
		tg->set_udp_ports(cfg->get_udp_ports());
		tg->set_tcp_ports(cfg->get_tcp_ports());
        if (tg->check_alive()) {
            ui->msg("[+] Target: %s is alive\n", inet_ntoa(tg->get_addr()));
            tg->os_probe();
        }
    }

    return 1;
}

int Scan_Engine::fini(void) {
    ui->msg("[+] Cleaning up scan engine\n");

    return 1;
}


