/* $Id: tcp_ping.cc,v 1.1 2002/08/08 11:41:42 fygrave Exp $ */
/*
** Copyright (C) 2001 Fyodor Yarochkin <fygrave@tigerteam.net>,
**                    Ofir Arkin       <ofir@sys-security.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** All material for nonprofit, educational use only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/



#include "xprobe.h"
#define _XPROBE_MODULE
#include "xplib.h"
#include "xprobe_module.h"
#include "xprobe_module_hdlr.h"
#include "interface.h"
#include "icmp_ping.h"

extern Interface *ui;



int ICMP_Ping_Mod::init(void) {

    xprobe_debug(XPROBE_DEBUG_MODULES, "%s module initialized\n", get_name());
    return OK;
}


int ICMP_Ping_Mod::exec(OS_Matrix *os, struct in_addr target) {
    xprobe_debug(XPROBE_DEBUG_MODULES, "--%s module has been executed against: %s\n", get_name(),
            inet_ntoa(target));
    os->add_result(get_id(), 1, XPROBE_MATCH_YES);
    return OK;
}

int ICMP_Ping_Mod::fini(void) {
    xprobe_debug(XPROBE_DEBUG_MODULES, "%s module has been deinitilized\n", get_name());
    return OK;
}

int ICMP_Ping_Mod::parse_keyword(int os_id, const char *kwd, const char *val)  {
    
    xprobe_debug(XPROBE_DEBUG_MODULES, "Parsing for %i : %s  = %s\n",
                                                        os_id,  kwd, val);
    return OK;
};

/* initialization function */

int icmp_ping_mod_init(Xprobe_Module_Hdlr *pt) {

    ICMP_Ping_Mod *module = new ICMP_Ping_Mod;

    xprobe_mdebug(XPROBE_DEBUG_MODULES, "Initializing the ICMP PING module\n");
    pt->register_module(module);

return OK;
}


