/* $Id: static_modules.h,v 1.1 2002/08/08 11:41:42 fygrave Exp $ */
/*
** Copyright (C) 2001 Fyodor Yarochkin <fygrave@tigerteam.net>,
**                    Ofir Arkin       <ofir@sys-security.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** All material for nonprofit, educational use only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef STATIC_MODULES_H
#define STATIC_MODULES_H

#include "xprobe_module_hdlr.h"

extern int icmp_ping_mod_init(Xprobe_Module_Hdlr *);
extern int ttl_mod_init(Xprobe_Module_Hdlr *);
extern int icmp_echo_id_mod_init(Xprobe_Module_Hdlr *);
extern int icmp_timestamp_mod_init(Xprobe_Module_Hdlr *);
extern int icmp_inforeq_mod_init(Xprobe_Module_Hdlr *);
extern int icmp_addrmask_mod_init(Xprobe_Module_Hdlr *);
extern int icmp_port_unreach_init(Xprobe_Module_Hdlr *);


typedef int(* xprobe_module_init_t)(Xprobe_Module_Hdlr *);
typedef int(* xprobe_module_exec_t)(struct in_addr);
typedef int(* xprobe_module_fini_t)(void);

xprobe_module_init_t mod_init_funcs[]= {
    icmp_ping_mod_init,
    ttl_mod_init,
    icmp_echo_id_mod_init,
    icmp_timestamp_mod_init,
    icmp_addrmask_mod_init,
    icmp_inforeq_mod_init,
	icmp_port_unreach_init,
    NULL};


#endif /* STATIC_MODULES_H */
