/* $Id: test_mod.cc,v 1.2 2003/04/22 20:00:51 fygrave Exp $ */
/*
** Copyright (C) 2003 Meder Kydyraliev <meder@areopag.net>
** Copyright (C) 2001 Fyodor Yarochkin <fygrave@tigerteam.net>,
**                    Ofir Arkin       <ofir@sys-security.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "xprobe.h"
#define _XPROBE_MODULE
#include "xplib.h"
#include "xprobe_module.h"
#include "xprobe_module_hdlr.h"
#include "target.h"
#include "interface.h"
#include "cmd_opts.h"
#include "portscanner.h"
#include "sha1.h"
#include "usi++/usi++.h"
#include <sys/wait.h>

extern Interface *ui;
extern Cmd_Opts *copts;
int done_sending=0;

void child_handler (int signum) {
	while(wait(NULL) > 0);
	signum++; //suspend warn
	done_sending = 1;
}

int Portscanner::init(void) {

    xprobe_debug(XPROBE_DEBUG_MODULES, "%s module initialized\n", get_name());
    return OK;
}


int Portscanner::exec(Target *tg, OS_Matrix *os) {
	pid_t childpid;
	unsigned int k;
	u_short j;
	char ignore_state;
	map<int, char>::iterator m_i;
	struct servent *serv;
	struct timeval start, end;

    xprobe_debug(XPROBE_DEBUG_MODULES, "--%s module has been executed against: %s\n", get_name(),
            inet_ntoa(tg->get_addr()));

	signal(SIGCHLD, child_handler); 

	tcpport = *(tg->get_tcp_toscan());
	udpport = *(tg->get_udp_toscan());
	if ((gettimeofday(&start, NULL))<0) {
		ui->msg("Portscanner::exec gettimeofday failed\n");
		return FAIL;
	}
    /* */
	if ((childpid = fork()) < 0) {
		// error
		ui->msg("[%s] fork() failed: %s\n", get_name(), strerror(errno));
		return FAIL;
	} else if (childpid) {
		// parent
		receive_packets(tg);
	} else {
		// child
		send_packets(tg);
		xprobe_mdebug(XPROBE_DEBUG_MODULES, "BUG!! send_packets returned!\n");
		/* UNEARCH: child never returns */
	}
	// everyone meets here
	
	if ((gettimeofday(&end, NULL)) < 0) {
		ui->msg("Portscanner::exec gettimeofday failed\n");
		return FAIL;
	}
	// 1st thing to do is to see what ports where filtered
    for (k=0; k < tcpport.size(); k++)
        while(!tcpport[k].get_next(&j))
			if (tcp_ports.find(j) == tcp_ports.end()){
				tcpfiltered++;
				tcp_ports.insert(pair<int, char>(j, XPROBE_TARGETP_FILTERED));
            }
        ignore_state = get_ignore_state(IPPROTO_TCP);
        if ((tcpopen && !tcpclosed && !tcpfiltered) ||
            (!tcpopen && tcpclosed && !tcpfiltered) ||
            (!tcpopen && !tcpclosed && tcpfiltered)) {
            ignore_state = 255; //lame :)
        }

    for (k=0; k < udpport.size(); k++)
        while(!udpport[k].get_next(&j))
			if (udp_ports.find(j) == udp_ports.end()){
				udpfiltered++;
				udp_ports.insert(pair<int, char>(j, XPROBE_TARGETP_FILTERED));
			}
	
	ui->msg("[+] Portscan results for %s:\n", inet_ntoa(tg->get_addr()));
	ui->msg("[+]  Stats:\n");
	ui->msg("[+]   TCP: %d - open, %d - closed, %d - filtered\n", tcpopen, tcpclosed, tcpfiltered);
	ui->msg("[+]   UDP: %d - open, %d - closed, %d - filtered\n", udpopen, udpclosed, udpfiltered);
	ui->msg("[+]   Portscan took %.2f seconds.\n",
	// convert seconds into milliseconds
	((end.tv_sec - start.tv_sec) * 1000 + (end.tv_usec - start.tv_usec)/1000)/1000.0);
	ui->msg("[+]  Details:\n");
	ui->msg("[+]   Proto\tPort Num.\tState\t\tServ. Name\n");
	for (m_i = tcp_ports.begin(); m_i != tcp_ports.end(); m_i++) {
		if (m_i->second == ignore_state)
			continue;
		ui->msg("[+]   TCP\t%d\t\t", m_i->first);
		if (m_i->second == XPROBE_TARGETP_OPEN)
			ui->msg("open\t");
		else if (m_i->second == XPROBE_TARGETP_CLOSED)
			ui->msg("closed\t"); 
		else if (m_i->second ==XPROBE_TARGETP_FILTERED)
			ui->msg("filtered");
		ui->msg("\t");
		if ((serv=getservbyport(htons(m_i->first), "tcp")) != NULL)
			if(serv->s_name != NULL) {
				ui->msg("%-s\t", serv->s_name);
			} else {
				ui->msg("%-s\t", "N/A");
			}
		else
			ui->msg("N/A\t");
		ui->msg("\n");
	}


	ignore_state = get_ignore_state(IPPROTO_UDP);
	if ((udpopen && !udpclosed && !udpfiltered) ||
		(!udpopen && udpclosed && !udpfiltered) ||
		(!udpopen && !udpclosed && udpfiltered)) {
		ignore_state = 255; //lame :)
	}


    
	for (m_i = udp_ports.begin(); m_i != udp_ports.end(); m_i++) {
		if (m_i->second == ignore_state)
			continue;
		ui->msg("[+]   UDP\t%d\t\t", m_i->first);
		if (m_i->second == XPROBE_TARGETP_OPEN)
			ui->msg("open\t");
		else if (m_i->second == XPROBE_TARGETP_CLOSED)
			ui->msg("closed\t"); 
		else if (m_i->second ==XPROBE_TARGETP_FILTERED)
			ui->msg("filtered/open");
		ui->msg("\t");
		if ((serv=getservbyport(htons(m_i->first), "udp")) != NULL)
			if(serv->s_name != NULL) {
				ui->msg("%-s\t", serv->s_name);
			} else {
				ui->msg("%-s\t", "N/A");
			}
		else
			ui->msg("N/A\t");
		ui->msg("\n");
	}

	
	//XXX: ugly fix later
	if (ignore_state == XPROBE_TARGETP_OPEN ||
		ignore_state == XPROBE_TARGETP_CLOSED ||
		ignore_state == XPROBE_TARGETP_FILTERED) {
		ui->msg("[+]  Other ports are in ");
		if (ignore_state == XPROBE_TARGETP_OPEN)
			ui->msg("open");
		if (ignore_state == XPROBE_TARGETP_CLOSED)
			ui->msg("closed");
		if (ignore_state == XPROBE_TARGETP_FILTERED)
			ui->msg("filtered");
		ui->msg(" state.\n");
	}
	// ok now we need to save this data into Target object
	tg->set_tcp_ports(&tcp_ports);
	tg->set_udp_ports(&udp_ports);
	// tg->set_udp_ports(&udp_ports);
    return OK;
}

int Portscanner::fini(void) {
    xprobe_debug(XPROBE_DEBUG_MODULES, "%s module has been deinitilized\n", get_name());
    return OK;
}

int Portscanner::send_packets(Target *tg) {
	struct in_addr remote=tg->get_addr(), local=tg->get_interface_addr();
	TCP tcpp(inet_ntoa(remote));
	UDP udpp(inet_ntoa(remote));
	unsigned int k, seq;
	unsigned short dport,sport;
	unsigned char digest[20];
	SHA1 sha;
	struct _shainput {
		struct in_addr src;
		struct in_addr dst;
		u_short sport;
		u_short dport;
	} shainput;	


	send_delay = copts->get_send_delay();

	memset(&shainput, 0, sizeof(shainput));
	shainput.src.s_addr = local.s_addr;
	shainput.dst.s_addr = remote.s_addr;
	tcpp.set_src(inet_ntoa(local));
	tcpp.set_flags(TH_SYN);
	tcpp.set_ack(0);
    tcpp.set_win(5840);
	tcpp.set_ttl(64);
	srand(time(NULL));

	udpp.set_src(inet_ntoa(local));
	udpp.set_ttl(64);
	udpp.set_id(rand());

	
    for (k=0; k < udpport.size(); k++) {
        while(!udpport[k].get_next(&dport)) {
		       if (send_delay.microsec()) usleep(send_delay.microsec());
			udpp.set_id(rand());
			udpp.set_dstport(dport);
			/* XXX: bug in libusi++ */
			udpp.set_udpsum(0);
			shainput.sport = 0;
			shainput.dport = udpp.get_dstport();
			sha.get_digest(digest,(const u_char *) &shainput, sizeof(shainput));
			// XXX: shouldn't be messing w/ int's on that level
			memcpy(&sport, digest, sizeof(sport));
			udpp.set_srcport(sport);
			udpp.sendpack("");
		}
    }


	
    for (k=0; k < tcpport.size(); k++) {
        while(!tcpport[k].get_next(&dport)) {
            if (send_delay.microsec()) usleep(send_delay.microsec());
			tcpp.set_id(rand());
			tcpp.set_tcpsum(0); // recalc tcp checksum
			tcpp.set_srcport(rand() + 1024);
			tcpp.set_dstport(dport);
			shainput.sport = tcpp.get_srcport();
			shainput.dport = tcpp.get_dstport();
			sha.get_digest(digest,(const u_char *) &shainput, sizeof(shainput));
			// XXX: shouldn't be messing w/ int's on that level
			memcpy(&seq, digest, sizeof(seq));
			tcpp.set_seq(seq);
			tcpp.sendpack("");
		}
    }
	exit (OK);
}

int Portscanner::receive_packets(Target *tg) {
    unsigned int tcpportnum = 0, udpportnum = 0;

    for (unsigned int k=0; k < tcpport.size(); k++) 
                tcpportnum += tcpport[k].size();

    for (unsigned int k=0; k < udpport.size(); k++) 
                udpportnum += udpport[k].size();
 
	int ret, done=0;
    //XXX: Modify timeout here
    Xprobe::Timeval timeout = (double)(tg->get_rtt() * 2 + (((double)copts->get_send_delay() + 0.01) * 
			    (tcpportnum + udpportnum)));
    Xprobe::Timeval tv;
	unsigned int seq;
    unsigned short sport;
	struct in_addr remote=tg->get_addr(), local=tg->get_interface_addr();
	Xprobe::Timeval start;
	char payload[1024];
	unsigned char digest[20];
	IP sn(inet_ntoa(local), IPPROTO_IP);
    struct ip *iph;
    struct tcphdr *tcph;
    struct udphdr *udph;
    struct usipp::icmphdr *icmph;
	SHA1 sha;
	struct _shainput {
		struct in_addr src;
		struct in_addr dst;
		u_short sport;
		u_short dport;
	} shainput;

	memset(&shainput, 0, sizeof(shainput));
	sn.init_device(tg->get_interface(), 0, 1500);
	tv = tg->get_rtt();
	sn.timeout(tv);
	start = Xprobe::Timeval::gettimeofday();

    /* libUSI needs a major redesign. So hard to demultiplex packets of
     * different protocol
     */
	while (!done) {
		ret = sn.sniffpack(payload, sizeof(payload));
		if (!sn.timeout()) {
            if (sn.get_proto() == IPPROTO_TCP) {
                /* should be objects iph and tcph respectively */
                tcph = (struct tcphdr *)(payload);

                shainput.src.s_addr = sn.get_dst();
                shainput.dst.s_addr = sn.get_src();
                /* should be Object TCP and method get->tcph here, do it in
                 * C way for now */
                shainput.sport = ntohs(tcph->th_dport);
                shainput.dport = ntohs(tcph->th_sport);
                sha.get_digest(digest,(const u_char *) &shainput, sizeof(shainput));
                memcpy(&seq, digest, sizeof(seq));
                if (seq == ntohl(tcph->th_ack) - 1) {
                    /* should be an object too */
                    if ((tcph->th_flags & (TH_SYN|TH_ACK)) == (TH_SYN|TH_ACK)) {
                        tcp_ports.insert(pair<int, char>(ntohs(tcph->th_sport), XPROBE_TARGETP_OPEN));
                        tcpopen++;
                    } else if (tcph->th_flags & TH_RST) {
                        tcp_ports.insert(pair<int, char>(ntohs(tcph->th_sport), XPROBE_TARGETP_CLOSED));
                        tcpclosed++;
                    }
                }
            } else if (sn.get_proto() == IPPROTO_ICMP) {
                /* should be objects iph and tcph respectively */
                //iph = (struct ip *)payload;
                icmph = (struct usipp::icmphdr *)((char *)payload);

                if (icmph->type == ICMP_DEST_UNREACH &&
                        icmph->code == ICMP_PORT_UNREACH) {
                    // THIS IS LAME SHIT.. fix later!
                    iph = (struct ip *)((char *)icmph +  sizeof(struct usipp::icmphdr));
                    udph = (struct udphdr *)((char *)iph + sizeof(struct ip));     

                    shainput.src.s_addr = sn.get_dst();
                    shainput.dst.s_addr = sn.get_src();
                    shainput.dport = ntohs(udph->dest);
                    shainput.sport = 0;
                    sha.get_digest(digest,(const u_char *) &shainput, sizeof(shainput));
                    memcpy(&sport, digest, sizeof(sport));
                    if (sport == ntohs(udph->source)) {
                        udp_ports.insert(pair<int, char>(ntohs(udph->dest), XPROBE_TARGETP_CLOSED));
                        udpclosed++;
                    }
                }
            } else if (sn.get_proto() == IPPROTO_UDP) {
                /* should be objects iph and tcph respectively */
                udph = (struct udphdr *)(payload);

                shainput.src.s_addr = sn.get_dst();
                shainput.dst.s_addr = sn.get_src();
                shainput.dport = ntohs(udph->source);
                shainput.sport = 0;
                sha.get_digest(digest,(const u_char *) &shainput, sizeof(shainput));
                memcpy(&sport, digest, sizeof(sport));
                if (sport == ntohs(udph->dest)) {
	                udp_ports.insert(pair<int, char>(ntohs(udph->source), XPROBE_TARGETP_OPEN));
                    udpopen++;
                }

            }
                
		}
//		if (done_sending && start == 0)
//			start = time(NULL);
        if (tcpportnum != 0 && (unsigned)(tcpopen + tcpclosed) == tcpportnum) // all responses received
            done = 1;
        if (tcpportnum == 0 && (unsigned)(udpopen + udpclosed) == udpportnum) // all responses received
            done = 1;
		if (done_sending) {
			if (((double)Xprobe::Timeval::gettimeofday()-(double)start) > (double)timeout)
				done=1;
			//printf("tcp open: %d closed %d portnum %d\n", tcpopen, tcpclosed, portnum);
			//printf("exit by timeout %.2f - %.2f = %.2f > %.2f\n",
			//(double)Xprobe::Timeval::gettimeofday(),
			//(double)start,
			//(double)Xprobe::Timeval::gettimeofday() - (double)start,
		       	//(double)timeout);
		}
	}
	return OK;
}

char Portscanner::get_ignore_state(int proto) {
	char retval = 0;

    switch(proto) {
        case IPPROTO_TCP:
            if (tcpopen > tcpclosed) {
                retval = XPROBE_TARGETP_OPEN;
                if (tcpfiltered > tcpopen) {
                    retval = XPROBE_TARGETP_FILTERED;
                }
            } else if (tcpclosed > tcpfiltered){
                retval = XPROBE_TARGETP_CLOSED;
            } else {
                retval = XPROBE_TARGETP_FILTERED;
            }
            break;
        case IPPROTO_UDP:
             if (udpopen > udpclosed) {
                retval = XPROBE_TARGETP_OPEN;
                if (udpfiltered > udpopen) {
                    retval = XPROBE_TARGETP_FILTERED;
                }
            } else if (udpclosed > udpfiltered){
                retval = XPROBE_TARGETP_CLOSED;
            } else {
                retval = XPROBE_TARGETP_FILTERED;
            }
             break;
    }
	return retval;

}

/* initialization function */

int portscan_mod_init(Xprobe_Module_Hdlr *pt, char *nm) {

    Portscanner *port_scan= new Portscanner;

    port_scan->set_name(nm);
    xprobe_mdebug(XPROBE_DEBUG_MODULES, "Initializing the portscanning module\n");
    pt->register_module(port_scan);

return OK;
}


