/*
   CIPE - encrypted IP over UDP tunneling

   ciped.h - prototypes for user level routines

   Copyright 1997 Olaf Titz <olaf@bigred.inka.de>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version
   2 of the License, or (at your option) any later version.
*/
/* $Id: ciped.h,v 1.5 2000/07/29 00:33:35 olaf Exp $ */

#include <signal.h>
#include <netinet/in.h>
#include "cipe.h"
#include "options.h"

/* ciped.c */
extern sig_atomic_t gotsig;
extern void setsig(int sig, void (*fun)(int));
extern void logd(int lev, const char *f, int d);
extern void logs(int lev, const char *f, const char *s);
extern void logerr(int lev, const char *s);

/* socks5.c */
#define S5_CONN		1
#define S5_BIND		2
#define S5_UDP		3
extern int socks5_open(struct sockaddr_in *so);
int socks5_cmd(int fd, int cmd, struct sockaddr_in *so);

/* options.c */
struct options {
    const char * const oname;
    const char otyp;
    union {
	int ovint;
	char *ovstr;
	struct sockaddr_in *ovsaddr;
    } ov;
};
extern struct options opts[];
#define Tbool	0
#define Tint	1
#define Tstr	2
#define Taddr	3
#define Tuaddr	4
#define Ttaddr	5
#define Tsecret 6

#define OI(x)      (opts[O##x].ov.ovint)
#define OS(x)      (opts[O##x].ov.ovstr)
#define OA(x)      (opts[O##x].ov.ovsaddr)
#define OAaddr(x)  (OA(x)->sin_addr)
#define OAport(x)  (OA(x)->sin_port)
