#ifdef __cplusplus
extern "C" {
#endif

#include "hexdump.h"

#ifndef NDIS_MINIPORT_DRIVER

void (*DbgMessage)(char *p_Format, ...) = DisplayDebugString;

void DisplayDebugString (char *p_Format, ...)
   {
    static char l_Buffer [4096];

    va_list l_ArgumentList; 
    va_start (l_ArgumentList, p_Format); 
    vsprintf (l_Buffer, p_Format, l_ArgumentList); 
    va_end (l_ArgumentList); 

    OutputDebugStringA (l_Buffer);
   }

#endif

void HexDump (unsigned char *p_Buffer, unsigned long p_Size)
   {
    unsigned long l_Index, l_Idx;
    unsigned char l_Row [17];

    for (l_Index = l_Row [16] = 0; l_Index < p_Size || l_Index % 16; ++l_Index)
       {
        if (l_Index % 16 == 0) DbgPrint ("%05x   ", l_Index);
        DbgPrint ("%02x ", l_Row [l_Index % 16] = (l_Index < p_Size ? p_Buffer [l_Index] : 0));
        l_Row [l_Index % 16] = IfPrint (l_Row [l_Index % 16]);
        if ((l_Index + 1) % 16 == 0) DbgPrint ("   %s\n", l_Row);
       }

    DbgPrint ("\n");
   }

#ifdef __cplusplus
}
#endif
