#ifdef __cplusplus
extern "C" {
#endif

#include "macinfo.h"

unsigned char HexStringToDecimalInt (unsigned char p_Character)
   {
    unsigned char l_Value = 0;

    if (p_Character >= 'A' && p_Character <= 'F')
       l_Value = (p_Character - 'A') + 10;
    else if (p_Character >= 'a' && p_Character <= 'f')
       l_Value = (p_Character - 'a') + 10;
    else if (p_Character >= '0' && p_Character <= '9')
       l_Value = p_Character - '0';

    return l_Value;
   }

void ConvertMacInfo (unsigned char *p_Destination, unsigned char *p_Source, unsigned long p_Length)
   {
    unsigned long l_Index, l_HexIdx, l_Ind = 0, l_Init = 1;

    ASSERT (p_Destination);
    ASSERT (p_Source);
    ASSERT (p_Length);

    for (l_Index = l_HexIdx = l_Ind = 0; l_Index < p_Length && l_HexIdx < 6 && p_Source [l_Index]; ++l_Index)
       {
        if (IsMacDelimiter (p_Source [l_Index]))
           l_Ind = 0, ++l_HexIdx, l_Init = 1;
        else if (++l_Ind == 3)
           (++l_HexIdx < 6 ? (p_Destination [l_HexIdx] = HexStringToDecimalInt (p_Source [l_Index]), l_Ind = 0) : 0);
        else
           p_Destination [l_HexIdx] = (l_Init ? 0 : p_Destination [l_HexIdx] * 16) + HexStringToDecimalInt (p_Source [l_Index]), l_Init = 0;
       }
   }

#ifdef __cplusplus
}
#endif
