#ifndef CipeEncryptorDefined
#define CipeEncryptorDefined

#include <windows.h>
#include <wincrypt.h>
#include "constants.h"

#include "CipeBase.h"
#include "string"

using namespace std;

typedef enum
   {
    KEY_STATIC_PRIMARY,
    KEY_STATIC_SECONDARY,
    KEY_DYNAMIC_ENCRYPT,
    KEY_DYNAMIC_DECRYPT,
    KEY_LIMIT
   }
CipeEncryptionKeyType;

class CipeEncryptorException
   {
   };

class CipeEncryptor : public CipeBase
   {
    protected: static HCRYPTPROV m_CryptoContext;

    public:    CipeEncryptor() throw (CipeEncryptorException);

    public:    virtual void InstallKey (unsigned char *p_KeyData, CipeEncryptionKeyType p_KeyType) = 0;
               virtual void InstallKey (CipeEncryptionKeyType p_KeyType) = 0;
               virtual void InstallStaticKey (const char *p_TextKey) = 0;

               virtual void InstallStaticKey (string &p_TextKey)
                  {
                   InstallStaticKey (p_TextKey.c_str());
                  }

    public:    virtual void SaveKeyData (unsigned char *p_KeyData, CipeEncryptionKeyType p_KeyType) = 0;
               virtual unsigned char *GenerateDynamicKeyData (CipeEncryptionKeyType p_KeyType) = 0;
               virtual unsigned char *GenerateDynamicKeyData() = 0;

    public:    virtual unsigned long KeyDataSize()
                  {
                   return 0;
                  }

    public:    virtual unsigned long Encrypt
                  (
                   unsigned char *p_Out,
                   unsigned char *p_In,
                   unsigned long p_Length,
                   CipeEncryptionKeyType p_KeyType = KEY_DYNAMIC_ENCRYPT,
                   unsigned long p_Options = 0
                  ) = 0;

               virtual unsigned long Decrypt
                  (
                   unsigned char *p_Out,
                   unsigned char *p_In,
                   unsigned long p_Length,
                   CipeEncryptionKeyType p_KeyType,
                   unsigned long &p_Options
                  ) = 0;
   };

#endif
