#ifndef CipeIdeaEncryptorDefined
#define CipeIdeaEncryptorDefined

#include "CipeEncryptor.h"
#include "constants.h"
#include "idea.h"

#define IDEA_KEY_LENGTH Idea_userKeySize
#define IDEA_DATA_SIZE sizeof (Idea_Data)

class CipeIdeaEncryptorException
   {
   };

class CipeIdeaEncryptor : public virtual CipeEncryptor
   {
    private:   CipeEncryptionKeyType m_PreferredStaticKey, m_EncryptKey, m_DecryptKey;
               Idea_UserKey m_KeyData [KEY_LIMIT];
               Idea_Key m_Key [KEY_LIMIT];
               BOOL m_HaveKey [KEY_LIMIT];

    public:    CipeIdeaEncryptor();

    public:    virtual void InstallKey (unsigned char *p_KeyData, CipeEncryptionKeyType p_KeyType);
               virtual void InstallKey (CipeEncryptionKeyType p_KeyType);
               virtual void InstallStaticKey (const char *p_TextKey);

    public:    virtual void SaveKeyData (unsigned char *p_KeyData, CipeEncryptionKeyType p_KeyType);
               virtual unsigned char *GenerateDynamicKeyData (CipeEncryptionKeyType p_KeyType);
               virtual unsigned char *GenerateDynamicKeyData();

    public:    virtual unsigned long KeyDataSize() {return IDEA_KEY_LENGTH;}

    public:    virtual unsigned long Encrypt
                  (
                   unsigned char *p_Out,
                   unsigned char *p_In,
                   unsigned long p_Length,
                   CipeEncryptionKeyType p_KeyType = KEY_DYNAMIC_ENCRYPT,
                   unsigned long p_Options = (unsigned long) NK_DATA
                  );

               virtual unsigned long Decrypt
                  (
                   unsigned char *p_Out,
                   unsigned char *p_In,
                   unsigned long p_Length,
                   CipeEncryptionKeyType p_KeyType,
                   unsigned long &p_Options
                  );

    private:   unsigned long BlockEncrypt (unsigned char *p_Buffer, unsigned long p_Length, Idea_Key &p_Key);
               unsigned long BlockDecrypt (unsigned char *p_Buffer, unsigned long p_Length, Idea_Key &p_Key);
   };

#endif
