#ifndef CipeNullEncryptorDefined
#define CipeNullEncryptorDefined

#include "constants.h"

#include "CipeEncryptor.h"
#include "string"

using namespace std;

class CipeNullEncryptorException
   {
   };

class CipeNullEncryptor : public virtual CipeEncryptor
   {
    public:    CipeNullEncryptor();

    public:    virtual void InstallKey (unsigned char *p_KeyData, CipeEncryptionKeyType p_KeyType) {}
               virtual void InstallKey (CipeEncryptionKeyType p_KeyType) {}
               virtual void InstallStaticKey (const char *p_TextKey) {}

    public:    virtual void SaveKeyData (unsigned char *p_KeyData, CipeEncryptionKeyType p_KeyType) {}
               virtual unsigned char *GenerateDynamicKeyData (CipeEncryptionKeyType p_KeyType) {return 0;}
               virtual unsigned char *GenerateDynamicKeyData() {return 0;}

    public:    virtual unsigned long Encrypt
                  (
                   unsigned char *p_Out,
                   unsigned char *p_In,
                   unsigned long p_Length,
                   CipeEncryptionKeyType p_KeyType = KEY_DYNAMIC_ENCRYPT,
                   unsigned long p_Options = 0
                  );

               virtual unsigned long Decrypt
                  (
                   unsigned char *p_Out,
                   unsigned char *p_In,
                   unsigned long p_Length,
                   CipeEncryptionKeyType p_KeyType,
                   unsigned long &p_Options
                  );
   };

#endif
