#ifndef CipePeerDefined
#define CipePeerDefined

#include "windows.h"

#include "CipeAdapter.h"
#include "CipeBase.h"
#include "string"
#include "vector"

using namespace std;

class CipePeerException
   {
   };

class CipePeer : public CipeBase
   {
    private:   CipeAdapter &m_Adapter;

    private:   string m_ShutdownScript;
               string m_StartupScript;
               string m_EncryptionType;
               string m_OriginalName;
               string m_TextKey;
               string m_Name;

               unsigned long m_PacketTimeout;
               unsigned long m_KeyTimeout;

               // IP Data

               unsigned short m_PeerPort, m_LocalPort;
               string m_PeerIP, m_LocalIP;
               string m_PeerPTP;

               BOOL m_Enabled;

    private:   BOOL m_DeleteOnSave;

    public:    CipePeer (string &p_Name, CipeAdapter &p_Adapter) throw (CipePeerException);
               CipePeer (CipeAdapter &p_Adapter);
               ~CipePeer();

    public:    void Load() throw (CipePeerException);
               void Commit() throw (CipePeerException);
               void Clear();

    public:    void Report();

    public:    unsigned long  PacketTimeout() {return m_PacketTimeout;}
               unsigned long  KeyTimeout()    {return m_KeyTimeout;}
               unsigned long  LocalPTP()      {return m_Adapter.Address();}
               string&        PeerPTP()       {return m_PeerPTP;}
               string&        LocalIP()       {return m_LocalIP;}
               string&        PeerIP()        {return m_PeerIP;}

               unsigned short LocalPort()     {return m_LocalPort;}
               unsigned short PeerPort()      {return m_PeerPort;}

               string   RegistryPath()        {return m_Adapter.RegPeerPath() + "\\" + m_Name;}
               string&  StartupScript()       {return m_StartupScript;}
               string&  ShutdownScript()      {return m_ShutdownScript;}
               string&  TextKey()             {return m_TextKey;}
               string&  DisplayName()         {return m_Name;}
               string&  Name()                {return m_Name;}
               string&  EncryptionType()      {return m_EncryptionType;}
               CipeAdapter& Adapter()         {return m_Adapter;}

               BOOL     Enabled()             {return m_Enabled;}

    public:    void SetName (string &p_Name)              {m_Name = p_Name; if (m_OriginalName == "") m_OriginalName = m_Name;}
               void SetPeerPTP (string &p_Address)        {m_PeerPTP = p_Address;}
               void SetLocalIP (string &p_Address)        {m_LocalIP = p_Address;}
               void SetPeerIP (string &p_Address)         {m_PeerIP = p_Address;}
               void SetLocalPort (string &p_PortNum)      {m_LocalPort = htons (str_num (p_PortNum));}
               void SetPeerPort (string &p_PortNum)       {m_PeerPort = htons (str_num (p_PortNum));}
               void SetEncryptionType (string &p_Type)    {m_EncryptionType = p_Type;}
               void SetStartupScript (string &p_Script)   {m_StartupScript = p_Script;}
               void SetShutdownScript (string &p_Script)  {m_ShutdownScript = p_Script;}
               void SetTextKey (string &p_KeyText)        {m_TextKey = p_KeyText;}
               void SetPacketTimeout (string &p_Timeout)  {m_PacketTimeout = str_num (p_Timeout);}
               void SetKeyTimeout (string &p_Timeout)     {m_KeyTimeout = str_num (p_Timeout);}
               void SetEnabled (BOOL p_State = TRUE)      {m_Enabled = p_State;}

    public:    void MarkForDeletion()                     {m_DeleteOnSave = TRUE;}
               void ClearDeletionMark()                   {m_DeleteOnSave = FALSE;}
   };

class CipePeerList : public CipeBase, public vector <CipePeer *>
   {
    private:   CipeAdapterList m_AdapterList;

    public:    CipePeerList();
               ~CipePeerList();

    public:    void Commit();
               void Purge();
               void Load();

    public:    CipeAdapterList &AdapterList() {return m_AdapterList;}

    public:    CipePeer &operator[] (unsigned long p_Subscript) throw (CipeSubscriptException)
                  {
                   CipePeer *l_Return = NULL;

                   if (p_Subscript >= size())
                      throw CipeSubscriptException();
                   else if ((l_Return = ((vector <CipePeer *> *) this)->operator[] (p_Subscript)) == NULL)
                      throw CipeSubscriptException();

                   return *l_Return;
                  }

    public:    void Report();
   };

#endif
