#ifndef CipeAdapterDefined
#define CipeAdapterDefined

#include "constants.h"
#include "windows.h"
#include "hexdump.h"

#include "CipeBase.h"
#include "string"
#include "vector"

using namespace std;

class CipeAdapterException
   {
   };

class CipeAdapter : public CipeBase
   {
    private:   unsigned long m_AdapterAddress;
               unsigned long m_AdapterNumber;
               string m_AdapterName;
               string m_AdapterID;
               string m_InUseBy;

    public:    CipeAdapter (HKEY &p_Key, string &p_Name) throw (CipeAdapterException);
               ~CipeAdapter();

    public:    void Load (HKEY &p_Key) throw (CipeAdapterException);
               void Commit();

    public:    unsigned long Address()      {return m_AdapterAddress;}
               string DisplayName()         {return m_AdapterID;}
               string TapName()             {return string (USERMODEDEVICEDIR) + Name() + TAPSUFFIX;}
               string &Name()               {return m_AdapterName;}
               string &InUseBy()            {return m_InUseBy;}

    public:    string RegServicePath()      {return string (REG_SERVICE_KEY) + "\\" + Name();}
               string RegParameterPath()    {return RegServicePath() + "\\Parameters";}
               string RegPeerPath()         {return RegParameterPath() + "\\Peer";}
               string RegTcpipPath()        {return RegParameterPath() + "\\Tcpip";}

    public:    void Report();

    public:    BOOL IsUsable()              {return IsThisMyProduct (m_InUseBy);}
   };

class CipeAdapterList : public CipeBase, public vector <CipeAdapter *>
   {
    public:    CipeAdapterList();
               ~CipeAdapterList();

    public:    void Commit();
               void Purge();
               void Load();

    public:    CipeAdapter &operator[] (unsigned long p_Subscript) throw (CipeSubscriptException)
                  {
                   CipeAdapter *l_Return = NULL;

                   if (p_Subscript >= size())
                      throw CipeSubscriptException();
                   else if ((l_Return = ((vector <CipeAdapter *> *) this)->operator[] (p_Subscript)) == NULL)
                      throw CipeSubscriptException();

                   return *l_Return;
                  }

    public:    void Report();
   };

#endif
