#include "CipeGenericIO.h"
#include "hexdump.h"

//========================================================================================
//
//========================================================================================
BOOL CipeGenericIO::m_CipeGenericInitialized = FALSE;

MACADDR CipeGenericIO::m_NextMAC;

//========================================================================================
//
//========================================================================================
void CipeGenericIO::ClassConstructor()
   {
    memcpy (m_NextMAC, BroadcastMAC(), sizeof (MACADDR));
    m_CipeGenericInitialized = TRUE;
   }

//========================================================================================
//
//========================================================================================
CipeGenericIO::CipeGenericIO() throw (CipeGenericIOException) : m_ShutdownIndicated (FALSE)
   {
    if (! m_CipeGenericInitialized)
       {
        ClassConstructor();
       }

    m_TxErr = m_RxErr = m_Tx = m_Rx = 0;

    m_OverlappedEx.OffsetHigh = 0;
    m_OverlappedEx.Offset = 0;
    m_Overlapped.OffsetHigh = 0;
    m_Overlapped.Offset = 0;

    m_Buffer.length = 0;

    if ((m_Overlapped.hEvent = CreateEvent (NULL, TRUE, FALSE, NULL)) == NULL)
       throw CipeGenericIOException();
    else if ((m_OverlappedEx.hEvent = CreateEvent (NULL, FALSE, FALSE, NULL)) == NULL)
       throw CipeGenericIOException();

    EventReset();
   }

void CipeGenericIO::CopyMAC()
   {
    unsigned short *l_Short = ((unsigned short *) &(m_NextMAC [4]));
    memcpy (m_MAC, m_NextMAC, sizeof (m_MAC));
    *l_Short = htons (ntohs (*l_Short) + 1);
   }

void CipeGenericIO::EventReset()
   {
    ResetEvent (m_Overlapped.hEvent);
   }

void CipeGenericIO::Shutdown()
   {
    m_ShutdownIndicated = TRUE;
   }

BOOL CipeGenericIO::CheckForShutdownIndication()
   {
    BOOL l_Result = FALSE;

    if (m_ShutdownIndicated)
       {
        if (m_OverlappedEx.hEvent) CloseHandle (m_OverlappedEx.hEvent);
        if (m_Overlapped.hEvent) CloseHandle (m_Overlapped.hEvent);
        m_OverlappedEx.hEvent = m_Overlapped.hEvent = NULL;
        l_Result = TRUE;
       }

    return l_Result;
   }

//========================================================================================
//
//========================================================================================
void CipeGenericIO::Send (CipePacketDescriptor &p_Buffer)
   {
    DbgPrint ("[%s] GenericIO object writing [%d] bytes\n", Name().c_str(), p_Buffer.length);
    HexDump (p_Buffer.buffer, p_Buffer.length);
   }

void CipeGenericIO::Send (string &p_String)
   {
    CipePacketDescriptor l_Buffer;
    memcpy (l_Buffer.buffer, p_String.c_str(), l_Buffer.length = p_String.size());
    Send (l_Buffer);
   }

void CipeGenericIO::CompleteAsyncReceive() // This should be overridden. It's just here for debugging
   {
    if (m_Buffer.length == 0) m_Buffer.length = m_Overlapped.InternalHigh;
    DbgPrint ("[%s] read [%d] bytes\n", Name().c_str(), m_Buffer.length);
    HexDump (m_Buffer.buffer, m_Buffer.length);
   }

//========================================================================================
//                                   End of Source
//========================================================================================
