#ifndef CipeSocketIODefined
#define CipeSocketIODefined

#include "windows.h"
#include "winsock2.h"
#include "constants.h"

#include "CipeGenericIO.h"
#include "CipeEncryptor.h"
#include "CipePeer.h"

#include "string"

using namespace std;

//========================================================================================
//
//========================================================================================
class CipeSocketIOException
   {
   };

class CipeSocketIO : public virtual CipeGenericIO
   {
    private:   BOOL m_RequestKey, m_GenerateKey, m_RequestPing;
               CipeGenericIO *m_TapObject, *m_TaskObject;
               unsigned short m_PreferredProtocol;
               SOCKET m_Socket, m_SendSocket;
               CipeEncryptor *m_Encryptor;
               unsigned long m_TickCount;
               unsigned long m_PingTicks;
               SOCKADDR_IN m_PeerInfo;
               unsigned long m_CRC;
               CipePeer &m_Peer;
               int m_PeerLen;

    public:    CipeSocketIO (CipePeer &p_Peer);
               ~CipeSocketIO();

    public:    virtual void Send (CipePacketDescriptor &p_Buffer);
               virtual void RequestAsyncReceive() throw (CipeSocketIOException);
               virtual void CompleteAsyncReceive();
               virtual void TimeoutEvent();

    public:    virtual void Enjoin (CipeGenericIO &p_Object);

    public:    virtual string &AssociateName() {return m_Peer.Adapter().Name();}
               virtual unsigned long Address() {return GetHostAddress (m_Peer.PeerPTP());}
               virtual string &Name()          {return m_Peer.Name();}

    private:   void Send (CipePacketDescriptor &p_Buffer, NK_Type p_Type, CipeEncryptionKeyType p_Mode = KEY_DYNAMIC_ENCRYPT);
               void HandlePeerEvent (CipePacketDescriptor &p_Buffer);
               void PerformKeyExchange();
               void RequestKeyExchange();
               void RequestPing();
               void Shutdown();

    public:    unsigned long GetHostAddress (string &p_Address);

    public:    static void ComputeHeaderCheckSum (CipeIpInfo &p_IpInfo);
   };

//========================================================================================
//                                   End of Source
//========================================================================================
#endif
