#include "CipeServiceMgr.h"
#include "string"

using namespace std;

#include "constants.h"
#include "hexdump.c"
#include "macinfo.c"

int main (int argc, char **argv)
   {
    int l_ExitCode = 0;

    //===============================================================
    // Set this to your product name. It defaults to "CIPE" otherwise
    //===============================================================
    CipeBase::SetMyProductName (PRODUCT_STRING);

    for (int l_Index = 1; l_Index < argc; ++l_Index)
       {
        string l_Parameter (argv [l_Index]);

        DbgMessage = (void (*)(char *p_Format, ...)) printf; // Remember to reinstate this !!!

        if (l_Parameter == "noservice" || l_Parameter == "console")
           CipeServiceMgr::ConsoleInit();
        else if (l_Parameter == "start")
           l_ExitCode = (int) CipeServiceMgr::StartCipeService();
        else if (l_Parameter == "stop")
           l_ExitCode = (int) CipeServiceMgr::StopCipeService();
        else if (l_Parameter == "install")
           l_ExitCode = (int) CipeServiceMgr::InstallCipeService();
        else if (l_Parameter == "remove")
           l_ExitCode = (int) CipeServiceMgr::RemoveCipeService();
        else if (l_Parameter == "running")
           l_ExitCode = (int) (CipeServiceMgr::GetCipeState() == SERVICE_RUNNING);
        else if (l_Parameter == "status")
           DbgPrint ("CIPE service status = [%ld]\n", l_ExitCode = CipeServiceMgr::GetCipeState());
        else
           printf ("cipsrvr [noservice|console|start|stop|install|remove|running|status]\n");
       }

    return
       (
        argc <= 1 ?
        CipeServiceMgr::ServiceDispatchInit() :
        l_ExitCode
       );
   }
