/* packet.h - Internal packet routines
 *        Copyright (C) 2002 Timo Schulz
 *
 * This file is part of OpenCDK.
 *
 * OpenCDK is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * OpenCDK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenCDK; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef CDK_PACKET_H
#define CDK_PACKET_H

enum
{
  SIGSUBPKT_NONE = 0,
  SIGSUBPKT_SIG_CREATED = 2,
  SIGSUBPKT_SIG_EXPIRE = 3,
  SIGSUBPKT_EXPORTABLE = 4,
  SIGSUBPKT_TRUST = 5,
  SIGSUBPKT_REGEXP = 6,
  SIGSUBPKT_REVOCABLE = 7,
  SIGSUBPKT_KEY_EXPIRE = 9,
  SIGSUBPKT_PREFS_SYM = 11,
  SIGSUBPKT_REV_KEY = 12,
  SIGSUBPKT_ISSUER = 16,
  SIGSUBPKT_NOTATION = 20,
  SIGSUBPKT_PREFS_HASH = 21,
  SIGSUBPKT_PREFS_ZIP = 22,
  SIGSUBPKT_KS_FLAGS = 23,
  SIGSUBPKT_PREF_KS = 24,
  SIGSUBPKT_PRIMARY_UID = 25,
  SIGSUBPKT_POLICY = 26,
  SIGSUBPKT_KEY_FLAGS = 27,
  SIGSUBPKT_SIGNERS_UID = 28,
  SIGSUBPKT_REVOC_REASON = 29,
  SIGSUBPKT_FEATURES = 30
};

enum
{
  PREFTYPE_NONE = 0,
  PREFTYPE_SYM = 1,
  PREFTYPE_HASH = 2,
  PREFTYPE_ZIP = 3
};


struct cdk_kbnode_s
{
    struct cdk_kbnode_s *next;
    CDK_PACKET *pkt;
    int flag;
    int private_flag;  
};


void _cdk_free_mpi_array (size_t n, GCRY_MPI * array);
void _cdk_free_userid (cdkPKT_user_id * uid);
void _cdk_free_signature (cdkPKT_signature * sig);
void _cdk_free_pubkey (cdkPKT_public_key * pk);
void _cdk_free_seckey (cdkPKT_secret_key * sk);

struct cdk_prefitem_s * _cdk_copy_prefs (const struct cdk_prefitem_s * prefs);
int _cdk_copy_userid (cdkPKT_user_id ** dst, cdkPKT_user_id * src);
int _cdk_copy_pubkey (cdkPKT_public_key ** dst, cdkPKT_public_key * src);
int _cdk_copy_seckey (cdkPKT_secret_key ** dst, cdkPKT_secret_key * src);
int _cdk_copy_pk_to_sk (cdkPKT_public_key * pk, cdkPKT_secret_key * sk);
int _cdk_copy_signature (cdkPKT_signature ** dst, cdkPKT_signature * src);

int _cdk_pubkey_compare (cdkPKT_public_key * a, cdkPKT_public_key * b);

#endif /* CDK_PACKET_H */
