.TH SADB N "04 May 2000" "sadb user interface" "NIST IPsec Reference Implementation"
.SH NAME
sadb \- manual management interface for the SADB and IPsec policy databases
.SH SADB SYNOPSIS
.TP
.B sadb 
.RB [ \-niosv ] 
.B get 
.RB d[est]
.RB [destination
.RB local-spi(hex)
.RB protocol-number]
.TP
.B sadb 
.RB [ \-niosv ] 
.B delete
.RB d[est]
.RB [destination
.RB local-spi(hex)
.RB protocol-number]
.TP
.B (ESP add)
.TP
.B sadb 
.RB [ \-v ] 
.B  add
.RB d[est]
.RB destination
.RB prefix-length
.RB local-spi(hex)
.RB IPsec-peer
.RB peer-spi(hex)
.RB tunnel-flag
.RB check-replay-flag
.RB initial-sequence-number
.RB protocol-number(50)
.RB linked-protocol-number(0,50,51)
.RB linked-spi
.RB crypto-alg-id
.RB crypto-iv-length
.RB crypto-key-length
.RB crypto-key
.RB auth-alg-id
.RB [auth-iv-length
.RB auth-key-length
.RB auth-key
.RB auth-data-length]
.TP
.B (AH add)
.TP
.B sadb
.RB [ \-v ] 
.B add
.RB d[est]
.RB destination
.RB prefix-length
.RB local-spi(hex)
.RB IPsec-peer
.RB peer-spi(hex)
.RB tunnel-flag
.RB check-replay-flag
.RB initial-sequence-number
.RB protocol-number(51)
.RB linked-protocol-number(0,50,51)
.RB linked-spi
.RB auth-alg-id
.RB auth-iv-length
.RB auth-key-length
.RB auth-key
.RB auth-data-length
.TP
.B (NULL add)
.TP
.B sadb
.RB [ \-v ] 
.B add
.RB d[est]
.RB destination
.RB prefix-length
.RB local-spi(hex)
.RB destination
.RB local-spi(hex)
.RB 0 
.RB 0 
.RB 0 
.RB 2 
.RB 0 
.RB 0
.TP
.B sadb
.B flush
.SH IPSEC POLICY SYNOPSIS
.TP
.B sadb
.RB [ \-v ] 
.B get 
.RB p[rot]
.TP
.B sadb
.RB [\-v] 
.B set
.RB p[rot]
.RB inbound\ protection\ level \ \ \ \ \ \ \ \ \ \ \ 
.RB outbound\ protection\ level
.SH DESCRIPTION
.B sadb
manipulates the kernel's Security Association Database (SADB).  Its primary 
use is to set
up static SAs between a system and its IPsec peer.

.SH OPTIONS and PARAMETERS
.TP
.B \-v
is a flag for verbose. 

.TP
.B \-n
uses numerical addresses instead of trying to determine symbolic host
names.

.TP
.B \-i
the SA is applied to inbound traffic only

.TP
.B \-o
the SA is applied to outbound traffic only

.TP
.B \-s
print SA information in key value pairs (one per line).  Useful when using the
sadb program in PERL scripts.

.TP 
.B add d[est]
adds a SADB entry.

.TP 
.B delete d[est]
deletes a SADB entry.

.TP 
.B flush
deletes all SADB entries.

.TP 
.B get d[est]
gets either a single SADB entry if additional arguments are present
or gets a dump of the entire SADB if no additional arguments are present.

.TP 
.B set p[rot]
sets IPsec system security policy.

.TP 
.B get p[rot]
gets IPsec system security policy.

.TP
.B destination
The destination network or host. You can provide IP addresses in dotted
decimal or host names.  To specify a network address (or address prefix)
use this field in conjuction with the prefix length field to denote
the relevant address bits.

.TP 
.B prefix-length
The number of relevant left-most bits in the destination address.

.TP
.B local-spi
A hexidecimal number representing an index into the local systems
SADB.

.TP
.B protocol-number
.br
.RB ESP = 50
.br
.RB AH = 51
.br

.TP
.B linked-protocol-number for bundled SAs
.br
.RB No Link = 0
.br
.RB ESP = 50
.br
.RB AH = 51
.br

.TP
.B linked-spi
A hexidecimal number representing an index into the local systems
SADB identifying the linked SA (aka SA bundle).
Use 0 when no link(bundle).

.TP
.B IPsec-peer
The IPsec peer host that encapsulates and decapsulates the packets
protected by this SA.  This may or may not be the same as the destination.

.TP
.B peer-spi
A hexidecimal number representing an index into the IPsec peer systems
SADB.

.TP
.B tunnel-flag
Whether or not to use tunnel mode (0=off, 1=on).

.TP
.B check-replay-flag
Whether or not to use the sequence number field to check for replay
(0=off, 1=on).

.TP
.B initial-sequence number
The starting value of the first sequence number.  This is typically
defined by each individual transform specifications.  Older transforms
that didn't include a sequence number must have this field set to 0.

.TP
.B crypto-alg-id
Identifier specified in ipsec.h that corresponds to a particular 
cryptographic algorithm transform.  Those currently supported include:

.RB DES/CBC\ =\ 2
.br
.RB 3DES/CBC\ =\ 3
.br
.RB RC5/CBC\ =\ 4
.br
.RB Blowfish/CBC\ =\ 5
.br
.RB IDEA/CBC\ =\ 6
.br
.RB NULL\ =\ 7
.br
.RB MARS/CBC(AES)\ =\ 8
.br
.RB RC6/CBC(AES)\ =\ 9
.br
.RB RIJNDAEL/CBC(AES)\ =\ 10
.br
.RB SERPENT/CBC(AES)\ =\ 11
.br
.RB TWOFISH/CBC(AES)\ =\ 12
.br
.RB Testing/Debugging\ =\ 252

.TP
.B crypto-iv-length
The length in bytes of the cryptographic algorithm initialization 
vector that is generated and included in the IPsec packet.

.TP
.B crypto-key-length
The length in bytes of the key used to encrypt and decrypt IPsec packets.

.TP
.B crypto-key
Ascii representation of the hexadecimal key used to encrypt and decrypt IPsec packets.

.TP
.B auth-alg-id
Identifier specified in ipsec.h that corresponds to a particular authentication
algorithm transform. Those currently supported include:

.RB none\ =\ 0
.br
.RB HMAC-MD5-96\ =\ 132
.br
.RB HMAC-SHA-1-96\ =\ 133
.br
.RB Testing/Debugging\ =\ 253

.TP
.B auth-iv-length
The length in bytes of the authentication algorithm initialization 
vector that is generated and included in the IPsec packet. 

.TP
.B auth-key-length
The length in bytes of the key used to generate and verify authentication data for 
IPsec packets.

.TP
.B auth-key
Ascii representation of the hexadecimal key used to generate and verify authentication
data for IPsec packets

.TP
.B auth-data-length-key
Length in 32-bit words of the authentication data

.TP
.B inbound\ protection\ level
A bit mask representing the security policy for incoming IP packets

.RB protected\ traffic\ only\ =\ 0
.br
.RB Allow\ all\ unprotected\ traffic\ =\ 1
.br
.RB Allow\ associations\ with\ NULL_SAs\ =\ 2
.br
.RB 3\ (default)\ sets\ everything

.TP
.B outbound protection level
A bit mask representing the security policy for outgoing IP packets

.RB protected\ traffic\ only\ =\ 0
.br
.RB Allow\ all\ unprotected\ traffic\ =\ 1
.br
.RB Allow\ associations\ with\ NULL_SAs\ =\ 2
.br
.RB 3\ (default)\ sets\ everything

.SH OUTPUT
.TP
.B fields reported by sadb get d[est] not found above:

.TP
.B sequence number
Next sequence number to be used in outgoing IPsec packet.

.TP
.B flags
.br
.RB M\ -\ SA\ established\ through\ manual\ key\ management
.br
.RB C\ -\ Check\ for\ replay\ on\ IPsec\ packets
.br
.RB T\ -\ Tunnel\ mode
.br
.RB P\ -\ Partial\ SA\ place\ holder\ for\ PlutoPlus
.br
.RB N\ -\ SA\ established\ through\ PlutoPlus
.br
.RB K\ -\ SA\ about\ to\ expire\ and\ PlutoPlus\ is\ kicked
.br
.RB L\ -\ SA\ is\ permanent
.br
.RB I\ -\ SA\ is\ used\ for\ inbound\ processing
.br
.RB O\ -\ SA\ is\ used\ for\ outbound\ processing

.TP
.B lifetime-B
Number of bytes that can be processed before SA expires.  Not present in static(permanent) SAs.

.TP
.B lifetime-T
Time at which the SA expires. Not present in static(permanent) SAs.

.SH EXAMPLES
.TP
.B Example 1
.TP
sadb add d 129.6.224.152 32 1984 129.6.224.152 1984 1 \\\\
.br
1 1 50 0 0 4 8 \\\\
.br
16 0123456789abcdef0123456789abcdef \\\\
.br
132 0 16 0123456789abcdef0123456789abcdef 3 

.in 8
adds a single-entry, two-way ESP SA between 129.6.224.152 and this system with
tunnel mode on, replay checking on, an initial sequence number of 1, using RC5-CBC for
encryption, and HMAC-MD5-96 for authentication.

.TP
.B Example 2
.TP
sadb add d 129.6.224.152 32 1984 129.6.224.152 1985 1 \\\\
.br
1 1 50 0 0 4 8 \\\\
.br
16 0123456789abcdef0123456789abcdef \\\\
.br
132 0 16 0123456789abcdef0123456789abcdef 3

.TP
sadb add d 129.6.224.152 32 1985 129.6.224.152 1984 1 \\\\
.br
1 1 50 0 0 5 8 \\\\
.br
16 0123456789abcdef0123456789abcdef \\\\
.br
133 0 20 0123456789abcdef0123456789abcdef01234567 3

.in 8
adds a dual-entry, two-way ESP SA between 129.6.224.152 and this system with
tunnel mode on, replay checking on, an initial sequence number of 1, using RC5-CBC for
encryption, and HMAC-MD5-96 for authentication for outgoing packets and Blowfish-CBC
for encryption, and HMAC-SHA-1-96 for authentication for incoming packets (outgoing packets
use the first relevant SA found in the SADB).

.TP 
.B Example 3
.TP
sadb add d 129.6.51.112 32 1984 129.6.224.152 1984 1 \\\\
.br
1 1 50 0 0 4 8 \\\\
.br
16 0123456789abcdef0123456789abcdef \\\\
.br
132 0 16 0123456789abcdef0123456789abcdef 3

.in 8
Same as first example, except the SA is between 129.6.224.152 and this system but
is providing protection for 129.6.51.112 which has no IPsec.

.TP
.B Example 4
.TP
sadb add d 129.6.51.0 24 1984 129.6.224.152 1984 1 \\\\
.br
1 1 50 0 0 4 8 \\\\
.br
16 0123456789abcdef0123456789abcdef \\\\
.br
132 0 16 0123456789abcdef0123456789abcdef 3

.in 8
Same as first example, except the SA is between 129.6.224.152 and this system but
is providing protection for the entire 129.6.51.0 subnet or network.

.TP
.B Example 5
.TP
sadb add d 129.6.224.152 32 1984 129.6.224.152 1985 1 \\\\
.br
1 1 51 0 0 133 0 20 \\\\
.br 
0123456789abcdef0123456789abcdef01234567 3
.TP
sadb add d 129.6.224.152 32 1985 129.6.224.152 1984 1 \\\\
.br
1 1 50 0 0 5 8 \\\\
.br
16 0123456789abcdef0123456789abcdef \\\\
.br
133 0 20 0123456789abcdef0123456789abcdef01234567 3

.in 8
adds a dual-entry, two-way SA between 129.6.224.152 and this system with
tunnel mode on, replay checking on, an initial sequence number of 1, using the AH protocol with
HMAC-SHA-1-96 for authentication for outgoing packets and using the ESP protocol
with Blowfish-CBC for encryption, and HMAC-SHA-1-96 for authentication for incoming packets.

.TP
.B Example 6
.TP
sadb add d 129.6.224.152 32 1984 129.6.224.152 1984 1 \\\\
.br
1 1 50 51 1985 4 8 \\\\
.br
16 0123456789abcdef0123456789abcdef 0
.TP
sadb add d 129.6.224.152 32 1985 129.6.224.152 1985 1 \\\\
.br
1 1 51 0 0 132 0 \\\\
.br
16 0123456789abcdef0123456789abcdef 3

.in 8
adds a single-entry, two-way AH+ESP SA Bundle (a.k.a. Linked SA) between 129.6.224.152 and 
this system with tunnel mode on, replay checking on, an initial sequence number of 1, using 
RC5-CBC for ESP encryption, and HMAC-MD5-96 for AH authentication.

.TP
.B Example 7
.TP
sadb add d 129.6.224.152 32 1984 129.6.224.152 1985 1 \\\\
.br
1 1 50 0 0 4 8 \\\\
.br
16 0123456789abcdef0123456789abcdef \\\\
.br
132 0 16 0123456789abcdef0123456789abcdef 3
.TP
sadb add d 129.6.224.152 32 1985 129.6.224.152 1984 1 \\\\
.br
1 1 50 0 0 5 8 \\\\
.br
16 0123456789abcdef0123456789abcdef \\\\
.br
133 0 20 0123456789abcdef0123456789abcdef01234567 3

.in 8
adds a dual-entry, two-way ESP SA between 129.6.224.152 and this system with
tunnel mode on, replay checking on, an initial sequence number of 1, using RC5-CBC for
encryption, and HMAC-MD5-96 for authentication for outgoing packets and Blowfish-CBC
for encryption, and HMAC-SHA-1-96 for authentication for incoming packets (outgoing packets
use the first relevant SA found in the SADB).

.TP
.B Example 8
.TP
sadb add d 129.6.224.152 32 1984 129.6.224.152 1987 1 \\\\
.br
1 1 50 51 1986 4 8 \\\\
.br
16 0123456789abcdef0123456789abcdef 0
.TP
sadb add d 129.6.224.152 32 1986 129.6.224.152 1988 1 \\\\
.br
1 1 51 0 0 132 0 \\\\
.br
16 0123456789abcdef0123456789abcdef 3
.TP
sadb add d 129.6.224.152 32 1987 129.6.224.152 1984 1 \\\\
.br
1 1 50 51 1988 5 8 \\\\
.br
16 0123456789abcdef0123456789abcdef 0
.TP
sadb add d 129.6.224.152 32 1988 129.6.224.152 1986 1 \\\\
.br
1 1 51 0 0 133 0 \\\\
.br
20 0123456789abcdef0123456789abcdef01234567 3

.in 8
adds a dual-entry, two-way AH+ESP SA Bundle between 129.6.224.152 and this system with
tunnel mode on, replay checking on, an initial sequence number of 1, using RC5-CBC for
ESP encryption, and AH HMAC-MD5-96 for authentication for outgoing packets and Blowfish-CBC
for ESP encryption, and HMAC-SHA-1-96 for AH authentication for incoming packets (outgoing packets
use the first relevant SA found in the SADB).

.TP
.B Example 9
.TP
sadb add d 129.6.224.152 32 1984 129.6.224.152 1984 0 \\\\
.br
0 0 2 0 0 

.in 8
adds a single-entry, NULL SA between 129.6.224.152 and this system.  This
allows this system to accept non-secured packets from 129.6.224.152.

.TP
.B Example 10
.TP
sadb add d 129.6.224.152 32 1984 129.6.224.152 1984 1 \\\\
.br
1 1 50 0 0 7 0 0\\\\
.br
132 0 16 0123456789abcdef0123456789abcdef 3 

.in 8
adds a single-entry, two-way ESP SA between 129.6.224.152 and this system with
tunnel mode on, replay checking on, an initial sequence number of 1, using NULL (no)
encryption, and HMAC-MD5-96 for authentication.

.TP
.B Example 11
.TP
sadb get d

.in 8
prints out the entire SADB

.TP
.B Example 12
.TP
sadb get d 129.6.51.112 1984 50

.in 8
prints out the information in the SADB identified by the destination,spi,protocol tuple.

.TP
.B Example 13
.TP
sadb delete d 129.6.51.112 1984 50

.in 8
deletes the SA identified by the destination, spi, protocol tuple.

.TP
.B Example 14
.TP
sadb set prot 0 0

.in 8
sets the system policy so only IPsec protected packets can enter or leave
this system.  (WARNING: this mode can cause system lockup if the
system depends on network services from non-IPsec systems).

.TP
.B Example 15
.TP
sadb set prot 2 2

.in 8
sets the system policy so only systems specified in the SADB can send
or receive packets from you.  NULL_SAs are allowed and can be used
to provide access to network services from non-IPsec systems.

.LP
.SH FILES
.I /dev/ipsec


.LP
.SH HISTORY
.B sadb 
for Linux, was originally written by Rob Glenn (NIST)
PlutoPlus additions added by Sheila Frankel (NIST)

.SH BUGS
A few ants, a couple of flies...
