/* br.h */

/* This file is used by the crypto routines to reverse the byte order
on the appropriate ENDIAN machines */

#include <endian.h>

static __inline__ void ByteReverse( unsigned long *buffer, int byteCount )
{
register unsigned long value;
register int count;

    byteCount /= sizeof( unsigned long );
    for( count = 0; count < byteCount; count++ )
    {
    value = ( buffer[ count ] << 16 ) | ( buffer[ count ] >> 16 );
    buffer[ count ] = ( ( value & 0xFF00FF00L ) >> 8 ) | ( ( value & 0x00FF00FFL ) << 8 );
    }
}
static __inline__ void ByteReverseChar(unsigned char *buf, unsigned longs)
{
    register unsigned long  t;
    do {
        t = (((((buf[3] << 8) | buf[2]) << 8) | buf[1]) << 8) | buf[0];
        *(unsigned long *)buf = t;
        buf += 4;
    } while (--longs);
}

#if (__BYTE_ORDER == __LITTLE_ENDIAN)
#define LittleByteReverse(a,b) ByteReverse(a,b);
#define LittleByteReverseChar(a,b) ByteReverseChar(a,b);
#else
#define LittleByteReverse(a,b) /* nothing */
#define LittleByteReverseChar(a,b) /* nothing */
#endif

#if (__BYTE_ORDER == __BIG_ENDIAN)
#define BigByteReverse(a,b) ByteReverse(a,b);
#define BigByteReverseChar(a,b) ByteReverseChar(a,b);
#else
#define BigByteReverse(a,b) /* nothing */
#define BigByteReverseChar(a,b) /* nothing */
#endif
