
/* A somewhat modified version of Eric Young's cbc_enc.c DES CBC function 
   This code was modifed to be able to use blowfish encrypt and decrypt functions */


#include "../../br.h" 
#include "serpent.h"

void serpent_cbc_encrypt(unsigned char *input,long length,serpentkey key, unsigned char *ivec,unsigned char encrypt)
{
	register unsigned long t0,t1,t2,t3,xor0,xor1,xor2,xor3;
	register unsigned long *in,*iv;
	register long l=length;

	in=(unsigned long *)input;
	iv=(unsigned long *)ivec;

	BigByteReverse(iv,16);  
	BigByteReverse(in,length); 

	if (encrypt)
		{
		t0 = iv[0];
		t1 = iv[1];
		t2 = iv[2];
		t3 = iv[3];
		for (; l>0; l-=16)
			{
			in[0]^=t0;
			in[1]^=t1;
			in[2]^=t2;
			in[3]^=t3;

			serpent_encrypt((u1byte *)in,(u1byte *)in,key); 

			t0 = in[0];
			t1 = in[1];
			t2 = in[2];
			t3 = in[3];
			in+=4;
			}
		}
	else
		{
		xor0 = iv[0];
		xor1 = iv[1];
		xor2 = iv[2];
		xor3 = iv[3];
		for (; l>0; l-=16)
			{
			t0 = in[0];
			t1 = in[1];
			t2 = in[2];
			t3 = in[3];

			serpent_decrypt((u1byte *)in,(u1byte *)in,key);

			in[0] ^= xor0;
			in[1] ^= xor1;
			in[2] ^= xor2;
			in[3] ^= xor3;
			xor0=t0;
			xor1=t1;
			xor2=t2;
			xor3=t3;
			in+=4;
			}
		}
	BigByteReverse((unsigned long *)input,length);  
}
