/* ipsec_output_register.c */

/* This file is used to allow the IPsec engine to run as a Linux run-time
   module */

#include <linux/config.h>
#include <linux/module.h>
#include <linux/types.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/in.h>
#include <linux/in6.h>
#include <linux/tcp.h>
#include <linux/udp.h>
#include <linux/if_arp.h>
#include <linux/mroute.h>
#include <linux/random.h>
#include <linux/in.h>
#include <linux/in6.h>
#include <linux/netlink.h>
#include <net/ip.h>

#include "sadb.h"
#include "ipsec.h"
#include <syslog.h>

unsigned int ipsec_mss_delta = 0;
struct ipsec_control *ipsec_control =  NULL;

#ifdef CONFIG_IPSEC_MODULE
EXPORT_SYMBOL(unregister_ipsec);
EXPORT_SYMBOL(register_ipsec);
EXPORT_SYMBOL(ipsec_mss_delta);
EXPORT_SYMBOL(ipsec_control);
#endif

void register_ipsec(struct ipsec_control *ctrl)
{
	if (ipsec_control)
		return;

	ipsec_control = ctrl;

	if (ctrl->init)
		ctrl->init();

}

void unregister_ipsec(void)
{
	ipsec_control = NULL;
}
