/* hmacmd596.c */
/* AH/ESP, HMAC-MD5-96 transform specific code */

#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/skbuff.h>
#include <linux/errno.h>
#include <net/ip.h>
#include <net/sock.h>
#include <linux/in.h>
#include <linux/in6.h>
#include <asm/uaccess.h>
#include <asm/checksum.h>
#include "../crypto/md5/md5.h"
#include "../sadb.h"
#include "../ipsec.h"
#include "../transform.h"
#include "hmac.h"
#include "hmacmd596.h"

static char addr_s2[18];

int hmacmd596_sadb_add(struct sadb_dst_node *d)
{

	unsigned char *xorkey1, *key;
	unsigned short keylen;

#define xorkey2  xorkey1+MD5BLOCKLEN

	switch (d->sa_info.protocol)
	{
	case IPPROTO_AH:
		if (d->sa_info.sn != 1)
		{
			printk(KERN_INFO "%s: SADB: Sequence Number of 1 Required: dst %s spi %lx protocol %x\n", HMACMD596_NAME,
				strcpy(addr_s2,ntoa(d->dst.addr_union.ip_addr.s_addr)), d->sa_info.spi, d->sa_info.protocol);
	  		return 0;
		}

		if (d->sa_info.alg.ah.auth_ivec_length != 0)
		{
			printk(KERN_INFO "%s: SADB: Has No Initialization Vector: dst %s spi %lx\n", HMACMD596_NAME,
				strcpy(addr_s2,ntoa(d->dst.addr_union.ip_addr.s_addr)), d->sa_info.spi);
	  		return 0;
		}

		if (d->sa_info.alg.ah.auth_data_length != (HMACMD596_AD_LENGTH>>2))
		{
			printk(KERN_INFO "%s: SADB: Uses a %d data length: dst %s spi %lx\n", HMACMD596_NAME, (HMACMD596_AD_LENGTH>>2),
				strcpy(addr_s2,ntoa(d->dst.addr_union.ip_addr.s_addr)), d->sa_info.spi);
	  		return 0;
		}

		keylen = d->sa_info.alg.ah.outbound_auth_key.key_len;
		key = d->sa_info.alg.ah.outbound_auth_key.key_data;
	
		if (d->sa_info.alg.ah.outbound_auth_key.key_len != MD5HASHLEN){
			printk(KERN_INFO "%s: SADB: Invalid Key Length: dst %s spi %lx len %d\n", HMACMD596_NAME,
				strcpy(addr_s2,ntoa(d->dst.addr_union.ip_addr.s_addr)), d->sa_info.spi, keylen);
	  		return 0;
        	}
		if (memcmp(&d->sa_info.alg.ah.outbound_auth_key,&d->sa_info.alg.ah.inbound_auth_key,
			d->sa_info.alg.ah.outbound_auth_key.key_len))
		{
            		printk(KERN_INFO "%s: SADB: Gen & Check Key Not Same : dst %s spi %lx\n", HMACMD596_NAME,
				strcpy(addr_s2,ntoa(d->dst.addr_union.ip_addr.s_addr)), d->sa_info.spi);
			return 0;
		}

		if (!(xorkey1 = (unsigned char *)kmalloc(MD5BLOCKLEN*2,GFP_ATOMIC)))
		{
			printk(KERN_INFO "%s: SADB: No Buffer Space for Fast Key: dst %s spi %lx\n", HMACMD596_NAME,
				strcpy(addr_s2,ntoa(d->dst.addr_union.ip_addr.s_addr)), d->sa_info.spi);
			return 0;
		}

		/* K XOR ipad */
		bytnxor(xorkey1,key,ipad,keylen);
		memcpy(xorkey1+keylen, ipad+keylen, MD5BLOCKLEN-keylen);


		/* K XOR opad */
		bytnxor(xorkey2,key,opad,keylen);
		memcpy(xorkey2+keylen, opad+keylen, MD5BLOCKLEN-keylen);

		d->sa_info.alg.ah.inbound_auth_key.fast_key = d->sa_info.alg.ah.outbound_auth_key.fast_key = xorkey1;

                d->sa_info.mss_delta = sizeof(struct ah_header)+ (d->sa_info.alg.ah.auth_data_length<<2)+
                           d->sa_info.alg.ah.auth_ivec_length+(d->sa_info.sn?4:0)+
                           ((d->sa_info.flags & IPSEC_TUNNEL_FLAG)?20:0);
                ipsec_mss_delta = max(ipsec_mss_delta,d->sa_info.mss_delta);

	break;
	case IPPROTO_ESP:

        	if (d->sa_info.alg.esp.auth_ivec_length != 0)
        	{
                	printk(KERN_INFO "%s: SADB: Has No Initialization Vector: dst %s spi %lx\n", HMACMD596_NAME,
                        	strcpy(addr_s2,ntoa(d->dst.addr_union.ip_addr.s_addr)), d->sa_info.spi);
                	return 0;
        	}

        	if (d->sa_info.alg.esp.auth_data_length != (HMACMD596_AD_LENGTH>>2))
        	{
                	printk(KERN_INFO "%s: SADB: Uses a %d data length: dst %s spi %lx\n", HMACMD596_NAME, (HMACMD596_AD_LENGTH>>2),
                        	strcpy(addr_s2,ntoa(d->dst.addr_union.ip_addr.s_addr)), d->sa_info.spi);
                	return 0;
	        }

		keylen = d->sa_info.alg.esp.outbound_auth_key.key_len;
		key = d->sa_info.alg.esp.outbound_auth_key.key_data;
	
        	if (d->sa_info.alg.esp.outbound_auth_key.key_len != MD5HASHLEN){
                	printk(KERN_INFO "%s: SADB: Invalid Key Length: dst %s spi %lx len %d\n", HMACMD596_NAME,
                        	strcpy(addr_s2,ntoa(d->dst.addr_union.ip_addr.s_addr)), d->sa_info.spi, keylen);
                	return 0;
        	}
        	if (memcmp(&d->sa_info.alg.esp.outbound_auth_key,&d->sa_info.alg.esp.inbound_auth_key,
				d->sa_info.alg.esp.outbound_auth_key.key_len)
                    && (d->sa_info.spi == d->sa_info.peer_spi))
        	{
                	printk(KERN_INFO "%s: SADB: Gen & Check Key Not Same : dst %s spi %lx\n", HMACMD596_NAME,
                        	strcpy(addr_s2,ntoa(d->dst.addr_union.ip_addr.s_addr)), d->sa_info.spi);
                	return 0;
        	}
		if (!(xorkey1 = (unsigned char *)kmalloc(MD5BLOCKLEN*2,GFP_ATOMIC)))
		{
			printk(KERN_INFO "%s: SADB: No Buffer Space for Fast Key: dst %s spi %lx\n", HMACMD596_NAME,
				strcpy(addr_s2,ntoa(d->dst.addr_union.ip_addr.s_addr)), d->sa_info.spi);
			return 0;
		}

		/* K XOR ipad */
		bytnxor(xorkey1,key,ipad,keylen);
		memcpy(xorkey1+keylen, ipad+keylen, MD5BLOCKLEN-keylen);

	
		/* K XOR opad */
		bytnxor(xorkey2,key,opad,keylen);
		memcpy(xorkey2+keylen, opad+keylen, MD5BLOCKLEN-keylen);

		d->sa_info.alg.esp.inbound_auth_key.fast_key = d->sa_info.alg.esp.outbound_auth_key.fast_key = xorkey1;
	break;

	default:
		printk(KERN_INFO "%s: SADB: Invalid Protocol: dst %s spi %lx protocol %x\n", HMACMD596_NAME,
			strcpy(addr_s2,ntoa(d->dst.addr_union.ip_addr.s_addr)), d->sa_info.spi, d->sa_info.protocol);
	  	return 0;
	break;
	}


	return 1;
}

void hmacmd596_sadb_delete(struct sadb_dst_node *d)
{
	switch (d->sa_info.protocol)
	{
	case IPPROTO_AH:
        	if(d->sa_info.alg.ah.outbound_auth_key.fast_key)
                	kfree(d->sa_info.alg.ah.outbound_auth_key.fast_key);
	break;
	case IPPROTO_ESP:
        	if(d->sa_info.alg.esp.outbound_auth_key.fast_key)
                	kfree(d->sa_info.alg.esp.outbound_auth_key.fast_key);
	break;
	}
}
