#!/usr/bin/perl

# (c) 2006 Ken Bantoft <ken@xelerance.com>

# usage: conngen.pl template.conf #N
# where #N = 250 * n tunnels will be created.
# eg: conngen.pl host1.conf 4 
# would create a config for 1000 tunnels (all /32s)

$template = $ARGV[0];
$max = $ARGV[1];

if (!$ARGV[0]) { 
	print "Usage: $ARGV[0] template.conf # \n\n";
	exit;
}

open(IN,$template);
while(<IN>) {
	print $_;
}

for ($third = 1;$third <= $max;$third++) {
	for ($quad = 1;$quad < 251;$quad++) {
	print "conn test_" . $third . "_" . "$quad\n";
	print "\tleftsubnet=172.30." . "$third" . "." . "$quad/32\n";
	print "\trightsubnet=172.31." . "$third" . "." . "$quad/32\n";
	print "\talso=main\n";
	print "\tauto=add\n";
	
	}
}
