<?php

include("../style.php");

$color = "3576BA";

pageheader("$color",5,"Deliverable 1: Vulcan drivers on FreeBSD");

$content =  <<<EOF1

<H2>Testing IKE policies</H2>
<H3>Setting up SUT5</H3>
<OL>
<LI>Login to SUT5 as root.
<LI>Edit /etc/ssh/sshd_config to enable root logins, change:
<PRE>
#PermitRootLogin no
</PRE>
to
<PRE>
PermitRootLogin yes
</PRE>
<LI>Restart sshd:
<PRE>
/etc/rc.d/sshd restart
</PRE>
</OL>
<H3>Setting up SUT3</H3>
<OL>
<LI>Login on SUT3 as root
<LI>Get the testscript tar file:
<PRE>
scp &lt;user&gt;@hifn.xelerance.com:/hifn/MASTER/files/phase1-tests.tgz .
</PRE>
<LI>Extract the file:
<PRE>
tar -xzvf phase1-tests.tgz
</PRE>
<LI>Generate the PSK ipsec.conf file for SUT3:
<PRE>
./makepskconf-IKE.pl template.conf > /etc/ipsecpsk.conf
</PRE>
<LI>Generate the RSA ipsec.conf file for SUT3:
<PRE>
./makersaconf-IKE.pl template.conf > /etc/ipsecrsa.conf
</PRE>
<LI>Now we re-edit the template.conf file for the version we will send to SUT5.  Edit template.conf and change the interface:
<PRE>
   interfaces="ipsec0=em1"
</PRE>
to 
<PRE>
  interfaces="ipsec0=em0"
</PRE>
<LI>Generate the PSK ipsec.conf file for SUT5:
<PRE>
./makepskconf-IKEtest.pl template.conf > sut5ipsecpsk.conf
</PRE>
<LI>Generate the RSA ipsec.conf file for SUT5:
<PRE>
./makersaconf-IKEtest.pl template.conf > sut5ipsecrsa.conf
</PRE>
<LI>We send the sut3ipsec.conf file to SUT5:
<PRE>
scp sut5ipsecpsk.conf sut5:/etc/ipsecpsk.conf
scp sut5ipsecrsa.conf sut5:/etc/ipsecrsa.conf
</PRE>
</OL>
<H3>Creating a keypair for automated login to SUT5</H3>
<OL>
<LI>Login as root on SUT3.
<LI>Create the keypair without a passphrase:
<PRE>
ssh-keygen -t dsa -f mykey
&lt;PRESS ENTER&gt;
&lt;PRESS ENTER&gt;
</PRE>
<LI>Transfer the public part of the key to SUT5:
<PRE>
cat mykey.pub | ssh sut5 "cat >> \$HOME/.ssh/authorized_keys"
</PRE>
<LI>Start a tcpdump process to monitor the wire:
<PRE>
tcpdump -n -i em0
</PRE>
</OL>

<H3>Running the PSK Phase1 test</H3>
<OL>
<LI>Login as root on SUT5
<LI>Link psk ipsec.conf file.
<PRE>
cd /etc
ln -s ipsecpsk.conf ipsec.conf
</PRE>
<LI>Create a ipsec.secrets file that contains:
<PRE>
@sut3 @sut5 : PSK "12456"
</PRE>
<LI>Start IPsec:
<PRE>
ipsec setup restart
</PRE>
<LI>Login as root on SUT3
<LI>Link psk ipsec.conf file.
<PRE>
cd /etc
ln -s ipsecpsk.conf ipsec.conf
</PRE>
<LI>Create a ipsec.secrets file that contains:
<PRE>
@sut3 @sut5 : PSK "12456"
</PRE>
<LI>Start IPsec:
<PRE>
ipsec setup restart
</PRE>
<LI>Edit the runpolicies.pl script and make sure you have the correct target. Replace:
<PRE>
\$sutname = "192.168.88.205";
</PRE>
with whatever is appropriate for your sut, so probably:
<PRE>
\$sutname = "sut5";
</PRE>
You might need to change the IPs used in the script too.
<LI>Start the test:
<PRE>
cd ~
./runpolicies.pl
</PRE>
You should see mostly ESP amd isakmp packets on the <I>tcpdump</I> running on SUT5.  The script on SUT3 should not hang, and should terminate normally at the root prompt.
</OL>

<H3>Running the RSA Phase1 test</H3>
<OL>
<LI>Login as root on SUT5
<LI>Link rsa ipsec.conf file.
<PRE>
cd /etc
ln -s ipsecrsa.conf ipsec.conf
</PRE>
<LI>Change /etc/ipsec.secrets to be you RSA private key.
<LI>Start IPsec:
<PRE>
ipsec setup restart
</PRE>
<LI>Login as root on SUT3
<LI>Link rsa ipsec.conf file.
<PRE>
cd /etc
ln -s ipsecrsa.conf ipsec.conf
</PRE>
<LI>Change /etc/ipsec.secrets to be you RSA private key.
<LI>Start IPsec:
<PRE>
ipsec setup restart
</PRE>
<LI>Start the test:
<PRE>
cd ~
./runpolicies.pl
</PRE>
You should see mostly ESP amd isakmp packets on the <I>tcpdump</I> running on SUT5.  The script on SUT3 should not hang, and should terminate normally at the root prompt.
</OL>
EOF1;

table("3576BA","home","","right","","$content");

pagefooter("3576BA","home");

?>

