<?php

include("../style.php");

$color = "3576BA";

pageheader("$color",4,"Milestone 3: Gig Ethernet on FreeBSD");

$content =  <<<EOF1

<OL><H2>Configuring FreeBSD for Gig Ethernet performance</H2>
<LI>Login as root and edit the file <B>/etc/sysctl.conf</B> and add the following:
<PRE>
kern.cryptodevallowsoft=1
kern.ipc.somaxconn=1024
kern.random.sys.harvest.ethernet=0
kern.random.sys.harvest.interrupt=0
net.inet.udp.recvspace=65536
net.inet.tcp.recvspace=65536
net.inet.tcp.sendspace=65536
net.inet.tcp.delayed_ack=0
net.inet.tcp.msl=5000
</PRE>
<LI>Edit the file <B>/boot/loader.conf</B> and add the following:
<PRE>
kern.ipc.nmbclusters=32768
</PRE>
<LI>Now, edit /etc/rc.conf and set all GigE interfaces to an MTU of 9000. For example:
<PRE>
ifconfig_bge0="inet 172.18.20.77 netmask 255.255.255.0 mtu 9000"
ifconfig_bge1="inet 172.18.40.77 netmask 255.255.255.0 mtu 9000"
</PRE>
<LI>Reboot
</OL>

EOF1;

table("3576BA","home","","right","","$content");

pagefooter("3576BA","home");

?>

