<?php

include("../style.php");

$color = "3576BA";

pageheader("$color",4,"Milestone 3: Manual IPSec Tunnel Setup");

$content =  <<<EOF1

<OL><H2>Configuring Manual IPSec Keying for tunnel</H2>
<LI>Login as root on SUT3
<LI>On SUT3, create a file called <B>tunnel.sh</B> and put the following in it:
<pre>
setkey -FP
setkey -F
export SUT3=172.18.20.33
export SUT7=172.18.20.77
export SUT3KEY=0x0123456789abcdef02468ace13579bdf123456789abcdef0
export SUT7KEY=0x0123456789abcdef02468ace13579bdf123456789abcdef0
export SUT3AUTH=0x123456789abcdef02468ace013579bdf
export SUT7AUTH=0x123456789abcdef02468ace013579bdf
setkey -c << EOF
add \$SUT3 \$SUT7 esp 0x100
        -m tunnel
        -E 3des-cbc \$SUT7KEY
        -A hmac-md5 \$SUT7AUTH ;
add \$SUT7 \$SUT3 esp 0x101
        -m tunnel
        -E 3des-cbc \$SUT3KEY
        -A hmac-md5 \$SUT3AUTH ;
spdadd 172.18.50.0/24[any] 172.18.40.0/24[any] any -P out ipsec
        esp/tunnel/\$SUT3-\$SUT7/require ;
EOF
</pre>
<LI>Login as root on SUT7
<LI>On SUT7, create a file called <B>tunnel.sh</B> and put the following in it:
<pre>
setkey -FP
setkey -F
export SUT3=172.18.20.33
export SUT7=172.18.20.77
export SUT3KEY=0x0123456789abcdef02468ace13579bdf123456789abcdef0
export SUT7KEY=0x0123456789abcdef02468ace13579bdf123456789abcdef0
export SUT3AUTH=0x123456789abcdef02468ace013579bdf
export SUT7AUTH=0x123456789abcdef02468ace013579bdf
setkey -c << EOF
add \$SUT3 \$SUT7 esp 0x100
        -m tunnel
        -E 3des-cbc \$SUT7KEY
        -A hmac-md5 \$SUT7AUTH ;
add \$SUT7 \$SUT3 esp 0x101
        -m tunnel
        -E 3des-cbc \$SUT3KEY
        -A hmac-md5 \$SUT3AUTH ;
spdadd 172.18.40.0/24[any] 172.18.50.0/24[any] any -P out ipsec
        esp/tunnel/\$SUT7-\$SUT3/require ;
EOF
</pre>
<LI>On SUT3, login as root
<LI>On SUT3, start the end of the tunnel by doing <B>sh ./tunnel.sh</B>
<LI>On SUT7, login as root
<LI>On SUT7, start the end of the tunnel by doing <B>sh ./tunnel.sh</B>
</OL>

EOF1;

table("3576BA","home","","right","","$content");

pagefooter("3576BA","home");

?>

