<?php

include("../style.php");

$color = "3576BA";

pageheader("$color",5,"Milestone 4: Defining the Openswan connection");

$content =  <<<EOF1

<OL><H2>Compiling and installing Vulcan PK FreeBSD kernel</H2>
<LI>Login on SUT3 as a regular user.
<LI>Get the vulcanpk kernel source:
<PRE>
scp &lt;user&gt;@hifn.xelerance.com:/hifn/MASTER/files/freebsd-vulcanpk-9649aa.tgz .
tar -xzvf freebsd-vulcanpk-9649aa.tgz
cd freebsd-vulcanpk-9649aa
cd i386/conf
config VULCAN
cd ../compile/VULCAN
make depend
make
</PRE>
<LI>Install the kernel as root:
<PRE>
su root
make install
</PRE>
<LI>Reboot
<LI>At the FreeBSD boot menu, select <B>6</B> to get a boot prompt and then enter:
<PRE>
boot /boot/vulcan
</PRE>
<LI>Once booted, login as a regular user and see if /dev/vulcanpk exists:
<PRE>
ls -l /dev/vulcanpk
</PRE>
<LI>As root, modify /etc/ipsec.conf and include in the <B>config setup</b> section:
<PRE>
config setup
	plutoopts="--usevulcanhack"
</PRE>
<LI>Restart pluto:
<PRE>
ipsec setup restart
</PRE>
<LI>Look at the IPsec log /var/tmp/pluto.log and you should see the following:
<PRE>
Enabling direct Vulcan Public Key interface
starting up 1 cryptographic helpers
started helper pid=1090 (fd:6)
</PRE>
The <b>pid=</b> will have a different number than this, of course.
</OL>

EOF1;

table("3576BA","home","","right","","$content");

pagefooter("3576BA","home");

?>

