/*
 * hexdump routine that omits lines of zeroes, except first/last
 * and it well enough commented that you won't mess it up when
 * you modify it, yet again.
 *
 * base address is pointer, and offset is into that space.
 * this is so that the offset can be printed nicely and make relative
 * sense.
 *
 */
void hexdump(caddr_t base, unsigned int offset, int len)
{
	unsigned char *b = base+offset;
	int i;
	int first,last;     /* flags */

	last=0;
	first=1;
  
	for(i = 0; i < len; i++) {
		/* if it's the first item on the line */
		if((i % 16) == 0) {
			/* and it's not the first or last line */
			if(!first && !last) {
				int j;

				/* see if all the entries are zero */
				for(j=0; j < 16; j++) {
					if(b[i+j] != 0) break;
				}

				/* yes, they all are */
				if(j==16) {
					/* so just advance to next chunk,
					 * noting the i++ above. */
					i = i+15;
					continue;
				}
			}
			
			/* see if we are at the last line */
			if((len-i) < 16) last=1;
			first=0;

			/* print the offset */
			printf("%04x:", offset+i);
		}

		printf(" %02x", b[i]); 

		/* see it's the last item on line */
		if(!((i + 1) % 16)) {
			printf("\n");
		}
	}
	/* if it wasn't the last item on line */
	if(i % 16) {
		printf("\n");
	}
}

