#!/usr/bin/perl

sub run {
	print join(" ",@_)."\n";
	system @_;
}

run("rm /tmp/*.OK");
$sutname = "192.168.88.203";

open(CONNS, 'grep "^conn conn-" /etc/ipsec.conf |') || die "Could not open /etc/ipsec.conf for reading\n";
while (<CONNS>) {
	($dummy, $connname) = split(" ", $_);
	push(@connections, $connname);
}
close(CONNS);

foreach $conn (@connections) {
	($dummy,$mode,@rest) = split(/-/,$conn);
	# We restart ipsec on mode changes:
	if ($mode ne $oldmode) {
		run("ipsec setup restart");
		run("ssh -i mykey $sutname \"ipsec setup restart\"");
		sleep(5); # We will give both sides time to bring up their ipsec properly.
		$firsttest = 1;
	}
	$oldmode = $mode;
	run("ipsec auto --add $conn");
	run("ssh -i mykey $sutname \"ipsec auto --add $conn\"");
	run("ipsec auto --up $conn && sleep 1");
	sleep 3 if ($firsttest); # The fist SA created for a site needs a bit more delay to bring up.
	$firsttest = 0;
	run("iperf -c 172.18.30.33 -p 1702 -t 1 -N -u -w 128K -l 8000 && touch /tmp/$conn.OK");
	run("ipsec auto --down $conn");
	run("ipsec auto --delete $conn");
	run("ssh -i mykey $sutname ".'"'."ipsec auto --delete $conn".'"');
}
