/*

  silcwin32util.c

  Author: Pekka Riikonen <priikone@silcnet.org>

  Copyright (C) 2001 - 2006 Pekka Riikonen

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

*/
/* $Id: silcwin32util.c,v 1.15 2006/10/22 10:31:44 priikone Exp $ */

#include "silc.h"

/* XXX GNU regex may work on Win32 too!! */
char *silc_string_regexify(const char *string)
{
  return strdup(string);
}

char *silc_string_regex_combine(const char *string1, const char *string2)
{
  return strdup(string1);
}

int silc_string_regex_match(const char *regex, const char *string)
{
  return TRUE;
}

int silc_string_match(const char *string1, const char *string2)
{
  return TRUE;
}

#define FILETIME_1970 0x019db1ded53e8000
const BYTE DWLEN = sizeof(DWORD) * 8;

/* Return current time in struct timeval. Code ripped from some xntp
   implementation. */

int silc_gettimeofday(struct timeval *tv)
{
  FILETIME ft;
  __int64 usec;

  GetSystemTimeAsFileTime(&ft);
  usec = (__int64) ft.dwHighDateTime << DWLEN | ft.dwLowDateTime;
  usec = (usec - FILETIME_1970) / 10;
  tv->tv_sec  = (long) (usec / 1000000);
  tv->tv_usec = (long) (usec % 1000000);

  return 0;
}

char *silc_get_username(void)
{
  DWORD maxlen = 128;
  char username[128];
  GetUserName(username, &maxlen);
  return strdup(username);
}

char *silc_get_real_name(void)
{
  return silc_get_username();
}

int silc_file_set_nonblock(int fd)
{
  return fcntl(fd, F_SETFL, fcntl(fd, F_GETFL, 0) | O_NONBLOCK);
}
