&nbsp;<br />
<b><big>Frequently Asked Questions</big></b>
<br />&nbsp;<br />
<a href="#f1_0" class="normal">1. General Questions</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f1_10" class="normal">
1.1 What is SILC?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f1_20" class="normal">
1.2 When was SILC Project started?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f1_30" class="normal">
1.3 Why SILC in the first place?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f1_40" class="normal">
1.4 What license covers the SILC release?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f1_50" class="normal">
1.5 Why SILC? Why not IRC3?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f1_55" class="normal">
1.6 What platforms SILC supports?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f1_59" class="normal">
1.7 How do you pronounce SILC?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f1_60" class="normal">
1.8 Where can I find more information?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f1_70" class="normal">
1.9 I would like to help out, what can I do?</a>

<br />&nbsp;<br />
<a href="#f2_0" class="normal">2. Protocol Questions</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f2_10" class="normal">
2.1 What is the status of SILC protocol in the IETF?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f2_20" class="normal">
2.2 How much the SILC protocol is based on IRC?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f2_30" class="normal">
2.3 Why use SILC? Why not IRC with SSL?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f2_40" class="normal">
2.4 Can I talk from SILC network to IRC network?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f2_45" class="normal">
2.5 Does SILC support file transfer?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f2_46" class="normal">
2.6 Does SILC support DCC or alike?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f2_47" class="normal">
2.7 I am behind a firewall, can I use SILC?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f2_50" class="normal">
2.8 How secure SILC really is?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f2_60" class="normal">
2.9 Does SILC support instant messaging?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f2_70" class="normal">
2.10 Why SILC does not have LINKS command like in IRC?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f2_80" class="normal">
2.11 What does the session detaching/resuming mean?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f2_90" class="normal">
2.12 Is anyone outside a channel able to see the channel messages?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f2_95" class="normal">
2.13 How can I register my channel in SILC?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f2_100" class="normal">
2.14 Is it true that all messages are encrypted in SILC?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f2_110" class="normal">
2.15 Can server or SILC operator gain operator mode on a channel?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f2_120" class="normal">
2.16 Channel name doesn't have #-character or does it?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f2_130" class="normal">
2.17 Does SILC support moderated channels?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f2_140" class="normal">
2.18 What does the "watching" mean?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f2_150" class="normal">
2.19 Is it possible to reject watching?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f2_160" class="normal">
2.20 Is it possible to block private messages?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f2_170" class="normal">
2.21 Is it possible to block channel messages?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f2_180" class="normal">
2.22 Is it possible to block invites?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f2_190" class="normal">
2.23 Does SILC support multimedia messages, like video/audio streaming?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f2_200" class="normal">
2.24 Is it possible to send picture/image messages?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f2_205" class="normal">
2.25 What kind of presence modes SILC support?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f2_210" class="normal">
2.26 Does SILC support anonymity?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f2_220" class="normal">
2.27 Does SILC support services?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f2_230" class="normal">
2.28 I have suggestions to SILC Protocol, what can I do?</a>

<br />&nbsp;<br />
<a href="#f3_0" class="normal">3. Client Questions</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f3_10" class="normal">
3.1 Where can I find SILC clients?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f3_20" class="normal">
3.2 Can I use SILC with IRC client and vice versa?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f3_25" class="normal">
3.3 The default theme sucks, where can I find a better one?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f3_30" class="normal">
3.4 How do I send a private message?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f3_40" class="normal">
3.5 How do I negotiate secret key with another user?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f3_50" class="normal">
3.6 How do I negotiate secret keys behind a NAT?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f3_60" class="normal">
3.7 How do I change channel modes?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f3_70" class="normal">
3.8 What does the founder mode on channel mean, and how do I set it?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f3_80" class="normal">
3.9 I am founder of invite only channel, how can I join the channel after I have left it?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f3_90" class="normal">
3.10 How can I op or deop somebody on channel?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f3_100" class="normal">
3.11 How do I set private key for channel, and what does that mean exactly?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f3_110" class="normal">
3.12 How do I transfer a file?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f3_120" class="normal">
3.13 How can I get other users public keys?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f3_130" class="normal">
3.14 How can I see the fingerprint of my public key?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f3_140" class="normal">
3.15 I gave WHOIS to a nick, and it returned multiple replies, why?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f3_150" class="normal">
3.16 Is there a command to see all linked servers?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f3_160" class="normal">
3.17 How do I list the users of a channel?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f3_170" class="normal">
3.18 What is the difference between OPER and SILCOPER commands?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f3_180" class="normal">
3.19 My Cygwin client crashes with message "Couldn't create //.silc directory"</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f3_190" class="normal">
3.20 Why /join #silc and /join silc doesn't join the same channel?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f3_200" class="normal">
3.21 How do I detach my session from the server?</a>

<br />&nbsp;<br />
<a href="#f4_0" class="normal">4. Server Questions</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f4_10" class="normal">
4.1 Where can I find SILC servers?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f4_20" class="normal">
4.2 Can I run my own SILC server?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f4_30" class="normal">
4.3 What is the difference between SILC server and SILC router?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f4_40" class="normal">
4.4 Why server says permission denied to write to a log file?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f4_50" class="normal">
4.5 When I connect to to my server, it says "server does not support one of your proposed cipher", what is wrong?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f4_60" class="normal">
4.6 Why SILC server runs on privileged port 706?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f4_70" class="normal">
4.7 I see [Unknown] in the log file, what does it mean?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f4_80" class="normal">
4.8 How can I generate a new server key pair?</a>

<br />&nbsp;<br />
<a href="#f5_0" class="normal">5. Toolkit Questions</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f5_10" class="normal">
5.1 What is SILC Toolkit?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f5_20" class="normal">
5.2 Is the SILC Toolkit Reference Manual Available?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f5_30" class="normal">
5.3 How do I compile the Toolkit on Unix?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f5_40" class="normal">
5.4 How do I compile the Toolkit on Win32?</a><br />
 &nbsp;&nbsp;&nbsp;&nbsp;<a href="#f5_50" class="normal">
5.5 Does the Toolkit package include any sample code?</a><br />
<br />&nbsp;<br />


<a name="f1_0"></a>
<b>1. General Questions</b><br />&nbsp;<br />

<a name="f1_10"></a>
<samp class="highlight">Q: What is SILC?</samp><br />
A: SILC (Secure Internet Live Conferencing) is a protocol which provides
secure conferencing services in the Internet over insecure channel. SILC
is IRC like although internally they are very different. Biggest
similarity between SILC and IRC is that they both provide conferencing
services and that SILC has almost same commands as IRC. Other than that
they are nothing alike.
<br />&nbsp;<br />
Biggest differences are that SILC is secure what IRC is not in any way.
The network model is also entirely different compared to IRC.
<br />&nbsp;<br />

<a name="f1_20"></a>
<samp class="highlight">Q: When was SILC Project started?</samp><br />
A: The SILC development started in 1996 and early 1997. But, for various 
reasons it suspended many times until it finally got some wind under its 
wings in 1999. First public release was in summer 2000.
<br />&nbsp;<br />

<a name="f1_30"></a>
<samp class="highlight">Q: Why SILC in the first place?</samp><br />
A: Simply for fun, nothing more. And actually for need back in the days
when it was started. When SILC was first developed there really did not 
exist anything like this. SILC has been very interesting and educational 
project.
<br />&nbsp;<br />

<a name="f1_40"></a>
<samp class="highlight">Q: What license covers the SILC release?</samp><br />
A: The SILC software developed here at silcnet.org, the SILC Client, the 
SILC Server and the SILC Toolkit are covered by the GNU General Public 
License.
<br />&nbsp;<br />

<a name="f1_50"></a>
<samp class="highlight">Q: Why SILC? Why not IRC3?</samp><br />
A: Question that is justified no doubt of that. SILC was not started to 
become a replacement for IRC. SILC was something that didn't exist in 1996 
or even today except that SILC is now released. However, I did check out 
the IRC3 project in 1997 when I started coding and planning the SILC protocol.
<br />&nbsp;<br />
But, IRC3 is problematic. Why? Because it still doesn't exist. The
project is almost at the same spot where it was in 1997 when I checked it 
out. And it was old project back then as well. That's the problem of IRC3 
project. The same almost happened to SILC as well as I wasn't making real 
progress over the years. I talked to the original author of IRC, Jarkko 
Oikarinen, in 1997 and he directed me to the IRC3 project, although he 
said that IRC3 is a lot of talking and not that much of anything else. I 
am not trying to put down the IRC3 project but its problem is that no one 
in the project is able to make a decision what is the best way to go about
making the IRC3 and I wasn't going to be part of that. The fact is that
if I would've gone to IRC3 project, nor IRC3 or SILC would exist today. I
think IRC3 could be something really great if they just would get their
act together and start coding the thing.
<br />&nbsp;<br />

<a name="f1_55"></a>
<samp class="highlight">Q: What platforms SILC supports?</samp><br />
A: The SILC Client is available on various Unix systems and is reported to 
work under cygwin on Windows. The SILC Server also works on various Unix 
systems. However, the server has not been tested under cygwin as far as we 
know. The SILC Toolkit is distributed for all platforms, Unix, Cygwin 
and native Windows.
<br />&nbsp;<br />

<a name="f1_59"></a>
<samp class="highlight">Q: How do you pronounce SILC?</samp><br />
A: SILC is usually pronounced as `silk', but you are free to pronounce
it the way you want.
<br />&nbsp;<br />

<a name="f1_60"></a>
<samp class="highlight">Q: Where can I find more information?</samp><br />
A: For more technical information we suggest reading the SILC Protocol 
specifications. You might also want to take a look at the <a 
href="?page=docs" class="normal">documentation </a> page on the web page.
<br />&nbsp;<br />

<a name="f1_70"></a>
<samp class="highlight">Q: I would like to help out, what can I do?</samp><br />
A: You might want to take a look at the <a 
href="?page=contribute" class="normal">Contributing</a> page and the <a 
href="?page=todo" class="normal">TODO</a> list. You might also want to join the
SILC development mailing list.
<br />&nbsp;<br />


<a name="f2_0"></a><br />
<b>2. Protocol Questions</b><br />&nbsp;<br />

<a name="f2_10"></a>
<samp class="highlight">Q: What is the status of SILC protocol in the IETF?</samp><br />
A: The SILC protocol specifications has been submitted currently as 
individual submissions. There does not currently exist a working group 
for this sort of project. Our goal is to fully standardize the SILC and 
thus submit it as RFC to the <a href="http://www.ietf.org/" class="normal">
IETF</a> at a later time.  This can happen only after we have requested
the IETF to accept SILC as RFC.  As of today, we have not yet even requested
this from the IETF.  We want to let the protocol mature a bit more.
<br />&nbsp;<br />

<a name="f2_20"></a>
<samp class="highlight">Q: How much SILC Protocol is based on IRC?</samp><br />
A: SILC is not based on IRC. The client superficially resembles IRC 
client but everything that happens under the hood is nothing alike IRC. 
SILC could *never* support IRC because the entire network toppology is 
different (hopefully more scalable and powerful). So no, SILC protocol 
(client or server) is not based on IRC. Instead, We've taken good things 
from IRC and left all the bad things behind and not even tried to burden 
the SILC with the IRCs problems that will burden IRC and future IRC 
projects till the end. SILC client resembles IRC client because it is 
easier for new users to start using SILC when they already know all the 
commands.
<br />&nbsp;<br />

<a name="f2_30"></a>
<samp class="highlight">Q: Why use SILC? Why not IRC with SSL?</samp><br />
A: Sure, that is possible, although, does that secure the entire IRC
network? And does that increase or decrease the lags and splits in the 
IRC network? Does that provide user based security where some specific 
private message are secured? Does that provide security where some 
specific channel messages are secured? And I know, you can answer yes to 
some of these questions. But, security is not just about applying 
encryption to traffic and SILC is not just about `encrypting the 
traffic`. You cannot make insecure protocol suddenly secure just by 
encrypting the traffic. SILC is not meant to be IRC replacement. IRC is 
good for some things, SILC is good for same and some other things.
<br />&nbsp;<br />

<a name="f2_40"></a>
<samp class="highlight">Q: Can I talk from SILC network to IRC network?</samp><br />
A: Simple answer for this is No. The protocols are not compatible which 
makes it impossible to directly talk from SILC network to IRC network or 
vice versa. Developing a gateway between these two networks would 
technically be possible but from security point of view strongly not 
recommended. We have no plans for developing such a gateway.
<br />&nbsp;<br />

<a name="f2_45"></a>
<samp class="highlight">Q: Does SILC support file transfer?</samp><br />
A: Yes.  The SILC protocol support SFTP as mandatory file transfer 
protocol.  It provides simple client to client file transfer, but also
a possibility for file and directory manipulation.  Even though the SFTP
is the file transfer protocol the support for file transferring has been 
done so that practically any file transfer protocol may be used with SILC 
protocol.
<br />&nbsp;<br />

<a name="f2_46"></a>
<samp class="highlight">Q: Does SILC support DCC or alike?</samp><br />
A: SILC does not support the DCC commonly used in IRC.  It does not need 
it since it has builtin support for same features that DCC have.  You can 
transfer files securely and encrypted directly with another client.  You 
can also negotiate secret key material with another client directly to 
use it in private message encryption.  The private messages are not, 
however sent directly between clients.  The protocol, on the other hand 
does not prohibit sending messages directly between clients if the 
implementation would support it.  The current SILC Client implementation 
does not support it.  This means that private messages travel through the 
SILC Network.  SILC protocol also has a capability to support DCC 
and CTCP like protocols with SILC.  None of them, however have not been 
defined to be used with SILC at the present time.
<br />&nbsp;<br />

<a name="f2_47"></a>
<samp class="highlight">Q: I am behind a firewall, can I use SILC?</samp><br />
A: Yes. If your network administrator can open the remote port 706 (TCP) you
can use SILC without problems. You may also compile your SILC client with 
SOCKS support which will proxy your SILC session through the firewall.
<br />&nbsp;<br />

<a name="f2_50"></a>
<samp class="highlight">Q: How secure SILC really is?</samp><br />
A: We have tried to make SILC as secure as possible. However, there is
no security protocol or security software that has not been vulnerable to
some sort of attacks. SILC is in no means different from this. So, it is
suspected that there are security holes in the SILC. These holes just need
to be found so that they can be fixed.  SILC's security features has been
developed from attacker's point of view, and we've tried to find all the
possible attacks and guard the protocol against them.
<br />&nbsp;<br />
But to give you some parameters of security SILC uses the most secure
crytographic algorithms such as AES (Rijndael), Twofish, Blowfish, RC5,
etc. SILC does not have DES or 3DES as DES is insecure and 3DES is just
too slow. SILC also uses cryptographically strong random number generator
when it needs random numbers. Public key cryptography uses RSA (PKCS #1)
and Diffie-Hellman algorithms. Key lengths for ciphers are initially set
to 256. For public key algorithms the starting key length is 1024 bits.
<br />&nbsp;<br />
But the best answer for this question is that SILC is as secure as its
weakest link. SILC is open and the protocol is open and in public thus
open for security analysis.
<br />&nbsp;<br />
To give a list of attacks that are ineffective against SILC:
<br />&nbsp;<br />
- Man-in-the-middle attacks are ineffective if proper public key
infrastructure is used, and if all public keys are always verified.<br />
- IP spoofing is ineffective (because of encryption and trusted keys).<br />
- Attacks that change the contents of the data or add extra data to the
packets are ineffective (because of encryption and integrity checks).<br />
- Passive attacks (listenning network traffic) are ineffective (because
of encryption). Everything is encrypted including authentication data
such as passwords when they are needed.<br />
- Any sort of cryptanalytic attacks are tried to make ineffective by
using the best cryptographic algorithms out there, and by designing the
protocol to guard against them.
<br />&nbsp;<br />

<a name="f2_60"></a>
<samp class="highlight">Q: Does SILC support instant messaging?</samp><br />
A: Officially SILC is not an instant message (IM) system as people usually
understands it.  However, SILC supports many of the features that are 
found in traditional IM systems.  SILC can be implemented in either 
IRC-style or IM-style system.  Features that are usually found only in IM 
systems, such as multiple presence settings, persistent sessions etc. are 
also found in SILC.
<br />&nbsp;<br />

<a name="f2_70"></a>
<samp class="highlight">Q: Why SILC does not have LINKS command like in 
IRC?</samp><br />
A: It was felt that this information as an own command in SILC is not 
necessary.  Moreover, the topology of the network might be undisclosed 
information even though the servers and routers in the network are still 
open. We feel that the network topology information, if it is wanted to be 
public, and the list of accessible servers can be made available in other 
ways than providing command like LINKS, which shows the active server 
links in IRC.
<br />&nbsp;<br />

<a name="f2_80"></a>
<samp class="highlight">Q: What does the session detaching/resuming 
mean?</samp><br />
A: The new SILC protocol supports a feature called session detachment. 
This means that client can detach from the server by giving a DETACH 
command, but still remain as valid user in the network.  The connection is 
lost to the server but the user remains in the network.  User can then 
resume the session back next time it connects a server in the network, and 
be like he was never gone.
<br />&nbsp;<br />
This feature clearly could be used in many cases.  For example, if you 
want to upgrade your current SILC client, you do not have to quit the 
network anymore.  You just give DETACH command and still remain in the 
network.  Then you upgrade your client and reconnect to the server and 
continue business as is.  If somebody gives WHOIS command to your nickname 
he will see that you are detached.  Messages that are sent to you when you 
are detached are dropped by the server.  Nice thing about this feature is 
also that you can resume the session from any server in the network; you 
do not have to reconnect to the same server you originally were connected 
to.
<br />&nbsp;<br />

<a name="f2_90"></a>
<samp class="highlight">Q: Is anyone outside a channel able to see the channel 
messages?</samp><br />
A: A short answer is simply No.  A longer answer involves assumptions 
about security conditions.  Initially channel keys are generated by the 
server, so if the server would get compromised it would be possible for 
an adversary to see the messages.  However, users on the channel can 
prevent this even if the server would be compromised.  It is possible to 
set so called channel private key that only the users on the channel 
know about.  The servers does not know about the key, and therefore cannot 
see the messages even if they would be compromised.  So, longer answer 
results into same as the short one; No.
<br />&nbsp;<br />

<a name="f2_95"></a>
<samp class="highlight">Q: How can I register my channel in SILC?</samp><br />
A: There is not a channel registering service in SILC.  However, SILC does 
support permanent channels.  When you join a non-existing channel for the 
first time you will become the founder of the channel.  You can then set a 
special founder mode on the channel which makes the channel permanent.  
When the last user leaves the channel when this mode is set, the channel 
will not be destroyed.  If the founder mode is not set, then empty 
channels will be destroyed automatically.  When the founder mode is set 
and you leave the channel you can also reclaim the founder rights back on 
the channel next time you join it. (see also 
<a href="#f3_70" class="normal">
Q: What does the founder mode on channel mean, and how do I set it?</a> and
<a href="#f3_80" class="normal">
Q: I am founder of invite only channel, how can I join the channel after
I have left it?</a>).  You can call this channel registering if you want.
<br />&nbsp;<br />

<a name="f2_100"></a>
<samp class="highlight">Q: Is it true that all messages are encrypted in SILC?</samp><br />
A: Most definitely yes.  The SILC protocol makes it impossible to send
unencrypted messages or packets to the SILC network.  All messages are
always encrypted, either using session keys, or other secret keys such as
channel keys or private message keys.
<br />&nbsp;<br />

<a name="f2_110"></a>
<samp class="highlight">Q: Can server or SILC operator gain operator mode on a channel?</samp><br />
A: They cannot get operator status, founder status, join invite only channels,
escape active bans, escape user limits or anything alike, without explicitly
being allowed.  Only way to get channel operator status is that someone
ops him.  Server and SILC operators in the network are normal users with
the extra privileges of being able to adminstrate their server.  They cannot
do anything more than a normal user.
<br />&nbsp;<br />

<a name="f2_120"></a>
<samp class="highlight">Q: Channel name doesn't have #-character or does it?</samp><br />
A: The #-character is not mandatory part of channel name, like it is in 
IRC.  This means that giving the command /JOIN #silc and /JOIN silc 
will join to different channels.  This is intentional since the 
#-character clearly is IRC feature and has nothing to do with SILC.  If 
you want it to have the character then just join to the channel with 
#-character in the name.
<br />&nbsp;<br />

<a name="f2_130"></a>
<samp class="highlight">Q: Does SILC support moderated channels?</samp><br />
A: Yes.  Channel founder can moderate both normal users and channel 
operators so that they cannot talk on the channel.  It is also possible to 
queit one specific user on the channel if needed.
<br />&nbsp;<br />

<a name="f2_140"></a>
<samp class="highlight">Q: What does the "watching" mean?</samp><br />
A: You can set a "watch" list for yourself in the server.  This means that 
you can watch for certain nicknames in the network.  For example, if you 
add a nickname "foo" to the watch list you will be notified when the foo 
logins to the network, leaves the network, changes its user mode or 
changes its nickname.  This way you can watch for example when does you 
friend login to the network.
<br />&nbsp;<br />

<a name="f2_150"></a>
<samp class="highlight">Q: Is it possible to reject watching?</samp><br />
A: Yes.  Since it is clear that not everyone wants to be spied on you can 
set a mode for yourself which rejects watching you.  Even if someone is 
watching the nickname you have, your logins, logoffs, mode changes or 
nickname changes will not be notified to the watcher.
<br />&nbsp;<br />

<a name="f2_160"></a>
<samp class="highlight">Q: Is it possible to block private  
messages?</samp><br />
A: Yes.  You can block incoming private messages by setting a mode that 
prevents unwanted private messages.  Only the private messages that are 
secured with a private message key are delivered to you.  This implies 
that you have negotiated the private key with the sender of the message, 
and therefore want to receive messages from that user.  Other private 
messages that are secured with normal session keys are dropped when the 
mode is set.
<br />&nbsp;<br />

<a name="f2_170"></a>
<samp class="highlight">Q: Is it possible to block channel
messages?</samp><br />
A: Yes it is.  By setting a mode that accomplishes this you can prevent 
the server of sending any channel messages to you.  There is also a mode
that allows blocking channel messages from normal users.  This means that 
you will receive channel messages only when it is sent by channel operator 
or channel founder.  It is also possible to block channel messages sent by 
robots.  A user on the channel can have a robot mode set (which means that 
the user is actually a robot program), and messages sent from that user 
can be blocked with the mode.
<br />&nbsp;<br />

<a name="f2_180"></a>
<samp class="highlight">Q: Is it possible to block invites?</samp><br />
A: It sure is.  You can set a mode that prevents the server of sending 
invite notifications to you.  This can for example prevent invite 
flooding.  The downside is that it may make joining to a invite only 
channels a bit harder.
<br />&nbsp;<br />

<a name="f2_190"></a>
<samp class="highlight">Q: Does SILC support multimedia messages, like 
video/audio streaming?</samp><br />
A: Yes it does.  The new version of the protocol supports sending of MIME 
objects as messages.  Since MIME objects can easily represent any kind of 
data, such as video stream, audio stream, images, etc. it is easy to send 
these multimedia messages in SILC.  It also makes video conferencing 
possible with SILC.  It can work by sending the stream(s) to a channel and 
everybody who joins the channel can receive the stream.  This feature in 
the protocol surely makes possible many kind of multimedia applications in 
the future.
<br />&nbsp;<br />

<a name="f2_200"></a>
<samp class="highlight">Q: Is it possible to send picture/image messages?
</samp><br />
A: Yes.  Since it is possible to send any kind of MIME object as a message
it is also possible to send pictures and images as messages.  It would be
possible to for example send a hand/mouse written messages.
<br />&nbsp;<br />

<a name="f2_205"></a>
<samp class="highlight">Q: What kind of presence modes SILC 
support?</samp><br />
A: By presence we mean indication of presence in the network, and SILC 
supports several different kinds of presence modes.  They can be changed
with the UMODE command which changes your user mode in the network.  
Currently there is the following modes for presence:  GONE (I'm away), 
INDISPOSED (I cannot be here), BUSY (I'm busy, don't bother me), PAGE 
(page me if you want to talk), and HYPER (I'm hyper active, talk to me).
When mode is not set it means you are present in the network.  There are 
many other user modes as well, but they are not directly related to 
presence indication.
<br />&nbsp;<br />

<a name="f2_210"></a>
<samp class="highlight">Q: Does SILC support anonymity?</samp><br />
A: The protocol has a user mode which indicates that user is anonymous 
user.  The user cannot set or unset the mode itself, but a server which 
provides these anonymous chatting services can set the mode for the user 
that connects to the server.  User that has the mode set has their 
username and hostname information scrambled.  There are other ways of 
making anonymity in SILC but they all are implementational methods, and 
protocol does not handle those methods.
<br />&nbsp;<br />

<a name="f2_220"></a>
<samp class="highlight">Q: Does SILC support services?</samp><br />
A: Yes it does.  There is command called SERVICE which can be used by 
clients and servers to negotiate a service agreement with a remote server.  
The protocol does not however define any services currently.
<br />&nbsp;<br />

<a name="f2_230"></a>
<samp class="highlight">Q: I have suggestions to SILC Protocol, what can I do?</samp><br />
A: All suggestions and improvements are of course welcome. You should read 
the protocol specifications first to check out whether your idea is 
covered by them already. The best place to make your idea public is the 
SILC development mailing list.  You might want to checkout the TODO list
from the CVS as well.
<br />&nbsp;<br />


<a name="f3_0"></a><br />
<b>3. Client Questions</b><br />&nbsp;<br />

<a name="f3_10"></a>
<samp class="highlight">Q: Where can I find SILC clients?</samp><br />
A: The official SILC client is available for free download from the
silcnet.org web page.  There is also several independent projects working 
with the SILC Toolkit to come up with various other clients.           
<a href="http://bombyx.sourceforge.net" class="normal">Bombyx</a> is a 
cross-platform GUI client written with FLTK.  <a 
href="http://milc.sourceforge.net" class="normal">Milc</a> 
is also a cross-platform GUI client written with WxWindows.  See also
our <a href="?page=links" class="normal">links page</a> for links to other 
clients.
<br />&nbsp;<br />

<a name="f3_20"></a>
<samp class="highlight">Q: Can I use SILC with IRC client and vice versa?</samp><br />
A: Generally the answer would be no for both. However, there exist already 
at least one IRC client that supports SILC, the <a href="http://irssi.org/"
class="normal">Irssi client</a>. The current SILC client is actually based
on the user interface of the Irssi client. So, yes it is possible to use
SILC with some IRC clients and vice versa. You can use SILC plug-in in Irssi
and have support for both protocols in one client. But, this does not mean
that you can talk from SILC network to IRC network, that is not possible. 
<br />&nbsp;<br />

<a name="f3_25"></a>
<samp class="highlight">Q: The default theme sucks, where can I find a better one?</samp><br />
A: The Irssi SILC client's theme files are almost 100% compatible with
the original Irssi IRC client's themes.  You can get those theme files
from the <a href="http://irssi.org/" class="normal">Irssi project website</a>. 
You can also try to make a better theme by yourself.
<br />&nbsp;<br />

<a name="f3_30"></a>
<samp class="highlight">Q: How do I send a private message?</samp><br />
A: Sending private message is done by using the MSG command.  For example,
command: <samp class="highlight">/MSG john hello</samp>, will send a 
`hello' message to a nickname `john'.  By default private messages are
secured with session keys, and the message is re-encrypted by the servers
when the message travels to the receiver.  If you would like to secure the
private messages with a private key, you can negotiate a secret key with the
receiver.  Always remember to give WHOIS command before sending a private
message to assure that you are sending the message to correct person.
<br />&nbsp;<br />

<a name="f3_40"></a>
<samp class="highlight">Q: How do I negotiate secret key with another user?</samp><br />
A: It is important to negotiate secret keys if you cannot trust the servers
and the network you are using.  By negotiating a key with the user you
want to talk to assures that no one except you and your friend is able
to encrypt and decrypt the messages.  The secret key negotiation is done with
the KEY command.  Here is an example of how to negotiate keys for securing
private messages.
<br />&nbsp;<br />
By giving command: <samp class="highlight">/KEY MSG john agreement 
192.168.2.100</samp>, you will send a key negotiation request to a nickname
`john'.  The 192.168.2.100 IP address would be your machine's IP address.
You can also define an port to the KEY command after the IP address. If
you do not do that the operating system will bind to a port of its choosing.
John will receive a notification on the screen that you would like to 
negotiate secret keys with him, and he will receive the IP address and port
where you are listenning for the negotiation.  When he gives command: 
<samp class="highlight">/KEY MSG You negotiate 192.168.2.100 31382</samp>,
the key negotiation is started.  During the key negotiation you will be
prompted on the screen to verify and accept John's public key if you do not
have his public key already.  The John will be prompted to accept your
public key as well.  After the key negotiation is over all private messages
sent between you and John are secured with the negotiated secret key.
Note that you must verify the public key you are prompted for, and this is
very important since someone could be doing man-in-the-middle attack.
<br />&nbsp;<br />

<a name="f3_50"></a>
<samp class="highlight">Q: How do I negotiate secret keys behind a NAT?</samp><br />
A: If only you are behind a NAT, or firewall then key negotiation works,
but if both you and your friend are behind a NAT then key negotiation will
not work, since it is done peer to peer.  If you are behind a NAT then you
obviously cannot receive key negotiations, and cannot bind to any IP address
and port.  However, you can still use KEY command to negotiate the keys.
<br />&nbsp;<br />
By giving command: <samp class="highlight">/KEY MSG john agreement</samp>, 
without any other arguments (such as IP address and port) you will send
a negotiation request to John, but do not provide an address and port for
the John to connect to.  When John receives the notification on the screen
that you would like to perform key negotiation, he can give command:
<samp class="highlight">/KEY MSG You agreement 172.16.100.78</samp>, which
will send key negotiation request back to you.  You will receive the IP
address and port where you need to connect in order to perform the negotiation.
After receiving the notification you can give command: <samp class="highlight">
/KEY MSG john negotiate 172.16.100.78 31181</samp>, which will start the
key negotiation with John.  This way you can negotiate the keys if you are
behind a NAT.
<br />&nbsp;<br />

<a name="f3_60"></a>
<samp class="highlight">Q: How do I change channel modes?</samp><br />
A: The command to manage channel modes is CMODE.  With this command you
can change the channel status (to change it to secret channel for example),
set user limit on the channel, passphrase for the channel, set the channel
to use private keys on channel, and set the founder mode.
<br />&nbsp;<br />

<a name="f3_70"></a>
<samp class="highlight">Q: What does the founder mode on channel mean, and how do I set it?</samp><br />
A: Who ever creates the channel by being the first user to join the channel
becomes automatically the founder of the channel.  Founder has some extra
privileges on the channel.  For example, it is not possible to kick the
founder off the channel, and there are some channel modes that only the
founder of the channel can change.  If the creator of the channel wishes
to preserve the channel founder mode even if he leave the channel he
can set the founder mode for the channel.
<br />&nbsp;<br />
The mode is set by giving command: <samp class="highlight">/CMODE #channel
+f</samp>.  This will set the founder mode and will use the public
key of the founder as authenticator when the user is reclaiming the mode
back.  If the founder leaves the channel he will be able to get the founder
mode back by using JOIN or CUMODE commmands.  Giving command
<samp class="highlight">/JOIN #channel -founder</samp>,
will get the founder mode back at the same time he joins the channel, or
giving commmand <samp class="highlight">/CUMODE #channel +f yournick</samp>,
will also give the founder mode back on the channel after he has joined
the channel.
<br />&nbsp;<br />
The founder mode also means that the channel becomes permanent when it is 
set.  This means that when the last client leaves the channel the channel 
is not destroyed when the founder mode is set.  Next time someone joins 
the channel he will not become the founder of the channel if the channel 
already existed (but were empty).  If the founder mode is not set when 
last user leaves the channel, the channel will be destroyed.  When you set 
the mode for the channel and leave the channel you can reclaim the founder 
rights to yourself back at any time when you rejoin the channel.
<br />&nbsp;<br />

<a name="f3_80"></a>
<samp class="highlight">Q: I am founder of invite only channel, how can I join the channel after I have left it?</samp><br />
A: Founder can override the invite only status by reclaiming the founder
status on the channel using the JOIN command.  The channel must have the
founder mode set in order for it to work.  Reclaiming founder status using
JOIN command is important also if the channel has user limit set, and has
active bans.  Founder can override these conditions as well.  However,
founder cannot override the passphrase of the channel if it is set.  To
get the founder mode during JOIN and to override the invite only condition,
give command: <samp class="highlight">/JOIN #channel -founder</samp>.
This will join the channel and attempt to reclaim the founder status back
to you.
<br />&nbsp;<br />

<a name="f3_90"></a>
<samp class="highlight">Q: How can I op or deop somebody on channel?</samp><br />
A: Giving operator status, or removing the operator status on a channel
requires you to have at least operator status, or founder status on the
channel.  You can give operator status to another user by using CUMODE
command.  To give ops give the command: <samp class="highlight">/CUMODE
#channel +o john</samp>, and to remove ops give command:
<samp class="highlight">/CUMODE #channel -o john</samp>.  To indicate
current channel you can also use `*' character in #channel's stead.
<br />&nbsp;<br />

<a name="f3_100"></a>
<samp class="highlight">Q: How do I set private key for channel, and what does that mean exactly?</samp><br />
A: Setting private key for channel requires first to set the private key mode
for the channel.  You need to be the founder of the channel to be able to
do this.  Give the command: <samp class="highlight">/CMODE #channel +k</samp>.
After this mode is set the old channel key will not be used to encrypt and
decrypt channel messages.  To set the key for the channel use the KEY command.
Every user on the channel must do the same thing and set the same key.
If some user on the channel does not set the key (or does not know the key)
he won't be able to see any messages on the channel.  Give the command: 
<samp class="highlight">/KEY CHANNEL #channel set verysecretkey</samp>.  
This  command will set the `verysecretkey' passphrase as key to #channel.
How exactly other users will know this key is out of scope of the SILC
protocol.  SILC does not provide yet a possibility of negotiating secret key
with many users at the same time.  For this reason the secret key on the
channel is usually a passphrase or a password that all users on the channel
have to know.  Setting a private key for channel means that only the users
on the channel who know the key is able to encrypt and decrypt messages.
Servers do not know the key at all.  If you remove the private key mode
from the channel, all users will start automatically using a new channel
key to secure channel messages.
<br />&nbsp;<br />

<a name="f3_110"></a>
<samp class="highlight">Q: How do I transfer a file?</samp><br />
A: You can transfer files securely using the FILE command.  This command
will automatically negotiate secret key with the remote user and the
file transfer stream is secured using that key.  The file transfer
stream is always sent peer to peer.  If you would like to send a file
to another user you can give command: <samp class="highlight">/FILE
SEND path/to/the/file john</samp>.  This command sends, or actually
makes the `path/to/the/file' available for download for the user `john'.
The John will decide whether he wants to actually download the file.
When John gives the command: <samp class="highlight">/FILE RECEIVE</samp>,
the key negotiation is started.  You and John will be prompted to verify
and accept each other's public key if you do not have it cached already.
After key negotiation is over the file transfer process starts.
If you want to cancel the file transfer session, or if John wants to
reject the file transfer request, giving the command: <samp class="highlight">
/FILE CLOSE</samp> will close the session.
<br />&nbsp;<br />

<a name="f3_120"></a>
<samp class="highlight">Q: How can I get other users public keys?</samp><br />
A: You can get a user's public key using the GETKEY command.  This command
will fetch the user's public key from the server where the user has connected
to.  The server has verified that the user posesses the corresponding private
key, however, you will be prompted to verify and accept the public key.
All client public keys are saved in your local key directory in
~/.silc/clientkeys/.  You can also receive clients public keys during
key negotiation and file transfers.  The GETKEY command can be used to fetch
a server's public key as well.  Those keys are saved in ~/.silc/serverkeys/
directory.
<br />&nbsp;<br />

<a name="f3_130"></a>
<samp class="highlight">Q: How can I see the fingerprint of my public key?</samp><br />
A: You can check out your own fingerprint by giving just WHOIS command without
any arguments.  Additionally you can also dump the contents of the key file
using the silc program and giving -S option to it.  Your own public key is
always saved in ~/.silc/public_key.pub file.  To dump your key run silc as:
<samp class="highlight">silc -S .silc/public_key.pub</samp>.  The same way
you can dump the contents of any public key inside ~/.silc/clientkeys/ and
~/.silc/serverkeys/ directories.  The WHOIS command will also show other
users public key fingerprints.
<br />&nbsp;<br />

<a name="f3_140"></a>
<samp class="highlight">Q: I gave WHOIS to a nick, and it returned multiple replies, why?</samp><br />
A: This will happen if there are several same nicknames in the network at
the same time.  As you may already know nicknames are not unique in SILC
network.  This means there can be multiple same nicknames.  This also means
that you can always have the nickname you want.  If WHOIS returns multiple
replies, you can distinguish the users by their realname, username,
hostname and ultimately by the fingerprint of their public key, which the
WHOIS will also show.  You will also notice an additional nickname inside a
parenthesis.  It may show for example: <samp class="highlight">nickname:   John
 (John@otaku)</samp>.  The real nickname is `John', but since there are
many John's in the network you can access this one using `John@otaku'.
So, if you were to send private message to this particular John you can do
it by giving command: <samp class="highlight">/MSG John@otaku hello</samp>. 
This will send `hello' message to the John@otaku.
<br />&nbsp;<br />

<a name="f3_150"></a>
<samp class="highlight">Q: Is there a command to see all linked servers?</samp><br />
A: No there is not.  For longer answer see also <a href="#f2_70" 
class="normal">this FAQ</a>.
<br />&nbsp;<br />

<a name="f3_160"></a>
<samp class="highlight">Q: How do I list the users of a channel?</samp><br />
A: The command to list all users on a particular channel is USERS.  It is
also aliased to WHO command in Irssi SILC Client.  To see the users of the
current channel give the command: <samp class="highlight">/USERS *</samp>.
You can replace the `*' with the channel name of your choosing.  If the
channel is private or secret channel, and you have not joined the channel,
you cannot list the users of that channel.
<br />&nbsp;<br />

<a name="f3_170"></a>
<samp class="highlight">Q: What is the difference between OPER and SILCOPER commands?</samp><br />
A: The OPER command is used to gain server operator privileges on normal
SILC server, while SILCOPER is used to gain router operator (also known as
SILC operator) privileges on router server.  You cannot use SILCOPER command
on normal SILC server, it works only on router server.
<br />&nbsp;<br />

<a name="f3_180"></a>
<samp class="highlight">Q: My Cygwin client crashes with message "Couldn't create //.silc directory"</samp><br />
A: A solutions should be setting HOME enviroment variable to the directory where you
have unpacked your SILC Client. Type to your command prompt something like: <br />
<tt class="normal">c:\&gt;set HOME=c:\silc</tt>
<br />&nbsp;<br />

<a name="f3_190"></a>
<samp class="highlight">Q: Why /join #silc and /join silc doesn't join the same channel?</samp><br />
A: The #-character is not mandatory part of channel name in SILC.  So 
#silc and silc are two different channels.  The #-character in channel 
name is IRC feature and has nothing to do with SILC.  If you have 
#-character in the channel name, then it is part of the channel name, just 
like %-character, or &-character could be part of channel name.
<br />&nbsp;<br />

<a name="f3_200"></a>
<samp class="highlight">Q: How do I detach my session from the
server?</samp><br />
A: You can detach your session by simply giving DETACH command.  Your 
connection to the server will be closed automatically.  Next time you 
connect any server in the network your session will be automatically 
resumed.  If there is an error during session resuming your connection 
will be closed and you need to reconnect to the server.  In this case the 
old sessionn cannot be resumed anymore.
<br />&nbsp;<br />


<a name="f4_0"></a><br />
<b>4. Server Questions</b><br />&nbsp;<br />

<a name="f4_10"></a>
<samp class="highlight">Q: Where can I find SILC servers?</samp><br />
A: The SILC server is available for free download from the silcnet.org 
web page. We are not aware of any other SILC server implementations, so far.
<br />&nbsp;<br />

<a name="f4_20"></a>
<samp class="highlight">Q: Can I run my own SILC server?</samp><br />
A: Yes of course. Download the SILC server package, compile and install 
it. Be sure to check out the installation instructions and the README 
file. You also should decide whether you want to run SILC server or SILC 
router.
<br />&nbsp;<br />

<a name="f4_30"></a>
<samp class="highlight">Q: What is the difference between SILC 
server and SILC router?</samp><br />
A: The topology of the SILC network includes SILC routers and the SILC 
servers (and SILC clients of course). Normal SILC server does not have 
direct connections with other SILC servers. They connect directly to the 
SILC router. SILC Routers may have several server connections and they 
may connect to several SILC routers. The SILC routers are the servers in 
the network that know everything about everything. The SILC servers know 
only local information and query global information from the router when 
necessary.
<br />&nbsp;<br />
If you are running SILC server you want to run it as router only if you 
want to have server connections in it and are prepared to accept server 
connections. You also need to get the router connected to some other 
router to be able to join the SILC network. You may run the server as 
normal SILC server if you do not want to accept other server connections 
or cannot run it as router.
<br />&nbsp;<br />

<a name="f4_40"></a>
<samp class="highlight">Q: Why server says permission denied to write to a 
log file?</samp><br />
A: The owner of the log files must be same user that the server is run 
under, by default it is user `nobody'.  Just change the permissions and 
try again.
<br />&nbsp;<br />

<a name="f4_50"></a>
<samp class="highlight">Q: When I connect to my server it says "server does 
not support one of your proposed ciphers", what is wrong?</samp><br />
A: Most likely the ciphers and others has not been compiled as SIMs 
(modules) and they are configured as modules in the silcd.conf. If they 
are not compiled as modules remove the module paths from the ciphers and 
hash functions from the silcd.conf, so that the server use the builtin 
ciphers. Then try connecting to the server again. It is also possible 
that the client IS proposing some ciphers that your server does not support.
<br />&nbsp;<br />

<a name="f4_60"></a>
<samp class="highlight">Q: Why SILC server runs on privileged port 706?</samp><br />
A: Ports 706/tcp and 706/udp have been assigned for the SILC protocol by
<a href="http://www.iana.org" class="normal">IANA</a>. Server on the network
listening above privileged ports (&gt;1023) SHOULD NOT be trusted as it could
have been set up by untrusted party. The server normally drops root privileges
after startup and then run as user previously defined in silcd.conf.
<br />&nbsp;<br />

<a name="f4_70"></a>
<samp class="highlight">Q: I see [Unknown] in the log file, what does it mean?</samp><br />
A: You can see in the log file for example: <samp class="highlight">
[Info] Closing connection 192.168.78.139:3214 [Unknown]</samp>.  The [Unknown]
means that the connection was not authenticated yet, and it is not known
whether the connection was a client, server or router.  There will appear
[Client], [Server] or [Router] if the connection is authenticated at that
point.
<br />&nbsp;<br />

<a name="f4_80"></a>
<samp class="highlight">Q: How can I generate a new server key pair?</samp><br />
A: You can generate a new key pair using the silcd command with the -C 
option.  When SILC Server is installed a key pair is generated 
automatically for you.  However, it is suggested that you check the 
information found in that key and generate a new key pair if the 
information is incorrect.  You can check the information of your public 
key by giving command: <samp class="highlight">silc -S file.pub</samp>.
<br />&nbsp;<br />
If you want to generate a new key pair then you can give for example 
command: <samp class="highlight">
silcd -C . --identifier="UN=silc-oper, HN=silc.silcnet.org, RN=SILC Router 
Admin, E=silc-oper@silcnet.org, O=SILC Project, C=SK"</samp>. This will 
create the key pair to current directory, with the specified identifier.  
Please, give the --help option to the silcd to see usage help for the -C 
and --identifier options.
<br />&nbsp;<br />


<a name="f5_0"></a><br />
<b>5. Toolkit Questions</b><br />&nbsp;<br />

<a name="f5_10"></a>
<samp class="highlight">Q: What is SILC Toolkit?</samp><br />
A: SILC Toolkit is a package intended for software developers who would 
like to develope their own SILC based applications or help in the 
development of the SILC. The Toolkit includes SILC Protocol Core library, 
SILC Crypto library, SILC Key Exchange (SKE) library, SILC Math 
library, SILC Modules (SIM) library, SILC Utility library, SILC Client 
library and few other libraries. 
<br />&nbsp;<br />

<a name="f5_20"></a>
<samp class="highlight">Q: Is the SILC Toolkit Reference Manual Available?</samp><br />
A: Yes, partially completed reference manual is available in the Toolkit 
releases as HTML package and they are available from the silcnet.org 
website as well at the <a href="?page=docs" class="normal">documentation </a> page.
<br />&nbsp;<br />

<a name="f5_30"></a>
<samp class="highlight">Q: How do I compile the Toolkit on Unix?</samp><br />
A: You should read the INSTALL file from the package and follow its 
instructions.  The compilation on Unix is as simple as compiling any other 
SILC package.  Give, `./configure' command and then `make' command.
<br />&nbsp;<br />

<a name="f5_40"></a>
<samp class="highlight">Q: How do I compile the Toolkit on Win32?</samp><br />
A: We have prepared instructions to compile the Toolkit on Win32 in the 
Toolkit package.  Please, read the README.WIN32 file from the package for 
detailed instructions how to compile the Toolkit for Cygwin, MinGW and 
native Win32 systems.  We have also prepared ready MSVC++ Workspace files 
in the win32/ directory in the package that will compile automatically 
the Toolkit.
<br />&nbsp;<br />

<a name="f5_50"></a>
<samp class="highlight">Q: Does the Toolkit package include any sample code?</samp><br />
A: Yes, naturally.  It includes sample codes for two different SILC Client 
implementations, and SILC Server.  The silcer/ directory includes a simple
GUI client based on GTK--, and Win32 samples are included in the win32/
directory, for simple client.
<br />&nbsp;<br />
