/*
 *	SILCUnknownPayload.java		2002/11/08
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.silcprotocol;

import java.lang.String;
import com.alistairphipps.util.Hex;

/** Class to implement an Unknown payload - one we don't know how to handle. 
 *
 * @author Alistair K Phipps
 * @version 20021108
 */
public class SILCUnknownPayload extends SILCPayload
{
	private byte[] _ylData;
	
	/** Constructor to set up the payload with default values.
	 */
	public SILCUnknownPayload() 
	{
		_ylData = new byte[0];
	}

	/** Constructor to set up the payload information from a bytelist
	 * @param yl List of bytes forming received payload
	 */
	public SILCUnknownPayload( byte[] yl )
	{
		_ylData = yl;
	}
	
	// doc inherited
	public byte[] toByteList()
	{
		return _ylData;
	}

	// doc inherited
	public String toString()
	{
		String strRet;
		strRet = "Payload: " + Hex.toString( _ylData );
		return strRet;
	}

	public boolean isList()
	{
		return false;
	}
}
