/*
 *	ChatFrame.java		2002/11/17
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.swingui;

import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import com.alistairphipps.jsilc.core.*;
import com.alistairphipps.jsilc.silcprotocol.*;

/** 
 * An internal frame for chat in a channel
 * @author Alistair K Phipps
 * @version 2002/11/17
 */
class ChatFrame extends JInternalFrame
{
	/** keep a count of the number of frames open so we can cascade them */
	private static int s_iOpenFrameCount = 0;
	/** default offset for cascade */
	private static final int s_iXOffset = 30, s_iYOffset = 30;

	private Entity _entity;
	private JTextPane _display;
	private JTextField _input;
	private JScrollPane _scrollpane;
	private MainFrame _mainframe;
	
	private class InputL implements ActionListener
	{
		public void actionPerformed( ActionEvent e )
		{
			String strIn = _input.getText();

			String strScreen = "";
			// if we have a /msg ... then send to the user specified
			if( strIn.startsWith( "/msg" ) )
			{
				StringTokenizer t = new StringTokenizer( strIn );
				if( t.countTokens() >= 3 ) // make sure we have /msg nick message
				{
					t.nextToken();	// discard /msg
					String strUsername = t.nextToken();
					String strMessage = "";
					while( t.hasMoreTokens() )
						strMessage += t.nextToken() + " ";
					strMessage = strMessage.trim();	// lose leading/trailing whitespace - FIXME: probably shouldn't do this
					strScreen = strMessage;
					
					// SILCEntity entity = (SILCEntity)_mainframe.searchEntity(strUsername);
					
					// lookup entity
					
					
					// SILCEntity test = new SILCEntity();
					// _mainframe.sendMessage( _entity, strMessage );	// send it
				}
			}
			else


			// send message to remote host
			_mainframe.sendMessage( _entity, strIn );
			
			// reset input field
			_input.setText( "" );

			// output text to our window
			outputMessageWithUsername( "me", strIn );	// FIXME: get our nickname from mainframe
		}
	}
	
	public void outputMessage( String strMessage )
	{
		outputMessageWithUsername( _entity.getFriendlyName(), strMessage );
	}

	private void outputMessageWithUsername( String strUsername, String strMessage )
	{
		Document doc = _display.getDocument();
		strMessage = "<" + strUsername + "> " + strMessage + "\n";
		try
		{
			doc.insertString( doc.getLength(), strMessage, null ); // null = no attributes
		}
      	catch (Exception e)	// discard BadLocationException - shouldn't happen
		{}

		// Force scrollpane to bottom of display - have to do it this way as it never updates otherwise (due to having to repaint before next pos visible)
		SwingUtilities.invokeLater(
			new Runnable()
			{
				public void run()
				{
					JScrollBar sb = _scrollpane.getVerticalScrollBar();
					sb.setValue( sb.getMaximum() );
				}
			}
		);
	}
	
	/** setup output field and text input field */
	private void setupComponents()
	{
		Container cp = getContentPane();

		// Add scrollable text pane for display of incoming messages
		_display = new JTextPane();
		_display.setDocument(new DefaultStyledDocument());
		_display.setEditable(false);
		_scrollpane = new JScrollPane( _display, ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS, ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER );
		cp.add(_scrollpane, BorderLayout.CENTER);

		// Add text field for command/message entry
		_input = new JTextField();
		_input.addActionListener( new InputL() );
		cp.add( _input, BorderLayout.SOUTH );
	}
	
	/** Ctor to create a chat frame for the given source */
	public ChatFrame( MainFrame mainframe, Entity entity )
	{
		super( entity.getFriendlyName(), true, true, true, true );	// resizeable, closable, maximiseable, iconifiable
		_mainframe = mainframe;	// need this for callbacks
		_entity = entity;
		setupComponents();
		setSize( 300, 200 ); 	// default size... TODO: use a metric to make a better size guess
		s_iOpenFrameCount++;
		setLocation( s_iXOffset * s_iOpenFrameCount, s_iYOffset * s_iOpenFrameCount );	// cascade channel frames by default
		setVisible( true );
	}
}
