/*
 *	TestSILCKeyExchangeStartPayload.java		2002/11/06
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.test;

import java.util.logging.*;
import com.alistairphipps.jsilc.silcprotocol.SILCKeyExchangeStartPayload;

/** 
 * Test harness for SILCKeyExchangeStartPayload class, checking that fromByteList and toByteList and back work, and toString
 * @author Alistair K Phipps
 * @version 2002/11/08
 */
public class TestSILCKeyExchangeStartPayload
{
	/** logger is used for logging */
	private static Logger logger = Logger.getLogger( "com.alistairphipps.jsilc.test.testsilckeyexchangestartpayload" );

	/**
	 * Performs all the functions of the class.
	 */
	public static void main( String[] args )
	{
		logger.entering( "TestSILCKeyExchangeStartPayload", "main" );
		try
		{
			SILCKeyExchangeStartPayload kes = new SILCKeyExchangeStartPayload();
			logger.info( "Testing toString" );
			System.out.println( "OUTPUT\n======\n" + kes.toString() + "\n======" );
			logger.info( "Converting to bytes" );
			byte[] a = kes.toByteList();
			logger.info( "Converting from bytes" );
			SILCKeyExchangeStartPayload kes2 = new SILCKeyExchangeStartPayload( a );
			logger.info( "Testing toString on converted instance" );
			System.out.println( "OUTPUT\n======\n" + kes2.toString() + "\n======" );
		}
		catch( Exception e )
		{
			logger.severe( "Caught exception: " + e.toString() );
			e.printStackTrace();
		}
		finally
		{
			logger.exiting( "TestSILCKeyExchangeStartPayload", "main" );
		}
	}
}
