/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.AuthAttributes;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.cms.CMSVersion;
import org.bouncycastle.asn1.cms.DigestAlgorithmIdentifier;
import org.bouncycastle.asn1.cms.EncapsulatedContentInfo;
import org.bouncycastle.asn1.cms.MessageAuthenticationCode;
import org.bouncycastle.asn1.cms.MessageAuthenticationCodeAlgorithm;
import org.bouncycastle.asn1.cms.OriginatorInfo;
import org.bouncycastle.asn1.cms.RecipientInfos;
import org.bouncycastle.asn1.cms.UnauthAttributes;

public class AuthenticatedData
extends CMSObject {
    private CMSVersion version;
    private OriginatorInfo originatorInfo;
    private RecipientInfos recipientInfos;
    private MessageAuthenticationCodeAlgorithm macAlgorithm;
    private DigestAlgorithmIdentifier digestAlgorithm;
    private EncapsulatedContentInfo encapContentInfo;
    private AuthAttributes authenticatedAttributes;
    private MessageAuthenticationCode mac;
    private UnauthAttributes unauthenticatedAttributes;

    public AuthenticatedData(OriginatorInfo originatorInfo, RecipientInfos recipientInfos, MessageAuthenticationCodeAlgorithm messageAuthenticationCodeAlgorithm, DigestAlgorithmIdentifier digestAlgorithmIdentifier, EncapsulatedContentInfo encapsulatedContentInfo, AuthAttributes authAttributes, MessageAuthenticationCode messageAuthenticationCode, UnauthAttributes unauthAttributes) {
        this.setOriginatorInfo(originatorInfo);
        this.setRecipientInfos(recipientInfos);
        this.setMacAlgorithm(messageAuthenticationCodeAlgorithm);
        this.setDigestAlgorithm(digestAlgorithmIdentifier);
        this.setEncapContentInfo(encapsulatedContentInfo);
        this.setAuthenticatedAttributes(authAttributes);
        this.setMac(messageAuthenticationCode);
        this.setUnauthenticatedAttributes(unauthAttributes);
        this.setVersion();
    }

    public AuthenticatedData(ASN1Sequence aSN1Sequence) {
        int n = 0;
        DEREncodable dEREncodable = aSN1Sequence.getObjectAt(n++);
        this.version = CMSVersion.getInstance(dEREncodable);
        dEREncodable = aSN1Sequence.getObjectAt(n++);
        if (dEREncodable instanceof ASN1TaggedObject) {
            this.originatorInfo = OriginatorInfo.getInstance((ASN1TaggedObject)dEREncodable, false);
            dEREncodable = aSN1Sequence.getObjectAt(n++);
        }
        this.recipientInfos = RecipientInfos.getInstance(dEREncodable);
        this.macAlgorithm = MessageAuthenticationCodeAlgorithm.getInstance(aSN1Sequence.getObjectAt(n++));
        if ((dEREncodable = aSN1Sequence.getObjectAt(n++)) instanceof ASN1TaggedObject) {
            this.digestAlgorithm = DigestAlgorithmIdentifier.getInstance((ASN1TaggedObject)dEREncodable, false);
            dEREncodable = aSN1Sequence.getObjectAt(n++);
        }
        this.encapContentInfo = EncapsulatedContentInfo.getInstance(dEREncodable);
        if ((dEREncodable = aSN1Sequence.getObjectAt(n++)) instanceof ASN1TaggedObject) {
            this.authenticatedAttributes = AuthAttributes.getInstance((ASN1TaggedObject)dEREncodable, false);
            dEREncodable = aSN1Sequence.getObjectAt(n++);
        }
        this.mac = MessageAuthenticationCode.getInstance(dEREncodable);
        if (aSN1Sequence.getSize() > n) {
            this.unauthenticatedAttributes = UnauthAttributes.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(n++), false);
        }
    }

    public AuthenticatedData(AuthenticatedData authenticatedData) {
        this.version = authenticatedData.version;
        this.originatorInfo = authenticatedData.originatorInfo;
        this.recipientInfos = authenticatedData.recipientInfos;
        this.macAlgorithm = authenticatedData.macAlgorithm;
        this.digestAlgorithm = authenticatedData.digestAlgorithm;
        this.encapContentInfo = authenticatedData.encapContentInfo;
        this.authenticatedAttributes = authenticatedData.authenticatedAttributes;
        this.mac = authenticatedData.mac;
        this.unauthenticatedAttributes = authenticatedData.unauthenticatedAttributes;
    }

    public static AuthenticatedData getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return AuthenticatedData.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static AuthenticatedData getInstance(Object object) {
        if (object == null || object instanceof AuthenticatedData) {
            return (AuthenticatedData)object;
        }
        if (object instanceof ASN1Sequence) {
            return new AuthenticatedData((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid AuthenticatedData: " + object.getClass().getName());
    }

    public CMSVersion getVersion() {
        return this.version;
    }

    public OriginatorInfo getOriginatorInfo() {
        return this.originatorInfo;
    }

    public RecipientInfos getRecipientInfos() {
        return this.recipientInfos;
    }

    public MessageAuthenticationCodeAlgorithm getMacAlgorithm() {
        return this.macAlgorithm;
    }

    public DigestAlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public EncapsulatedContentInfo getEncapContentInfo() {
        return this.encapContentInfo;
    }

    public AuthAttributes getAuthenticatedAttributes() {
        return this.authenticatedAttributes;
    }

    public MessageAuthenticationCode getMac() {
        return this.mac;
    }

    public UnauthAttributes getUnauthenticatedAttributes() {
        return this.unauthenticatedAttributes;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.version);
        if (this.originatorInfo != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(false, 0, this.originatorInfo.getDERObject()));
        }
        bERConstructedSequence.addObject(this.recipientInfos);
        bERConstructedSequence.addObject(this.macAlgorithm);
        if (this.digestAlgorithm != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(false, 1, this.digestAlgorithm.getDERObject()));
        }
        bERConstructedSequence.addObject(this.encapContentInfo);
        if (this.authenticatedAttributes != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(false, 2, this.authenticatedAttributes.getDERObject()));
        }
        bERConstructedSequence.addObject(this.mac);
        if (this.unauthenticatedAttributes != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(false, 3, this.unauthenticatedAttributes.getDERObject()));
        }
        return bERConstructedSequence;
    }

    private void setVersion(CMSVersion cMSVersion) {
        this.version = cMSVersion;
    }

    private void setVersion() {
        this.setVersion(new CMSVersion(new BigInteger("0")));
    }

    private void setOriginatorInfo(OriginatorInfo originatorInfo) {
        this.originatorInfo = originatorInfo;
    }

    private void setRecipientInfos(RecipientInfos recipientInfos) {
        this.recipientInfos = recipientInfos;
    }

    private void setMacAlgorithm(MessageAuthenticationCodeAlgorithm messageAuthenticationCodeAlgorithm) {
        this.macAlgorithm = messageAuthenticationCodeAlgorithm;
    }

    private void setDigestAlgorithm(DigestAlgorithmIdentifier digestAlgorithmIdentifier) {
        this.digestAlgorithm = digestAlgorithmIdentifier;
    }

    private void setEncapContentInfo(EncapsulatedContentInfo encapsulatedContentInfo) {
        this.encapContentInfo = encapsulatedContentInfo;
    }

    private void setAuthenticatedAttributes(AuthAttributes authAttributes) {
        this.authenticatedAttributes = authAttributes;
    }

    private void setMac(MessageAuthenticationCode messageAuthenticationCode) {
        this.mac = messageAuthenticationCode;
    }

    private void setUnauthenticatedAttributes(UnauthAttributes unauthAttributes) {
        this.unauthenticatedAttributes = unauthAttributes;
    }
}

