/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.cms.ExtendedCertificate;
import org.bouncycastle.asn1.x509.X509CertificateStructure;

public class CertificateChoices
extends CMSObject {
    private DEREncodable cert;

    public CertificateChoices(X509CertificateStructure x509CertificateStructure) {
        this.setCertificate(x509CertificateStructure);
    }

    public CertificateChoices(ExtendedCertificate extendedCertificate) {
        this.setCertificate(extendedCertificate);
    }

    public CertificateChoices(DERObject dERObject) {
        block5: {
            block4: {
                if (!(dERObject instanceof ASN1TaggedObject)) break block4;
                ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)dERObject;
                switch (aSN1TaggedObject.getTagNo()) {
                    case 0: {
                        this.cert = ExtendedCertificate.getInstance(aSN1TaggedObject, false);
                        break block5;
                    }
                    case 1: {
                        throw new IllegalArgumentException("Invalid Certificate Choices -- AttributeCertificate not supported");
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid CertificateChoices -- Bad tag: " + aSN1TaggedObject.getTagNo());
                    }
                }
            }
            this.cert = X509CertificateStructure.getInstance(dERObject);
        }
    }

    public CertificateChoices(CertificateChoices certificateChoices) {
        this.cert = certificateChoices.cert;
    }

    public static CertificateChoices getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return CertificateChoices.getInstance(aSN1TaggedObject.getObject());
    }

    public static CertificateChoices getInstance(Object object) {
        if (object == null || object instanceof CertificateChoices) {
            return (CertificateChoices)object;
        }
        if (object instanceof X509CertificateStructure) {
            return new CertificateChoices((X509CertificateStructure)object);
        }
        if (object instanceof ExtendedCertificate) {
            return new CertificateChoices((ExtendedCertificate)object);
        }
        if (object instanceof DERObject) {
            return new CertificateChoices((DERObject)object);
        }
        throw new IllegalArgumentException("Invalid CertificateChoices: " + object.getClass().getName());
    }

    public DEREncodable getCertificate() {
        return this.cert;
    }

    public DERObject getDERObject() {
        if (this.cert instanceof ExtendedCertificate) {
            return new BERTaggedObject(false, 0, this.cert.getDERObject());
        }
        return this.cert.getDERObject();
    }

    private void setCertificate(X509CertificateStructure x509CertificateStructure) {
        this.cert = x509CertificateStructure;
    }

    private void setCertificate(ExtendedCertificate extendedCertificate) {
        this.cert = extendedCertificate;
    }
}

