/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;

public class Digest
extends CMSObject {
    private ASN1OctetString digest;

    public Digest(byte[] byArray) {
        this.setDigest(byArray);
    }

    public Digest(ASN1OctetString aSN1OctetString) {
        this.digest = aSN1OctetString;
    }

    public Digest(Digest digest) {
        this.digest = digest.digest;
    }

    public static Digest getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return Digest.getInstance(ASN1OctetString.getInstance(aSN1TaggedObject, bl));
    }

    public static Digest getInstance(Object object) {
        if (object == null || object instanceof Digest) {
            return (Digest)object;
        }
        if (object instanceof ASN1OctetString) {
            return new Digest((ASN1OctetString)object);
        }
        throw new IllegalArgumentException("Invalid Digest: " + object.getClass().getName());
    }

    public byte[] getDigest() {
        return this.digest.getOctets();
    }

    public DERObject getDERObject() {
        return this.digest;
    }

    private void setDigest(byte[] byArray) {
        this.digest = new BERConstructedOctetString(byArray);
    }
}

