/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.pkcs;

import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class EncryptedData
implements DEREncodable {
    DERConstructedSequence data;
    DERObjectIdentifier bagId;
    DERObject bagValue;

    public EncryptedData(ASN1Sequence aSN1Sequence) {
        int n = ((DERInteger)aSN1Sequence.getObjectAt(0)).getValue().intValue();
        if (n != 0) {
            throw new IllegalArgumentException("sequence not version 0");
        }
        this.data = (DERConstructedSequence)aSN1Sequence.getObjectAt(1);
    }

    public EncryptedData(DERObjectIdentifier dERObjectIdentifier, AlgorithmIdentifier algorithmIdentifier, DEREncodable dEREncodable) {
        this.data = new BERConstructedSequence();
        this.data.addObject(dERObjectIdentifier);
        this.data.addObject(algorithmIdentifier.getDERObject());
        this.data.addObject(new BERTaggedObject(false, 0, dEREncodable));
    }

    public DERObjectIdentifier getContentType() {
        return (DERObjectIdentifier)this.data.getObjectAt(0);
    }

    public AlgorithmIdentifier getEncryptionAlgorithm() {
        return AlgorithmIdentifier.getInstance(this.data.getObjectAt(1));
    }

    public ASN1OctetString getContent() {
        if (this.data.getSize() == 3) {
            DERTaggedObject dERTaggedObject = (DERTaggedObject)this.data.getObjectAt(2);
            return ASN1OctetString.getInstance(dERTaggedObject.getObject());
        }
        return null;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(new DERInteger(0));
        bERConstructedSequence.addObject(this.data);
        return bERConstructedSequence;
    }
}

