/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.smime;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.CBCParameter;
import org.bouncycastle.asn1.cms.IV;
import org.bouncycastle.asn1.cms.RC2CBCParameter;
import org.bouncycastle.asn1.smime.SMIMEObjectIdentifiers;

public class SMIMECapability
implements DEREncodable {
    private DERObjectIdentifier capabilityID;
    private DEREncodable parameters;

    public static SMIMECapability RC2_CBC_40_MS() {
        return new SMIMECapability(SMIMEObjectIdentifiers.rC2_CBC, new DERInteger(40));
    }

    public static SMIMECapability RC2_CBC_64_MS() {
        return new SMIMECapability(SMIMEObjectIdentifiers.rC2_CBC, new DERInteger(64));
    }

    public static SMIMECapability RC2_CBC_128_MS() {
        return new SMIMECapability(SMIMEObjectIdentifiers.rC2_CBC, new DERInteger(128));
    }

    public static SMIMECapability RC2_CBC_40(byte[] byArray) {
        if (byArray == null) {
            return SMIMECapability.RC2_CBC_40_MS();
        }
        return new SMIMECapability(SMIMEObjectIdentifiers.rC2_CBC, new RC2CBCParameter(new BigInteger("160"), byArray));
    }

    public static SMIMECapability RC2_CBC_64(byte[] byArray) {
        if (byArray == null) {
            return SMIMECapability.RC2_CBC_64_MS();
        }
        return new SMIMECapability(SMIMEObjectIdentifiers.rC2_CBC, new RC2CBCParameter(new BigInteger("120"), byArray));
    }

    public static SMIMECapability RC2_CBC_128(byte[] byArray) {
        if (byArray == null) {
            return SMIMECapability.RC2_CBC_128_MS();
        }
        return new SMIMECapability(SMIMEObjectIdentifiers.rC2_CBC, new RC2CBCParameter(new BigInteger("58"), byArray));
    }

    public static SMIMECapability DES_EDE_CBC_MS() {
        return new SMIMECapability(SMIMEObjectIdentifiers.dES_EDE3_CBC, null);
    }

    public static SMIMECapability DES_EDE_CBC(byte[] byArray) {
        if (byArray == null) {
            return SMIMECapability.DES_EDE_CBC_MS();
        }
        return new SMIMECapability(SMIMEObjectIdentifiers.dES_EDE3_CBC, new CBCParameter(new IV(byArray)));
    }

    public SMIMECapability(ASN1Sequence aSN1Sequence) {
        this.capabilityID = (DERObjectIdentifier)aSN1Sequence.getObjectAt(0);
        if (aSN1Sequence.getSize() > 1) {
            this.parameters = (DERObject)aSN1Sequence.getObjectAt(1);
        }
    }

    public SMIMECapability(SMIMECapability sMIMECapability) {
        this.capabilityID = sMIMECapability.capabilityID;
        this.parameters = sMIMECapability.parameters;
    }

    public SMIMECapability(DERObjectIdentifier dERObjectIdentifier, DEREncodable dEREncodable) {
        this.capabilityID = dERObjectIdentifier;
        this.parameters = dEREncodable;
    }

    public static SMIMECapability getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return SMIMECapability.getInstance(aSN1TaggedObject.getObject());
    }

    public static SMIMECapability getInstance(Object object) {
        if (object == null || object instanceof SMIMECapability) {
            return (SMIMECapability)object;
        }
        if (object instanceof ASN1Sequence) {
            return new SMIMECapability((ASN1Sequence)object);
        }
        if (object instanceof ASN1TaggedObject) {
            return SMIMECapability.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid SMIMECapability");
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.capabilityID);
        if (this.parameters != null) {
            dERConstructedSequence.addObject(this.parameters);
        }
        return dERConstructedSequence;
    }
}

