/*
 *	OutEvent.java		2002/11/17
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.core;

/** 
 * The OutEvent class is an abstract class representing an event that is sent by the UI to the server - processed by a connection Handler.
 * @author Alistair K Phipps
 * @version 2002/11/17
 */
public abstract class OutEvent
{
	private Entity _eDest;

	/** Ctor used by subclasses to set destination
	 * @param eDest destination entity
	 */
	protected OutEvent( Entity eDest )
	{
		_eDest = eDest;
	}
	
	/** Retrieve the destination entity
	 * @return destination entity
	 */
	public Entity getDest()
	{
		return _eDest;
	}
}
