/*
 *	SILCDisconnectPayload.java		2002/11/13
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.silcprotocol;

import java.lang.String;
import com.alistairphipps.util.Hex;
import java.nio.ByteBuffer;

/** Class to implement a Disconnect payload
 *
 * @author Alistair K Phipps
 * @version 20021113
 */
public class SILCDisconnectPayload extends SILCPayload
{
	private byte _yStatus;
	private String _strReason;
	
	/** Constructor to set up the payload with default values.
	 */
	public SILCDisconnectPayload() 
	{
		_yStatus = (byte)0;
		_strReason = "";
	}

	/** Constructor to set up the payload information from a bytelist
	 * @param yl List of bytes forming received payload
	 */
	public SILCDisconnectPayload( byte[] yl )
	{
		assert( yl.length >= 1 ); // must always have status byte
		ByteBuffer yb = ByteBuffer.wrap( yl );
		_yStatus = yb.get();	// get status byte
		// retrieve UTF8 string
		_strReason = s_csUTF8.decode( yb ).toString();;
	}
	
	// doc inherited
	public byte[] toByteList()
	{
		ByteBuffer ybReason = s_csUTF8.encode( _strReason );
		ByteBuffer yb = ByteBuffer.allocate( 1 + ybReason.limit() );
		yb.put( _yStatus );
		yb.put( ybReason );
		return yb.array();
	}

	// doc inherited
	public String toString()
	{
		String strRet;
		strRet = "Disconnect Reason: " + SILCStatusType.toString( _yStatus );
		strRet += "\nDisconnect Message: " + _strReason;
		return strRet;
	}

	public boolean isList()
	{
		return false;
	}
}
