/*
 *	SILCPrivateMessagePayload.java		2002/11/14
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.silcprotocol;

import java.lang.*;
import java.security.SecureRandom;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import com.alistairphipps.util.Hex;

/** Class to implement a Private Message payload
 *
 * @author Alistair K Phipps
 * @version 20021114
 */
public class SILCPrivateMessagePayload extends SILCPayload
{
	/** message is auto-reply */
	private boolean _bAutoReply;

	/** do not reply to this message */
	private boolean _bNoReply;

	/** message is an action */
	private boolean _bAction;

	/** message is informational notice */
	private boolean _bNotice;

	/** generic request flag */
	private boolean _bRequest;

	/** message is signed with sender's private key */
	private boolean _bSigned;

	/** generic reply flag */
	private boolean _bReply;

	/** generic data flag */
	private boolean _bData;
	
	/** message */
	private String _strMessage;

	/** Constructor to set up the payload with specified values.
	 */
	public SILCPrivateMessagePayload( boolean bAction, String strMessage ) 
	{	// TODO: allow setting other flags
		_bAction = bAction;
		_strMessage = strMessage;
	}

	/** Constructor to set up the payload information from a bytelist - the decrypted payload information received in a packet.
	 * @param yl List of bytes forming received payload
	 */
	public SILCPrivateMessagePayload( byte[] yl )
	{
		ByteBuffer yb = ByteBuffer.wrap( yl );
		short sFlags = yb.getShort();
		_bAutoReply = ( ( sFlags & 0x0001 ) != 0 ) ? true : false;
		_bNoReply = ( ( sFlags & 0x0002 ) != 0 ) ? true : false;
		_bAction = ( ( sFlags & 0x0004 ) != 0 ) ? true : false;
		_bNotice = ( ( sFlags & 0x0008 ) != 0 ) ? true : false;
		_bRequest = ( ( sFlags & 0x0010 ) != 0 ) ? true : false;
		_bSigned = ( ( sFlags & 0x0020 ) != 0 ) ? true : false;
		_bReply = ( ( sFlags & 0x0040 ) != 0 ) ? true : false;
		_bData = ( ( sFlags & 0x0080 ) != 0 ) ? true : false;
		_strMessage = readShortAndString( yb );
	}
	
	// doc inherited
	public byte[] toByteList()
	{
		ByteBuffer ybMessage = writeShortAndString( _strMessage );

		ByteBuffer yb = ByteBuffer.allocate( 2 + ybMessage.limit() );
		short sFlags = 0;
		sFlags |= _bAutoReply ? 0x0001 : 0;
		sFlags |= _bNoReply ? 0x0002 : 0;
		sFlags |= _bAction ? 0x0004 : 0; 
		sFlags |= _bNotice ? 0x0008 : 0;
		sFlags |= _bRequest ? 0x0010 : 0;
		sFlags |= _bSigned ? 0x0020 : 0;
		sFlags |= _bReply ? 0x0040 : 0;
		sFlags |= _bData ? 0x0080 : 0;
		yb.putShort( sFlags );
		yb.put( ybMessage );

		return yb.array();
	}

	// doc inherited
	public String toString()
	{
		String strRet;
		strRet = "AutoReply: " + Boolean.toString( _bAutoReply );
		strRet += "\nNoReply: " + Boolean.toString( _bNoReply );
		strRet += "\nAction: " + Boolean.toString( _bAction );
		strRet += "\nNotice: " + Boolean.toString( _bNotice );
		strRet += "\nRequest: " + Boolean.toString( _bRequest );
		strRet += "\nSigned: " + Boolean.toString( _bSigned );
		strRet += "\nReply: " + Boolean.toString( _bReply );
		strRet += "\nData: " + Boolean.toString( _bData );
		strRet += "\nMessage: " + _strMessage;
		return strRet;
	}

	public boolean isList()
	{
		return false;
	}

	public String getMessage()
	{
		return _strMessage;
	}
}
