/*

  silcenv.h

  Author: Pekka Riikonen <priikone@silcnet.org>

  Copyright (C) 2007 - 2008 Pekka Riikonen

  The contents of this file are subject to one of the Licenses specified 
  in the COPYING file;  You may not use this file except in compliance 
  with the License.

  The software distributed under the License is distributed on an "AS IS"
  basis, in the hope that it will be useful, but WITHOUT WARRANTY OF ANY
  KIND, either expressed or implied.  See the COPYING file for more
  information.

*/

/****h* silcutil/Environment Interface
 *
 * DESCRIPTION
 *
 * This interface provides utility functions for manipulating environment
 * variables.  On platforms that do not support environment variables this
 * interfaces does nothing.
 *
 ***/

#ifndef SILCENV_H
#define SILCENV_H

/****f* silcutil/silc_setenv
 *
 * SYNOPSIS
 *
 *    SilcBool silc_setenv(const char *variable, const char *value);
 *
 * DESCRIPTION
 *
 *    Sets the environment variable named `variable' with value `value'
 *    to the environment.  If the `variable' already exists in the
 *    environment its value is changed to `value'.  Returns FALSE if the
 *    value could not be set or if environment variables are not supported.
 *
 ***/
SilcBool silc_setenv(const char *variable, const char *value);

/****f* silcutil/silc_getenv
 *
 * SYNOPSIS
 *
 *    const char *silc_getenv(const char *variable);
 *
 * DESCRIPTION
 *
 *    Returns the value of the environment variable `variable' or NULL if
 *    such variable does not exist in the environment.
 *
 ***/
const char *silc_getenv(const char *variable);

/****f* silcutil/silc_unsetenv
 *
 * SYNOPSIS
 *
 *    SilcBool silc_unsetenv(const char *variable);
 *
 * DESCRIPTION
 *
 *    Clears the value of the environment variable `variable'.  Returns FALSE
 *    if the value could not be cleared or if environment variables are not
 *    supported.
 *
 ***/
SilcBool silc_unsetenv(const char *variable);

/****f* silcutil/silc_clearenv
 *
 * SYNOPSIS
 *
 *    SilcBool silc_clearenv(void);
 *
 * DESCRIPTION
 *
 *    Clears the environment of all environment variables.  Returns FALSE
 *    if the environment could not be cleared or if environment variables are
 *    not supported.
 *
 ***/
SilcBool silc_clearenv(void);

#endif /* SILCENV_H */
