/*

  silcbeosmutex.c 

  Author: Pekka Riikonen <priikone@silcnet.org>

  Copyright (C) 2002 Pekka Riikonen

  The contents of this file are subject to one of the Licenses specified 
  in the COPYING file;  You may not use this file except in compliance 
  with the License.

  The software distributed under the License is distributed on an "AS IS"
  basis, in the hope that it will be useful, but WITHOUT WARRANTY OF ANY
  KIND, either expressed or implied.  See the COPYING file for more
  information.

*/
/* I used Apache's APR code as a reference here. */
/* $Id: silcbeosmutex.c,v 1.3 2002/02/20 20:53:14 priikone Exp $ */

#include "silcincludes.h"

#ifdef SILC_THREADS

/* SILC Mutex structure */
struct SilcMutexStruct {
  sem_id sema;
};

bool silc_mutex_alloc(SilcMutex *mutex)
{
  int ret;

  *mutex = silc_calloc(1, sizeof(**mutex));
  if (*mutex == NULL)
    return FALSE;

  ret = create_sem(0, "SILC_MUTEX");
  if (ret < B_NO_ERROR) {
    silc_free(*mutex);
    return FALSE;
  }

  (*mutex)->sema = ret;

  return TRUE;
}

void silc_mutex_free(SilcMutex mutex)
{
  delete_sem(mutex->sema);
  silc_free(mutex);
}

void silc_mutex_lock(SilcMutex mutex)
{
  if (acquire_sem(mutex->sema) < B_NO_ERROR)
    assert(FALSE);
}

void silc_mutex_unlock(SilcMutex mutex)
{
  if (release_sem(mutex->sema) < B_NO_ERROR)
    assert(FALSE);
}

#endif /* SILC_THREADS */
